/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.symbols.BboxRectangle;
import hades.symbols.BusPortSymbol;
import hades.symbols.ClassLabel;
import hades.symbols.InstanceLabel;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class MergeBits
extends GenericRtlibObject {
    PortStdLogicVector port_Y;
    PortStdLogic1164[] port_A;

    public void constructPorts() {
        this.ports = new Port[this.n_bits + 1];
        this.port_A = new PortStdLogic1164[this.n_bits];
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.ports[0] = this.port_Y;
        int i = 0;
        while (i < this.n_bits) {
            this.port_A[i] = new PortStdLogic1164(this, "A" + i, 0, null);
            this.ports[1 + i] = this.port_A[i];
            ++i;
        }
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        if (SimObject.debug) {
            this.message("-#- MergeBits.cDS...");
        }
        this.symbol = new Symbol();
        this.symbol.setParent(this);
        this.initDisplay();
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.initDisplay();
    }

    public void initDisplay() {
        PortLabel portLabel;
        int y;
        int x;
        PortSymbol portSymbol;
        if (SimObject.debug) {
            this.message("-#- Register.initDisplay...");
        }
        if (this.symbol == null) {
            return;
        }
        if (this.symbol != null) {
            this.symbol.deleteAllMembers();
        }
        Point pos = this.symbol.getPos();
        this.symbol.move(-pos.x, -pos.y);
        BboxRectangle bbr = new BboxRectangle();
        int w = 600;
        int xmax = (1 + this.n_bits) * w;
        bbr.initialize(" 0 0 " + xmax + " 1200");
        Rectangle rr = new Rectangle();
        rr.initialize("  0 0 " + xmax + " 1200");
        InstanceLabel il = new InstanceLabel();
        il.initialize("" + (xmax + 100) + " 450 " + this.getName());
        ClassLabel cl = new ClassLabel();
        cl.initialize("" + (xmax + 100) + " 1150 " + " MergeBits");
        this.symbol.fastAddMember(cl);
        this.symbol.fastAddMember(bbr);
        this.symbol.fastAddMember(rr);
        this.symbol.fastAddMember(il);
        int i = 0;
        while (i < this.n_bits) {
            portSymbol = new PortSymbol();
            x = (this.n_bits - i) * w;
            y = 0;
            portSymbol.initialize("" + x + " " + y + " A" + i);
            this.symbol.fastAddMember(portSymbol);
            portLabel = new PortLabel();
            portLabel.initialize("" + x + " " + (y + 450) + " 2 A" + i);
            this.symbol.fastAddMember(portLabel);
            ++i;
        }
        portSymbol = new BusPortSymbol();
        x = 600;
        y = 1200;
        portSymbol.initialize("" + x + " " + y + " Y");
        this.symbol.fastAddMember(portSymbol);
        portLabel = new PortLabel();
        portLabel.initialize("" + x + " " + (y - 150) + " 2 Y");
        this.symbol.fastAddMember(portLabel);
        this.symbol.update_bbox();
        this.symbol.build_sc_bbox();
        this.symbol.setTrafo(this.symbol.getTrafo());
        this.symbol.setObjectPainter(this.symbol.painter);
        this.symbol.move(pos.x, pos.y);
    }

    public void setWidth(int _n) {
        if (_n == this.getWidth()) {
            return;
        }
        if (this.isConnected()) {
            this.message("-E- Cannot change the width of an connected RTLIB object!");
            return;
        }
        if (this.n_bits < 1 || this.n_bits > 32) {
            this.message("-E- Bus width out of range [1..32], using 16 instead!");
            this.n_bits = 16;
        } else {
            this.n_bits = _n;
        }
        this.constructStandardValues();
        this.constructPorts();
        this.initDisplay();
        this.updateSymbol();
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        this.vector = new StdLogicVector(this.getWidth());
        int i = 0;
        while (i < this.n_bits) {
            StdLogic1164 value_i = this.port_A[i].getValueOrU();
            this.vector.setBitAt(i, value_i);
            ++i;
        }
        simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
    }

    public void updateSymbol() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbol.painter.paint(this.symbol, 1);
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output delay           [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value\n");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString();
    }
}

