/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.symbols.ColorSource;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.ColoredValueLabel;
import hades.symbols.Symbol;
import hades.symbols.TextSource;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.objects.FigObject;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class GenericRtlibObject
extends SimObject
implements Simulatable,
Wakeable,
Serializable {
    protected int n_bits = 16;
    protected StdLogicVector vector;
    protected StdLogicVector vector_UUU;
    protected StdLogicVector vector_XXX;
    protected StdLogicVector vector_ZZZ;
    protected StdLogicVector vector_000;
    protected StdLogicVector vector_111;
    protected PortStdLogicVector vectorOutputPort;
    protected double delay = this.defaultdelay = 1.0E-8;
    protected double defaultdelay;
    protected boolean enableAnimationFlag;
    protected ColoredValueLabel valueLabel;
    protected FlexibleLabelFormatter labelFormatter;
    public static final int DECIMAL = 0;
    public static final int HEX = 1;
    public static final int BINARY = 2;

    public GenericRtlibObject() {
        this.constructStandardValues();
        this.constructPorts();
        this.enableAnimationFlag = SetupManager.getBoolean("Hades.LayerTable.RtlibAnimation", false);
    }

    protected void constructPorts() {
        this.ports = null;
        this.vectorOutputPort = null;
    }

    protected void constructStandardValues() {
        this.vector_UUU = new StdLogicVector(this.n_bits, Const1164.__U);
        this.vector_XXX = new StdLogicVector(this.n_bits, Const1164.__X);
        this.vector_ZZZ = new StdLogicVector(this.n_bits, Const1164.__Z);
        this.vector_000 = new StdLogicVector(this.n_bits, Const1164.__0);
        this.vector_111 = new StdLogicVector(this.n_bits, Const1164.__1);
        this.vector = this.vector_UUU.copy();
    }

    public boolean getEnableAnimationFlag() {
        return this.enableAnimationFlag;
    }

    public void setEnableAnimationFlag(boolean b) {
        this.enableAnimationFlag = b;
    }

    public void setEnableAnimationFlag(String s) {
        try {
            this.setEnableAnimationFlag(s.trim().toLowerCase().startsWith("t"));
        }
        catch (Exception e) {
            this.message("-E- illegal value for setEnableAnimationFlag, using false");
            this.setEnableAnimationFlag(false);
        }
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double _delay) {
        this.delay = _delay < 0.0 ? this.defaultdelay : _delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = new Double(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultdelay);
            this.delay = this.defaultdelay;
        }
    }

    public int getWidth() {
        return this.n_bits;
    }

    public void setWidth(int _n) {
        if (_n == this.getWidth()) {
            return;
        }
        if (this.isConnected()) {
            this.message("-E- Cannot change the width of an connected RTLIB object!");
            return;
        }
        if (this.n_bits < 1 || (long)this.n_bits > 62L) {
            this.message("-E- Bus width out of range [1..62], using 16 instead!");
            this.n_bits = 16;
        } else {
            this.n_bits = _n;
        }
        this.constructStandardValues();
        this.constructPorts();
        this.updateSymbol();
    }

    public void setWidth(String s) {
        int n;
        try {
            n = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.message("-E- GenericRtlibObject.setWidth: illegal argument" + e);
            this.message("-E- using a width of 16 bits instead!");
            n = 16;
        }
        this.setWidth(n);
    }

    public long getValue() {
        return this.vector.getValue();
    }

    public void setValue(long _value) {
        this.vector = new StdLogicVector(this.n_bits, _value);
        this.updateSymbol();
        this.scheduleVectorOutputPort();
    }

    public void setValue(String s) {
        this.vector = this.vector.copy();
        this.vector.parse(s);
        this.updateSymbol();
        this.scheduleVectorOutputPort();
    }

    public String getFormattedValue() {
        if (this.labelFormatter != null) {
            return this.labelFormatter.getText();
        }
        return "" + this.getValue();
    }

    public void setFormattedValue(String s) {
        this.setValue(s);
    }

    protected void scheduleVectorOutputPort() {
        if (this.vectorOutputPort != null) {
            StdLogicVector clone = this.vector.copy();
            this.scheduleAfter(0.0, (Port)this.vectorOutputPort, clone);
        }
    }

    public void setNumberFormat(int i) {
        if (this.labelFormatter == null) {
            return;
        }
        this.labelFormatter.setNumberFormat(i);
    }

    public void setNumberFormat(String s) {
        if (this.labelFormatter == null) {
            return;
        }
        try {
            this.labelFormatter.setNumberFormat(Integer.parseInt(s.trim()));
        }
        catch (Exception e) {
            this.message("-W- Illegal number format '" + s + "', using HEX instead.");
            this.labelFormatter.setNumberFormat(1);
        }
    }

    public int getNumberFormat() {
        if (this.labelFormatter != null) {
            return this.labelFormatter.getNumberFormat();
        }
        return 1;
    }

    public boolean isConnected() {
        if (this.ports == null) {
            return false;
        }
        int i = 0;
        while (i < this.ports.length) {
            if (this.ports[i].getSignal() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number of bits [1 .. 62]:", "width", "output value [0..1ZX_b]:", "formattedValue", "output delay [sec]:", "delay", "enable animation: [T/F]", "enableAnimationFlag", "format[0=dec, 1=hex, 2=bin]:", "numberFormat"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setVisible(true);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand the output value. Recognized formats:\nbinary: 0100ZXH0_b,\nhex:    abcd_h\ndecimal: 4711\n");
        this.propertySheet.setVisible(true);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.initValueLabel();
        this.updateSymbol();
    }

    protected void initValueLabel() {
        try {
            if (this.symbol == null) {
                return;
            }
            FigObject tmp = null;
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (!(tmp instanceof ColoredValueLabel)) continue;
                this.labelFormatter = new FlexibleLabelFormatter();
                this.valueLabel = (ColoredValueLabel)tmp;
                this.valueLabel.setTextSource(this.labelFormatter);
                this.valueLabel.setColorSource(new DINColorSource());
            }
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initValueLabel(): " + e);
            e.printStackTrace();
        }
    }

    public void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: " + this.vector);
        }
        if (!this.enableAnimationFlag) {
            return;
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbol.painter.paint(this.symbol, 50);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.updateSymbol();
    }

    public void wakeup(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".wakeup()");
        }
        try {
            WakeupEvent evt = (WakeupEvent)arg;
            Object tmp = evt.getArg();
            if (tmp instanceof StdLogicVector) {
                StdLogicVector slv = (StdLogicVector)tmp;
                this.vector = slv.copy();
            }
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + arg);
        }
        if (this.enableAnimationFlag) {
            this.updateSymbol();
        }
    }

    public void scheduleAfter(double t_delay, Port port, Object value) {
        if (value == null) {
            return;
        }
        if (port == null) {
            return;
        }
        SimKernel simulator = this.getSimulator();
        Signal signal = port.getSignal();
        if (simulator == null) {
            return;
        }
        if (signal == null) {
            return;
        }
        simulator.scheduleEvent(new SimEvent(signal, simulator.getSimTime() + t_delay, value, port));
    }

    public void scheduleAfter(double t_delay, Port port, StdLogic1164 value) {
        if (value == null) {
            return;
        }
        if (port == null) {
            return;
        }
        SimKernel simulator = this.getSimulator();
        Signal signal = port.getSignal();
        if (simulator == null) {
            return;
        }
        if (signal == null) {
            return;
        }
        simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, simulator.getSimTime() + t_delay, value, (Object)port));
    }

    public void wakeupAfter(double t_delay) {
        SimKernel simulator = this.getSimulator();
        if (simulator == null) {
            return;
        }
        simulator.scheduleWakeup(this, simulator.getSimTime() + t_delay, this);
    }

    public void assign(String value, double simTime) {
        try {
            Signal signal = null;
            StdLogicVector tmp = new StdLogicVector(this.n_bits);
            tmp.parse(value);
            signal = this.vectorOutputPort.getSignal();
            if (signal != null) {
                this.simulator.scheduleEvent(new SimEvent(signal, simTime, tmp, this.vectorOutputPort));
            }
            if (this.visible) {
                this.simulator.scheduleWakeup(this, simTime, tmp);
            }
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".assign: " + value);
        }
    }

    public boolean initialize(String s) {
        block7: {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            try {
                if (n_tokens == 0) {
                    this.versionId = 1001L;
                    this.n_bits = 16;
                    this.constructStandardValues();
                    this.constructPorts();
                    break block7;
                }
                if (n_tokens == 1) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = 16;
                    this.constructStandardValues();
                    this.constructPorts();
                    break block7;
                }
                if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = Integer.parseInt(st.nextToken());
                    this.constructStandardValues();
                    this.constructPorts();
                    break block7;
                }
                if (n_tokens == 3) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = Integer.parseInt(st.nextToken());
                    this.constructStandardValues();
                    this.constructPorts();
                    String sv = st.nextToken();
                    this.setValue(sv);
                    break block7;
                }
                if (n_tokens == 4) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = Integer.parseInt(st.nextToken());
                    this.constructStandardValues();
                    this.constructPorts();
                    this.setValue(st.nextToken());
                    this.setDelay(st.nextToken());
                    break block7;
                }
                throw new Exception("invalid number of arguments");
            }
            catch (Exception e) {
                this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
                e.printStackTrace();
            }
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.vector.toBinString() + " " + this.delay);
    }

    public SimObject copy() {
        GenericRtlibObject tmp = null;
        try {
            tmp = (GenericRtlibObject)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.setWidth(this.getWidth());
            tmp.setValue(this.getValue());
            tmp.setDelay(this.getDelay());
            tmp.setVersionId(this.getVersionId());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in GenericRtlibObject.copy(): " + e);
            e.printStackTrace();
            ExceptionTracer.trace(e);
            return null;
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toBinString() + "\n" + this.vector.toHexString() + " / " + this.vector.toDecString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getFullName();
    }

    public void warning(String s) {
        System.out.println("-W- " + this.toString() + "." + s);
        this.message("-W- " + this.toString() + "." + s);
    }

    public class FlexibleLabelFormatter
    implements TextSource {
        private int numberFormat = 1;

        public int getNumberFormat() {
            return this.numberFormat;
        }

        public void setNumberFormat(int i) {
            this.numberFormat = i;
        }

        public String getText() {
            String sValue;
            switch (this.numberFormat) {
                case 2: {
                    sValue = GenericRtlibObject.this.vector.toBinString();
                    break;
                }
                case 0: {
                    sValue = GenericRtlibObject.this.vector.toDecString();
                    break;
                }
                case 1: {
                    sValue = GenericRtlibObject.this.vector.toHexString();
                    break;
                }
                default: {
                    sValue = GenericRtlibObject.this.vector.toHexString();
                }
            }
            return sValue;
        }
    }

    public class BinaryValueLabelFormatter
    implements TextSource {
        public String getText() {
            return GenericRtlibObject.this.vector.toBinString();
        }
    }

    public class DecimalValueLabelFormatter
    implements TextSource {
        public String getText() {
            return GenericRtlibObject.this.vector.toDecString();
        }
    }

    public class HexValueLabelFormatter
    implements TextSource {
        public String getText() {
            return GenericRtlibObject.this.vector.toHexString();
        }
    }

    public class DINColorSource
    implements ColorSource {
        public Color getColor() {
            return Color_DIN_IEC_62.getColor(GenericRtlibObject.this.vector.getValue());
        }
    }
}

