/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtl;

import hades.gui.MemoryEditorFrame;
import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.models.memory.Memory;
import hades.models.memory.MemoryListener;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.utils.ExceptionTracer;

public class ROM_1Kx8
extends SimObject
implements Memory {
    protected StdLogic1164 output_0;
    protected StdLogic1164 output_1;
    protected StdLogic1164 output_X;
    protected StdLogic1164 output_Z;
    protected Port port_nCS;
    protected Port port_nOE;
    protected int n_address_ports;
    protected int n_words;
    protected int index_a0;
    protected int index_y0;
    protected long[] data;
    public static final int DISABLED = -2;
    public static final int UNDEFINED = -1;
    public static final int TRISTATED = -2;
    String resourcename = "/hades/models/rtl/ROM_1Kx8.rom";
    protected Hashtable _listenerTable;
    protected MemoryEditorFrame MEF = null;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;

    public ROM_1Kx8() {
        this.setSizeConstants();
        this.createPorts();
        this.createDataArray();
        this.output_X = Const1164.__X;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
        this.output_Z = Const1164.__Z;
        this.initROM();
    }

    public void setSizeConstants() {
        this.n_words = 1024;
        this.n_address_ports = 10;
    }

    public void createPorts() {
        this.ports = new Port[10 + this.n_address_ports];
        this.ports[0] = new Port(this, "nCS", 0, null);
        this.ports[1] = new Port(this, "nOE", 0, null);
        int i = 2;
        while (i < 10) {
            this.ports[i] = new Port(this, "Y" + (i - 2), 1, null);
            ++i;
        }
        int i2 = 10;
        while (i2 < this.ports.length) {
            this.ports[i2] = new Port(this, "A" + (i2 - 10), 0, null);
            ++i2;
        }
        this.port_nCS = this.ports[0];
        this.port_nOE = this.ports[1];
        this.index_y0 = 2;
        this.index_a0 = 10;
    }

    public void createDataArray() {
        this.data = new long[this.n_words];
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.getResourcename()};
        return externals;
    }

    public void initROM() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = -1L;
            ++i;
        }
    }

    public void printSramContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("-I- " + this.toString() + "contents:");
        int i = 0;
        while (i < this.data.length) {
            sb.append("   " + i + " ");
            if (this.data[i] == -1L) {
                sb.append("XXXX");
            } else {
                sb.append("" + Long.toString(this.data[i], 16));
            }
            sb.append("\n");
            ++i;
        }
        this.message(sb.toString());
    }

    public String getResourcename() {
        return this.resourcename;
    }

    public void setResourcename(String s) {
        this.resourcename = s;
        this.initialize("" + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(s));
    }

    public boolean initialize(String s) {
        this.resourcename = "";
        try {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            if (n_tokens == 1) {
                this.versionId = 1001L;
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (n_tokens == 2) {
                this.versionId = Integer.parseInt(st.nextToken());
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                throw new Exception("need 1 or 2 args, but got: " + s);
            }
            this.parseRAM(this.resourcename);
        }
        catch (Exception e) {
            this.message("-E- ROM_1Kx8.initialize(): " + e);
            this.message("-E- offending input is '" + s + "'");
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.resourcename));
    }

    public void parseRAM(String resourcename) {
        InputStream is = null;
        BufferedReader br = null;
        this.message("-I- ROM: parsing '" + resourcename + "'");
        try {
            is = DesignManager.getDesignManager().getInputStream(this, resourcename);
            br = new BufferedReader(new InputStreamReader(is));
            this.parse(br);
        }
        catch (Exception e) {
            this.message("-E- in ROM_1Kx8.parseRAM(): " + e);
            ExceptionTracer.trace(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean parse(BufferedReader br) {
        line = null;
        valueString = null;
        addr = 0;
        row = 0L;
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                st = new StringTokenizer(line, " \t:");
                addr = Integer.parseInt(st.nextToken(), 16);
                valueString = st.nextToken();
                if (valueString.length() != 2) ** GOTO lbl19
                row = Long.parseLong(valueString, 16);
                this.setDataAt(addr, row);
                continue;
lbl-1000:
                // 1 sources

                {
                    row = Long.parseLong(valueString.substring(0, 2), 16);
                    this.setDataAt(addr, row);
                    ++addr;
                    valueString = valueString.substring(2, valueString.length());
lbl19:
                    // 2 sources

                    ** while (valueString.length() >= 2)
                }
lbl20:
                // 1 sources

            }
        }
        catch (Exception e) {
            this.message("-E- in ROM_1Kx8.parseRAM(): " + e);
            this.message("-I- last line was '" + line + "'");
            ExceptionTracer.trace(e);
            return false;
        }
        return true;
    }

    public void setDataAt(int address, long value) {
        if (address < 0 || address > this.data.length - 1) {
            this.message("-E- RAM.setDataAt(): out-of-range address: " + address);
            this.message("-W- address and data ignored!");
            return;
        }
        if (value != -1L) {
            value &= 0xFFL;
        }
        this.data[address] = value;
        if (this.MEF != null && this.MEF.isVisible()) {
            this.MEF.repaint();
        }
    }

    public long getDataAt(int address) {
        return this.data[address];
    }

    public int getBitsPerWord() {
        return 8;
    }

    public void setBitsPerWord(int n_bits) throws Exception {
        throw new Exception("Cannot change the ROM_1Kx8 width!");
    }

    public int getSize() {
        return this.data.length;
    }

    public void setSize(int n_words) throws Exception {
        throw new Exception("Cannot change the ROM_1Kx8 size!");
    }

    public boolean canChangeSize() {
        return false;
    }

    public boolean resize(int n_words, int n_bits_per_word) throws Exception {
        throw new Exception("Cannot change the ROM_1Kx8 size!");
    }

    public long[] getDataArray() {
        return this.data;
    }

    public void setDataArray(long[] data) {
        this.data = data;
    }

    public boolean merge(BufferedReader reader) {
        return this.parse(reader);
    }

    public void addMemoryListener(MemoryListener ML) {
        try {
            if (this._listenerTable == null) {
                this._listenerTable = new Hashtable();
            }
            this._listenerTable.put(ML, ML);
        }
        catch (Exception e) {
            this.message("-E- failed to add MemoryListener: " + e);
        }
    }

    public void removeMemoryListener(MemoryListener ML) {
        try {
            this._listenerTable.remove(ML);
        }
        catch (Exception e) {
            this.message("-E- failed to remove MemoryListener: " + e);
        }
    }

    protected String getHexString(long value, int n_chars) {
        String raw;
        if (value < 0L) {
            StringBuffer tmp = new StringBuffer();
            int i = 0;
            while (i < n_chars) {
                tmp.append('X');
                ++i;
            }
            raw = tmp.toString();
        } else {
            raw = Long.toHexString(value);
        }
        StringBuffer sb = new StringBuffer();
        int n_zeroes = n_chars - raw.length();
        int i = 0;
        while (i < n_zeroes) {
            sb.append('0');
            ++i;
        }
        sb.append(raw);
        return sb.toString();
    }

    public boolean save(PrintWriter PW) {
        int i = 0;
        while (i < this.data.length) {
            String addrString = this.getHexString(i, 4);
            String valueString = this.getHexString(this.data[i], 2);
            PW.println(addrString + ":" + valueString);
            ++i;
        }
        PW.flush();
        return false;
    }

    public void configure() {
        if (this.MEF == null) {
            this.MEF = new MemoryEditorFrame(this, 32, 8, "Edit " + this.toString());
            this.addMemoryListener(this.MEF);
        }
        this.MEF.pack();
        this.MEF.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.MEF;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null) {
            this.scheduleOutputs(-1);
        }
    }

    public void evaluate(Object arg) {
        Signal signal_nCS;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if ((signal_nCS = this.port_nCS.getSignal()) == null) {
            this.scheduleOutputs(-1);
            return;
        }
        StdLogic1164 value_nCS = (StdLogic1164)signal_nCS.getValue();
        Signal signal_nOE = this.port_nOE.getSignal();
        if (signal_nOE == null) {
            this.scheduleOutputs(-1);
            return;
        }
        StdLogic1164 value_nOE = (StdLogic1164)signal_nOE.getValue();
        if (!value_nCS.is_01()) {
            this.scheduleOutputs(-1);
            return;
        }
        if (!value_nOE.is_01()) {
            this.scheduleOutputs(-1);
            return;
        }
        if (value_nCS.is_1() || value_nOE.is_1()) {
            this.scheduleOutputs(-2);
            return;
        }
        int index = 0;
        int mask = 1;
        int i = 0;
        while (i < this.n_address_ports) {
            Signal signal_A = this.ports[this.index_a0 + i].getSignal();
            if (signal_A != null) {
                StdLogic1164 value_A = (StdLogic1164)signal_A.getValue();
                if (value_A.is_1()) {
                    index += mask;
                } else if (!value_A.is_0()) {
                    this.scheduleOutputs(-1);
                    return;
                }
            } else {
                this.scheduleOutputs(-1);
                return;
            }
            mask += mask;
            ++i;
        }
        this.scheduleOutputs(index);
        if (SimObject.debug) {
            this.message("-I- ROM: address is " + index);
        }
    }

    private void scheduleOutputs(int index) {
        double time = this.simulator.getSimTime();
        if (index == -2) {
            int i = 0;
            while (i < 8) {
                Port port = this.ports[this.index_y0 + i];
                Signal tmp = port.getSignal();
                if (tmp != null) {
                    this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)tmp, time + 3.0E-8, this.output_Z, (Object)port));
                }
                ++i;
            }
            return;
        }
        if (index == -1) {
            int i = 0;
            while (i < 8) {
                Port port = this.ports[this.index_y0 + i];
                Signal tmp = port.getSignal();
                if (tmp != null) {
                    this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)tmp, time + 3.0E-8, this.output_X, (Object)port));
                }
                ++i;
            }
            return;
        }
        long row = this.data[index];
        long mask = 1L;
        this.notifyReadListeners(index, row);
        if (row < 0L) {
            this.scheduleOutputs(-1);
            return;
        }
        int i = 0;
        while (i < 8) {
            Port port = this.ports[this.index_y0 + i];
            Signal tmp = port.getSignal();
            if (tmp != null) {
                StdLogic1164 output = (row & mask) > 0L ? this.output_1 : this.output_0;
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)tmp, time + 3.0E-8, output, (Object)port));
            }
            mask += mask;
            ++i;
        }
    }

    private void notifyReadListeners(int address, long value) {
        if (this._listenerTable != null) {
            if (address < 0) {
                return;
            }
            Enumeration E = this._listenerTable.keys();
            while (E.hasMoreElements()) {
                ((MemoryListener)E.nextElement()).memoryRead(address, value);
            }
        }
    }

    public void dbg(String msg) {
        System.out.println(msg);
    }

    public String toString() {
        return "ROM_1Kx8: " + this.getFullName();
    }

    public int getAddrOffset() {
        return 0;
    }

    public PropertySheet getConfigDialog() {
        return this.propertySheet;
    }
}

