/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtl;

import hades.gui.MemoryEditorFrame;
import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.memory.Memory;
import hades.models.memory.MemoryListener;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.utils.ExceptionTracer;

public class IDT6116
extends SimObject
implements Memory {
    public static final int N_DATA_INPUTS = 8;
    public static final int N_BITS_PER_WORD = 8;
    public static final int TRISTATED = -2;
    public static final int UNDEFINED = -1;
    protected StdLogic1164 output_0;
    protected StdLogic1164 output_1;
    protected StdLogic1164 output_X;
    protected StdLogic1164 output_Z;
    protected PortStdLogic1164 port_nCS;
    protected PortStdLogic1164 port_nOE;
    protected PortStdLogic1164 port_nWE;
    protected int index_A0;
    protected int index_D0;
    protected int N_ADDRESS_INPUTS = this.getNumberOfAddressInputs();
    protected int n_words = 1 << this.N_ADDRESS_INPUTS;
    protected int address;
    protected long[] data;
    protected Hashtable _listenerTable;
    protected double t_access = 3.0E-8;
    protected double t_tristate = 5.0E-9;
    protected double t_undefined = 6.0E-9;
    protected String resourcename = "/hades/models/rtl/empty.rom";
    protected MemoryEditorFrame MEF = null;

    public IDT6116() {
        int n;
        this.ports = new Port[3 + this.N_ADDRESS_INPUTS + 8];
        this.index_A0 = n = 0;
        int i = 0;
        while (i < this.N_ADDRESS_INPUTS) {
            this.ports[n] = new PortStdLogic1164(this, "A" + i, 0, null);
            ++n;
            ++i;
        }
        this.index_D0 = n;
        int i2 = 0;
        while (i2 < 8) {
            this.ports[n] = new PortStdLogic1164(this, "D" + i2, 2, null);
            ++n;
            ++i2;
        }
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.ports[n] = this.port_nCS;
        this.port_nOE = new PortStdLogic1164(this, "nOE", 0, null);
        this.ports[++n] = this.port_nOE;
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.ports[++n] = this.port_nWE;
        ++n;
        this.data = new long[this.n_words];
        this.address = -1;
        this.output_X = Const1164.__X;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
        this.output_Z = Const1164.__Z;
        this.initRAM();
    }

    public int getNumberOfAddressInputs() {
        return 11;
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.getResourcename()};
        return externals;
    }

    public void initRAM() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = -1L;
            ++i;
        }
    }

    public void printSramContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("-I- " + this.toString() + "contents:");
        int i = 0;
        while (i < this.data.length) {
            sb.append("   " + i + " ");
            if (this.data[i] == -1L) {
                sb.append("XXXX");
            } else {
                sb.append("" + Long.toString(this.data[i], 16));
            }
            sb.append("\n");
            ++i;
        }
        this.message(sb.toString());
    }

    public String getResourcename() {
        return this.resourcename;
    }

    public void setResourcename(String s) {
        this.resourcename = s;
        this.initialize("" + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(s));
    }

    public boolean initialize(String s) {
        this.resourcename = "";
        try {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            if (n_tokens == 1) {
                this.versionId = 1001L;
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (n_tokens == 2) {
                this.versionId = Integer.parseInt(st.nextToken());
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                throw new Exception("need 1 or 2 args, but got: " + s);
            }
            this.parseRAM(this.resourcename);
        }
        catch (Exception e) {
            this.message("-E- IDT6116.initialize(): " + e);
            this.message("-E- offending input is '" + s + "'");
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.resourcename));
    }

    public void parseRAM(String resourcename) {
        block3: {
            InputStream is = null;
            BufferedReader br = null;
            try {
                is = DesignManager.getDesignManager().getInputStream(this, resourcename);
                if (is != null) {
                    this.message("-I- " + this.toString() + ": parsing '" + resourcename + "'");
                    br = new BufferedReader(new InputStreamReader(is));
                    this.parse(br);
                    break block3;
                }
                this.message("-W- " + this.toString() + ": initialization file not found: '" + resourcename + "'");
            }
            catch (Exception e) {
                this.message("-E- in IDT6116.parseRAM(): " + e);
                ExceptionTracer.trace(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean parse(BufferedReader br) {
        line = null;
        valueString = null;
        addr = 0;
        row = 0L;
        try {
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                st = new StringTokenizer(line, " \t:");
                addr = Integer.parseInt(st.nextToken(), 16);
                valueString = st.nextToken();
                if (valueString.length() != 2) ** GOTO lbl19
                row = Long.parseLong(valueString, 16);
                this.setDataAt(addr, row);
                continue;
lbl-1000:
                // 1 sources

                {
                    row = Long.parseLong(valueString.substring(0, 2), 16);
                    this.setDataAt(addr, row);
                    ++addr;
                    valueString = valueString.substring(2, valueString.length());
lbl19:
                    // 2 sources

                    ** while (valueString.length() >= 2)
                }
lbl20:
                // 1 sources

            }
        }
        catch (Exception e) {
            this.message("-E- in IDT6116.parseRAM(): " + e);
            this.message("-I- last line was '" + line + "'");
            ExceptionTracer.trace(e);
            return false;
        }
        return true;
    }

    public void setDataAt(int address, long value) {
        if (address < 0 || address > this.data.length - 1) {
            this.message("-E- RAM.setDataAt(): out-of-range address: " + address);
            this.message("-W- address and data ignored!");
            return;
        }
        if (value != -1L) {
            value &= 0xFFL;
        }
        this.data[address] = value;
        if (this.MEF != null && this.MEF.isShowing()) {
            this.MEF.repaint();
        }
    }

    public long getDataAt(int address) {
        return this.data[address];
    }

    public int getAddrOffset() {
        return 0;
    }

    public int getBitsPerWord() {
        return 8;
    }

    public void setBitsPerWord(int n_bits) throws Exception {
        throw new Exception("Cannot change the IDT6116 width!");
    }

    public int getSize() {
        return this.data.length;
    }

    public void setSize(int n_words) throws Exception {
        throw new Exception("Cannot change the IDT6116 size!");
    }

    public boolean resize(int n_words, int n_bits_per_word) throws Exception {
        throw new Exception("Cannot change the IDT6116  size!");
    }

    public boolean canChangeSize() {
        return false;
    }

    public long[] getDataArray() {
        return this.data;
    }

    public void setDataArray(long[] data) {
        this.data = data;
    }

    public boolean merge(BufferedReader reader) {
        return this.parse(reader);
    }

    public void addMemoryListener(MemoryListener ML) {
        try {
            if (this._listenerTable == null) {
                this._listenerTable = new Hashtable();
            }
            this._listenerTable.put(ML, ML);
        }
        catch (Exception e) {
            this.message("-E- failed to add MemoryListener: " + e);
        }
    }

    public void removeMemoryListener(MemoryListener ML) {
        try {
            this._listenerTable.remove(ML);
        }
        catch (Exception e) {
            this.message("-E- failed to remove MemoryListener: " + e);
        }
    }

    protected String getHexString(long value, int n_chars) {
        String raw;
        if (value < 0L) {
            StringBuffer tmp = new StringBuffer();
            int i = 0;
            while (i < n_chars) {
                tmp.append('X');
                ++i;
            }
            raw = tmp.toString();
        } else {
            raw = Long.toHexString(value);
        }
        StringBuffer sb = new StringBuffer();
        int n_zeroes = n_chars - raw.length();
        int i = 0;
        while (i < n_zeroes) {
            sb.append('0');
            ++i;
        }
        sb.append(raw);
        return sb.toString();
    }

    public boolean save(PrintWriter PW) {
        int i = 0;
        while (i < this.data.length) {
            String addrString = this.getHexString(i, 4);
            String valueString = this.getHexString(this.data[i], 2);
            PW.println(addrString + ":" + valueString);
            ++i;
        }
        PW.flush();
        return false;
    }

    public void configure() {
        if (this.MEF == null) {
            this.MEF = new MemoryEditorFrame(this, 32, 8, "Edit " + this.toString());
            this.addMemoryListener(this.MEF);
        }
        this.MEF.pack();
        this.MEF.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.MEF;
    }

    public PropertySheet getConfigDialog() {
        return this.propertySheet;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null) {
            this.scheduleOutputs(-1, this.t_undefined);
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_nOE = this.port_nOE.getValueOrU();
        StdLogic1164 value_nWE = this.port_nWE.getValueOrU();
        if (value_nCS.is_1()) {
            this.scheduleOutputs(-2, this.t_tristate);
        } else if (!value_nCS.is_0()) {
            this.scheduleOutputs(-1, this.t_undefined);
        } else if (value_nWE.is_1()) {
            if (value_nOE.is_0()) {
                this.getAdress();
                this.scheduleOutputs(this.address, this.t_access);
            } else if (value_nOE.is_1()) {
                this.scheduleOutputs(-2, this.t_tristate);
            } else {
                this.scheduleOutputs(-1, this.t_undefined);
            }
        } else if (value_nWE.is_0()) {
            if (value_nOE.is_0()) {
                this.scheduleOutputs(-1, this.t_undefined);
                this.getAdress();
                this.writeRAM();
            } else if (value_nOE.is_1()) {
                this.scheduleOutputs(-2, this.t_tristate);
                this.getAdress();
                this.writeRAM();
            } else {
                this.scheduleOutputs(-1, this.t_undefined);
                this.getAdress();
                this.writeRAM();
            }
        } else {
            this.scheduleOutputs(-1, this.t_undefined);
        }
    }

    protected void getAdress() {
        int index = 0;
        int mask = 1;
        int i = 0;
        while (i < this.N_ADDRESS_INPUTS) {
            Signal signal_A = this.ports[this.index_A0 + i].getSignal();
            if (signal_A != null) {
                StdLogic1164 value_A = (StdLogic1164)signal_A.getValue();
                if (value_A.is_1()) {
                    index += mask;
                } else if (!value_A.is_0()) {
                    index = -1;
                    break;
                }
            } else {
                index = -1;
                break;
            }
            mask += mask;
            ++i;
        }
        this.address = index;
    }

    private void writeRAM() {
        long new_value;
        if (this.address < 0) {
            this.message("-E- invalid RAM address: " + this.address + ", write ignored!");
            return;
        }
        int row = 0;
        int mask = 1;
        int i = 0;
        while (i < 8) {
            Signal signal = this.ports[this.index_D0 + i].getSignal();
            if (signal == null) {
                row = -1;
                break;
            }
            StdLogic1164 value = (StdLogic1164)signal.getValue();
            if (!value.is_0()) {
                if (value.is_1()) {
                    row += mask;
                } else {
                    row = -1;
                    break;
                }
            }
            mask += mask;
            ++i;
        }
        long old_value = this.data[this.address];
        this.data[this.address] = new_value = (long)row;
        this.notifyWriteListeners(this.address, old_value, new_value);
    }

    private void notifyWriteListeners(int address, long old_value, long new_value) {
        if (this._listenerTable != null) {
            Enumeration E = this._listenerTable.keys();
            while (E.hasMoreElements()) {
                ((MemoryListener)E.nextElement()).memoryWrite(address, old_value, new_value);
            }
        }
    }

    private void notifyReadListeners(int address, long value) {
        if (this._listenerTable != null) {
            if (address < 0) {
                return;
            }
            Enumeration E = this._listenerTable.keys();
            while (E.hasMoreElements()) {
                ((MemoryListener)E.nextElement()).memoryRead(address, value);
            }
        }
    }

    private void scheduleOutputs(int index, double t_delay) {
        double time = this.simulator.getSimTime() + t_delay;
        long row = index >= 0 ? this.data[index] : 0L;
        this.notifyReadListeners(index, row);
        long mask = 1L;
        int i = 0;
        while (i < 8) {
            Port port = this.ports[this.index_D0 + i];
            Signal signal = port.getSignal();
            if (signal != null) {
                StdLogic1164 value = index == -1 ? this.output_X : (index == -2 ? this.output_Z : (row == -1L ? this.output_X : ((row & mask) > 0L ? this.output_1 : this.output_0)));
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
            }
            mask += mask;
            ++i;
        }
    }

    public void dbg(String msg) {
        System.out.println(msg);
    }

    public String toString() {
        return "IDT6116: " + this.getFullName();
    }
}

