/*
 * Decompiled with CFR 0.152.
 */
package hades.models.register;

import hades.models.StdLogic1164;
import hades.models.register.Register;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ClassLabel;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;

public class ShiftRegister
extends Register {
    protected Port port_NR;
    protected Port port_SE;
    protected Port port_Sin;
    protected Port port_Sout;

    protected void initPortsAndData() {
        if (this.n_bits < 0 || this.n_bits > 32) {
            this.message("-W- invalid number of bits: " + this.n_bits);
            this.message("-W- using 1 bit instead");
            this.n_bits = 1;
        }
        this.ports = new Port[this.n_bits + this.n_bits + 5];
        int i = 0;
        int j = 0;
        while (j < this.n_bits) {
            this.ports[i++] = new Port(this, "D" + j, 3, null);
            ++j;
        }
        int j2 = 0;
        while (j2 < this.n_bits) {
            this.ports[i++] = new Port(this, "Q" + j2, 1, null);
            ++j2;
        }
        this.ports[i] = new Port(this, "C", 0, null);
        this.port_C = this.ports[i];
        this.ports[++i] = new Port(this, "NR", 0, null);
        this.port_NR = this.ports[i];
        this.ports[++i] = new Port(this, "SE", 0, null);
        this.port_SE = this.ports[i];
        this.ports[++i] = new Port(this, "Sin", 0, null);
        this.port_Sin = this.ports[i];
        this.ports[++i] = new Port(this, "Sout", 1, null);
        this.port_Sout = this.ports[i];
        ++i;
        this.data = new StdLogic1164[this.n_bits];
        int j3 = 0;
        while (j3 < this.n_bits) {
            this.data[j3] = this.value_U;
            ++j3;
        }
    }

    protected void createGlobalPortSymbols() {
        int xmax = (this.n_bits + 1) * 1200;
        ClassLabel cl = new ClassLabel();
        cl.initialize("" + (xmax + 100) + " 450 " + "ShiftReg" + this.n_bits);
        PortSymbol clockSymbol = new PortSymbol();
        clockSymbol.initialize("600 0 C");
        PortSymbol resetSymbol = new PortSymbol();
        resetSymbol.initialize("0 900 NR");
        PortLabel resetLabel = new PortLabel();
        resetLabel.initialize("150 1100 NR");
        PortSymbol shiftEnableSymbol = new PortSymbol();
        shiftEnableSymbol.initialize("0 600 SE");
        PortLabel shiftEnableLabel = new PortLabel();
        shiftEnableLabel.initialize("150 800 SE");
        PortSymbol shiftInSymbol = new PortSymbol();
        shiftInSymbol.initialize("1200 0 Sin");
        this.symbol.fastAddMember(cl);
        this.symbol.fastAddMember(clockSymbol);
        this.symbol.fastAddMember(resetSymbol);
        this.symbol.fastAddMember(resetLabel);
        this.symbol.fastAddMember(shiftEnableSymbol);
        this.symbol.fastAddMember(shiftEnableLabel);
        this.symbol.fastAddMember(shiftInSymbol);
    }

    public void evaluate(Object arg) {
        int i;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate...");
        }
        StdLogic1164 value_NR = null;
        StdLogic1164 value_SE = null;
        StdLogic1164 value_C = null;
        double time = this.simulator.getSimTime() + this.t_pass;
        Signal signal_NR = this.port_NR.getSignal();
        value_NR = signal_NR != null ? (StdLogic1164)signal_NR.getValue() : this.value_U;
        Signal signal_SE = this.port_SE.getSignal();
        value_SE = signal_SE != null ? (StdLogic1164)signal_SE.getValue() : this.value_U;
        Signal signal_C = this.port_C.getSignal();
        value_C = signal_C != null ? (StdLogic1164)signal_C.getValue() : this.value_U;
        if (value_NR.is_0()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_0;
                ++i;
            }
        } else if (!value_NR.is_1()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (!value_SE.is_01()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (signal_C == null) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (signal_C.hasEvent() && value_C.is_1()) {
            Signal signal_tmp;
            if (value_SE.is_1()) {
                i = 0;
                while (i < this.n_bits - 1) {
                    this.data[i] = this.data[i + 1];
                    ++i;
                }
                signal_tmp = this.port_Sin.getSignal();
                this.data[this.n_bits - 1] = signal_tmp == null ? this.value_X : ((StdLogic1164)signal_tmp.getValue()).copy();
            } else {
                i = 0;
                while (i < this.n_bits) {
                    signal_tmp = this.ports[i].getSignal();
                    this.data[i] = signal_tmp == null ? this.value_X : ((StdLogic1164)signal_tmp.getValue()).copy();
                    ++i;
                }
            }
        } else {
            return;
        }
        this.show();
        int i2 = 0;
        while (i2 < this.n_bits) {
            Port port_Q = this.ports[this.n_bits + i2];
            SignalStdLogic1164 signal_Q = (SignalStdLogic1164)port_Q.getSignal();
            if (signal_Q != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.data[i2], (Object)port_Q));
            }
            ++i2;
        }
    }

    public SimObject copy() {
        ShiftRegister tmp = null;
        try {
            tmp = (ShiftRegister)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setBitWidth(this.getBitWidth());
            tmp.setPassTime(this.getPassTime());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in ShiftRegister.copy: " + e);
            return null;
        }
    }

    public String toString() {
        return "ShiftRegister<" + this.n_bits + ">: " + this.getFullName();
    }
}

