/*
 * Decompiled with CFR 0.152.
 */
package hades.models.register;

import hades.models.StdLogic1164;
import hades.models.register.Register;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ClassLabel;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;

public class RegisterRE
extends Register {
    protected Port port_NR;
    protected Port port_EN;

    protected void initPortsAndData() {
        if (this.n_bits < 0 || this.n_bits > 32) {
            this.message("-W- invalid number of bits: " + this.n_bits);
            this.message("-W- using 1 bit instead");
            this.n_bits = 1;
        }
        this.ports = new Port[this.n_bits + this.n_bits + 3];
        int i = 0;
        int j = 0;
        while (j < this.n_bits) {
            this.ports[i++] = new Port(this, "D" + j, 3, null);
            ++j;
        }
        int j2 = 0;
        while (j2 < this.n_bits) {
            this.ports[i++] = new Port(this, "Q" + j2, 1, null);
            ++j2;
        }
        this.ports[i] = new Port(this, "C", 0, null);
        this.port_C = this.ports[i];
        this.ports[++i] = new Port(this, "NR", 0, null);
        this.port_NR = this.ports[i];
        this.ports[++i] = new Port(this, "EN", 0, null);
        this.port_EN = this.ports[i];
        ++i;
        this.data = new StdLogic1164[this.n_bits];
        int j3 = 0;
        while (j3 < this.n_bits) {
            this.data[j3] = this.value_U;
            ++j3;
        }
    }

    protected void createGlobalPortSymbols() {
        int xmax = (this.n_bits + 1) * 1200;
        ClassLabel cl = new ClassLabel();
        cl.initialize("" + (xmax + 100) + " 450 " + "RegRE" + this.n_bits);
        PortSymbol clockSymbol = new PortSymbol();
        clockSymbol.initialize("600 0 C");
        PortSymbol resetSymbol = new PortSymbol();
        resetSymbol.initialize("0 900 NR");
        PortLabel resetLabel = new PortLabel();
        resetLabel.initialize("150 1100 NR");
        PortSymbol enableSymbol = new PortSymbol();
        enableSymbol.initialize("0 300 EN");
        PortLabel enableLabel = new PortLabel();
        enableLabel.initialize("150 500 E");
        this.symbol.fastAddMember(cl);
        this.symbol.fastAddMember(clockSymbol);
        this.symbol.fastAddMember(resetSymbol);
        this.symbol.fastAddMember(resetLabel);
        this.symbol.fastAddMember(enableSymbol);
        this.symbol.fastAddMember(enableLabel);
    }

    public void evaluate(Object arg) {
        int i;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate...");
        }
        StdLogic1164 value_NR = null;
        StdLogic1164 value_EN = null;
        StdLogic1164 value_C = null;
        double time = this.simulator.getSimTime() + this.t_pass;
        Signal signal_NR = this.port_NR.getSignal();
        value_NR = signal_NR != null ? (StdLogic1164)signal_NR.getValue() : this.value_U;
        Signal signal_EN = this.port_EN.getSignal();
        value_EN = signal_EN != null ? (StdLogic1164)signal_EN.getValue() : this.value_U;
        Signal signal_C = this.port_C.getSignal();
        value_C = signal_C != null ? (StdLogic1164)signal_C.getValue() : this.value_U;
        if (value_NR.is_0()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_0;
                ++i;
            }
        } else if (!value_NR.is_1()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (!value_EN.is_01()) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (signal_C == null) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_X;
                ++i;
            }
        } else if (signal_C.hasEvent() && value_C.is_1() && value_EN.is_1()) {
            i = 0;
            while (i < this.n_bits) {
                Signal signal_tmp = this.ports[i].getSignal();
                this.data[i] = signal_tmp == null ? this.value_X : ((StdLogic1164)signal_tmp.getValue()).copy();
                ++i;
            }
        } else {
            return;
        }
        this.show();
        int i2 = 0;
        while (i2 < this.n_bits) {
            Port port_Q = this.ports[this.n_bits + i2];
            SignalStdLogic1164 signal_Q = (SignalStdLogic1164)port_Q.getSignal();
            if (signal_Q != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.data[i2], (Object)port_Q));
            }
            ++i2;
        }
    }

    public SimObject copy() {
        RegisterRE tmp = null;
        try {
            tmp = (RegisterRE)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setBitWidth(this.getBitWidth());
            tmp.setPassTime(this.getPassTime());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in RegisterRE.copy: " + e);
            return null;
        }
    }

    public String toString() {
        return "RegisterRE<" + this.n_bits + ">: " + this.getFullName();
    }
}

