/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.manager.DesignManager;
import hades.models.pic.PicEprom;
import hades.models.pic.PicMemory;
import hades.models.pic.PicReg;
import hades.simulator.SimObject;
import hades.utils.HexFormat;
import hades.utils.IntelHexFile;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class TurboPicCore
extends SimObject {
    double _period = 1.0E-6;
    long _cycle = 0L;
    long n_errors = 0L;
    boolean enableWDT = false;
    boolean enableIRQs = false;
    boolean isResetOrSleep = false;
    boolean enableGUI = false;
    boolean enableDebugSignals = false;
    boolean needCheckIRQs = false;
    int[] register;
    int[] stack;
    int[] eeprom;
    PicInstruction[] program;
    Hashtable labelTable;
    int _PC;
    int _W;
    int _SP;
    int _WDT;
    int _WDT_PRESCALER;
    int _INDF;
    int _TMR0;
    int _PCL;
    int _STATUS;
    int _FSR;
    int _PORTA_LATCH;
    int _PORTB_LATCH;
    int _EEDATA;
    int _EEADR;
    int _PCLATH;
    int _INTCON;
    int _OPTION;
    int _TRISA;
    int _TRISB;
    int _EECON1;
    int _EECON2;
    public static final String[] bank0Names = new String[]{"INDF", "TMR0", "PCL", "STATUS", "FSR", "PORTA", "PORTB", "-NOREG-", "EEDATA", "EEADR", "PCLATH", "INTCON"};
    public static final String[] bank1Names = new String[]{"INDF", "OPTION", "PCL", "STATUS", "FSR", "TRISA", "TRISB", "-NOREG-", "EECON1", "EECON2", "PCLATH", "INTCON"};
    public static final String[][] bank0BitNames = new String[][]{{null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {"C", "DC", "Z", "/PD", "/TO", "RP0", "RP1", "IRP"}, {null, null, null, null, null, null, null, null}, {"RA0", "RA1", "RA2", "RA3", "RA4/T0", null, null, null}, {"RB0", "RB1", "RB2", "RB3", "RB4", "RB5", "RB6", "RB7"}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {"RBIF", "INTF", "T0IF", "RBIE", "INTE", "T0IE", "EEIE", "GIE"}};
    public static final String[][] bank1BitNames = new String[][]{{null, null, null, null, null, null, null, null}, {"RBPU", "INTEDG", "T0CS", "T0SE", "PSA", "PS2", "PS1", "PS0"}, {null, null, null, null, null, null, null, null}, {"C", "DC", "Z", "/PD", "/TO", "RP0", "RP1", "IRP"}, {null, null, null, null, null, null, null, null}, {"RA0", "RA1", "RA2", "RA3", "RA4/T0", null, null, null}, {"RB0", "RB1", "RB2", "RB3", "RB4", "RB5", "RB6", "RB7"}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {"RBIF", "INTF", "T0IF", "RBIE", "INTE", "T0IE", "EEIE", "GIE"}};
    public static final int MAX_RAM = 47;
    public static final int EEPROM_SIZE = 64;
    public static final int EPROM_SIZE = 1024;
    public static final int STACK_DEPTH = 8;
    public static final int _C = 1;
    public static final int _DC = 2;
    public static final int _Z = 4;
    public static final int _nPD = 8;
    public static final int _nTO = 16;
    public static final int _RP0 = 32;
    public static final int _RP1 = 64;
    public static final int _IRP = 128;
    public static final int _RBIF = 1;
    public static final int _INTF = 2;
    public static final int _T0IF = 4;
    public static final int _RBIE = 8;
    public static final int _INTE = 16;
    public static final int _T0IE = 32;
    public static final int _EEIE = 64;
    public static final int _GIE = 128;
    public static final int _RA0 = 1;
    public static final int _RA1 = 2;
    public static final int _RA2 = 4;
    public static final int _RA3 = 8;
    public static final int _RA4 = 16;

    public TurboPicCore() {
        this.createAndInitializeMemoryArrays();
        this.clearLabels();
        this.reset();
    }

    public void createAndInitializeMemoryArrays() {
        this.register = new int[48];
        this.stack = new int[8];
        this.eeprom = new int[64];
        this.program = new PicInstruction[1024];
    }

    public void clearLabels() {
        this.labelTable = new Hashtable();
    }

    public void setEnableWDT(boolean b) {
        this.enableWDT = b;
        this.error("enable WDT not implemented yet!");
    }

    public void setEnableIRQs(boolean b) {
        this.enableIRQs = b;
        this.error("enable IRQs not implemented yet!");
    }

    public boolean isSpecialRegister(int addr) {
        return addr <= 11 || addr > 47;
    }

    public boolean isNormalRegister(int addr) {
        return addr >= 12 && addr <= 47;
    }

    public void setCodeBreakPoint(int addr) {
        if (addr < 0 || addr > 1024) {
            return;
        }
        PicInstruction target = this.program[addr];
        if (target == null) {
            this.program[addr] = new BreakPoint(null);
        } else {
            if (target instanceof BreakPoint) {
                return;
            }
            this.program[addr] = new BreakPoint(target);
        }
    }

    public boolean isCodeBreakPoint(int addr) {
        return this.program[addr] != null && this.program[addr] instanceof BreakPoint;
    }

    public int readReg(int _addr7) {
        int _rp_mask = (this._STATUS & 0x60) << 2;
        int addr = _addr7 | _rp_mask;
        if (addr >= 12 && addr <= 47) {
            return this.register[addr];
        }
        if (addr >= 140 && addr <= 175) {
            return this.register[addr & 0x7F];
        }
        switch (addr) {
            case 0: {
                if (this._FSR == 0) {
                    return 0;
                }
                return this.readReg(this._FSR);
            }
            case 1: {
                return this._TMR0;
            }
            case 2: {
                return this._PC & 0xFF;
            }
            case 3: {
                return this._STATUS;
            }
            case 4: {
                return this._FSR;
            }
            case 5: {
                return this.readPortA();
            }
            case 6: {
                return this.readPortB();
            }
            case 7: {
                return 0;
            }
            case 8: {
                return this._EEDATA;
            }
            case 9: {
                return this._EEADR;
            }
            case 10: {
                return this._PCLATH;
            }
            case 11: {
                return this._INTCON;
            }
            case 128: {
                if (this._FSR == 0) {
                    return 0;
                }
                return this.readReg(this._FSR);
            }
            case 129: {
                return this._OPTION;
            }
            case 130: {
                return this._PC & 0xFF;
            }
            case 131: {
                return this._STATUS;
            }
            case 132: {
                return this._FSR;
            }
            case 133: {
                return this._TRISA;
            }
            case 134: {
                return this._TRISB;
            }
        }
        return -1;
    }

    public int readRegRaw(int _addr9) {
        int addr = _addr9;
        if (addr >= 12 && addr <= 47) {
            return this.register[addr];
        }
        if (addr >= 140 && addr <= 175) {
            return this.register[addr & 0x7F];
        }
        switch (addr) {
            case 0: {
                if (this._FSR == 0) {
                    return 0;
                }
                return this.readReg(this._FSR);
            }
            case 1: {
                return this._TMR0;
            }
            case 2: {
                return this._PC & 0xFF;
            }
            case 3: {
                return this._STATUS;
            }
            case 4: {
                return this._FSR;
            }
            case 5: {
                return this.readPortA();
            }
            case 6: {
                return this.readPortB();
            }
            case 7: {
                return -1;
            }
            case 8: {
                return this._EEDATA;
            }
            case 9: {
                return this._EEADR;
            }
            case 10: {
                return this._PCLATH;
            }
            case 11: {
                return this._INTCON;
            }
            case 128: {
                if (this._FSR == 0) {
                    return 0;
                }
                return this.readReg(this._FSR);
            }
            case 129: {
                return this._OPTION;
            }
            case 130: {
                return this._PC & 0xFF;
            }
            case 131: {
                return this._STATUS;
            }
            case 132: {
                return this._FSR;
            }
            case 133: {
                return this._TRISA;
            }
            case 134: {
                return this._TRISB;
            }
        }
        return -1;
    }

    public int readPortA() {
        return this._PORTA_LATCH;
    }

    public int readPortB() {
        return this._PORTB_LATCH;
    }

    public void writePortA(int value) {
        this._PORTA_LATCH = value;
    }

    public void writePortB(int value) {
        this._PORTB_LATCH = value;
    }

    public void writeTrisA(int value) {
        this._TRISA = value;
    }

    public void writeTrisB(int value) {
        this._TRISB = value;
    }

    public void writePCL(int value) {
        this._PC = (this._PCLATH << 8) + (value & 0xFF);
    }

    public void writeReg(int _addr7, int value) {
        int _rp_mask = (this._STATUS & 0x60) << 2;
        int addr = _addr7 | _rp_mask;
        if (addr >= 12 && addr <= 47) {
            this.register[addr] = value;
        } else if (addr >= 140 && addr <= 175) {
            this.register[addr & 0x7F] = value;
        } else {
            switch (addr) {
                case 0: {
                    if (this._FSR == 0) break;
                    this.writeReg(this._FSR, value);
                    break;
                }
                case 1: {
                    this._TMR0 = value;
                    break;
                }
                case 2: {
                    this.writePCL(value);
                    break;
                }
                case 3: {
                    this._STATUS = value;
                    break;
                }
                case 4: {
                    this._FSR = value;
                    break;
                }
                case 5: {
                    this.writePortA(value);
                    break;
                }
                case 6: {
                    this.writePortB(value);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    this._EEDATA = value;
                    break;
                }
                case 9: {
                    this._EEADR = value;
                    break;
                }
                case 10: {
                    this._PCLATH = value;
                    break;
                }
                case 11: {
                    this._INTCON = value;
                    break;
                }
                case 128: {
                    if (this._FSR == 0) break;
                    this.writeReg(this._FSR, value);
                    break;
                }
                case 129: {
                    this._OPTION = value;
                    break;
                }
                case 130: {
                    this.writePCL(value);
                    break;
                }
                case 131: {
                    this._STATUS = value;
                    break;
                }
                case 132: {
                    this._FSR = value;
                    break;
                }
                case 133: {
                    this.writeTrisA(value);
                    break;
                }
                case 134: {
                    this.writeTrisB(value);
                    break;
                }
                case 135: {
                    this.error("writeReg 0x87");
                    break;
                }
                case 136: {
                    this.error("writeReg 0x88");
                    break;
                }
                case 137: {
                    this.error("writeReg 0x89");
                    break;
                }
                case 138: {
                    this.error("writeReg 0x8A");
                    break;
                }
                case 139: {
                    this.error("writeReg 0x8B");
                    break;
                }
            }
        }
    }

    public void checkIRQs() {
        System.err.println("-F- checkIRQs not implemented yet!");
    }

    public void error(String s) {
        System.err.println("-E- TurboPicCore error: " + s);
    }

    public PicInstruction createDECFSZ(int _f, int _d) {
        boolean storeIntoF;
        boolean normal = this.isNormalRegister(_f);
        boolean bl = storeIntoF = _d == 1;
        if (normal & storeIntoF) {
            return new DECFSZ_NF(_f, _d);
        }
        return new DECFSZ(_f, _d);
    }

    public void loadProgramFormatROM(InputStream IS) {
        String line = null;
        try {
            int addr;
            StringTokenizer ST = null;
            BufferedReader BR = new BufferedReader(new InputStreamReader(IS));
            int[] opcodes = new int[1024];
            int i = 0;
            while (i < opcodes.length) {
                opcodes[i] = -1;
                ++i;
            }
            while ((line = BR.readLine()) != null) {
                int opcode;
                if (line.startsWith("#label")) {
                    ST = new StringTokenizer(line, " \t");
                    ST.nextToken();
                    addr = Integer.parseInt(ST.nextToken(), 16);
                    String label = ST.nextToken();
                    this.labelTable.put(new Integer(addr), label);
                    continue;
                }
                if (line.startsWith("#")) continue;
                ST = new StringTokenizer(line, " \t:,");
                addr = Integer.parseInt(ST.nextToken(), 16);
                opcodes[addr] = opcode = Integer.parseInt(ST.nextToken(), 16);
            }
            addr = 0;
            while (addr < opcodes.length) {
                if (opcodes[addr] != -1) {
                    this.program[addr] = this.decode(opcodes[addr]);
                    this.program[addr].setOpcode(opcodes[addr]);
                }
                ++addr;
            }
        }
        catch (Exception e) {
            System.err.println(e + " last line read: " + line);
            e.printStackTrace();
        }
    }

    public void loadProgramFormatHEX(InputStream IS) {
        long[] opcodes = new long[1024];
        try {
            this.clearLabels();
            new IntelHexFile().parsePic16Bit(IS, opcodes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int addr = 0;
        while (addr < opcodes.length) {
            if (opcodes[addr] != -1L) {
                this.program[addr] = this.decode((int)opcodes[addr]);
                this.program[addr].setOpcode((int)opcodes[addr]);
            }
            ++addr;
        }
    }

    public void loadProgram(String resourcename) {
        InputStream is = DesignManager.getDesignManager().getInputStream(this, resourcename);
        String lower = resourcename.toLowerCase();
        if (lower.endsWith(".hex")) {
            this.loadProgramFormatHEX(is);
        } else if (lower.endsWith(".rom")) {
            this.loadProgramFormatROM(is);
        } else {
            this.error("-F- loadProgram: expected .hex or .rom extension, got\n: " + resourcename);
        }
    }

    public void dumpProgram(OutputStream OS) {
        try {
            PrintStream ps = new PrintStream(OS);
            int addr = 0;
            while (addr < this.program.length) {
                if (this.program[addr] != null) {
                    ps.print(this.isCodeBreakPoint(addr) ? "* " : "  ");
                    ps.print(this.__hex(addr, 4));
                    ps.print(" ");
                    ps.print(this.__hex(this.program[addr].getOpcode(), 4));
                    ps.print(" ");
                    String label = (String)this.labelTable.get(new Integer(addr));
                    if (label != null) {
                        ps.print(this.__fill(label, 24));
                    } else {
                        ps.print(this.__fill("", 24));
                    }
                    ps.print(" ");
                    ps.print(this.program[addr]);
                    ps.println();
                }
                ++addr;
            }
            ps.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PicInstruction decode(int opcode) {
        int group = opcode & 0x3000;
        switch (group) {
            case 0: {
                int aluop = opcode & 0xF00;
                int d = (opcode & 0x80) >> 7;
                int f = opcode & 0x7F;
                switch (aluop) {
                    case 0: {
                        if (d == 1) {
                            return new MOVWF(f);
                        }
                        if (f == 8) {
                            return new RETURN();
                        }
                        if (f == 9) {
                            return new RETFIE();
                        }
                        if (f == 99) {
                            return new SLEEP();
                        }
                        if (f == 100) {
                            return new CLRWDT();
                        }
                        return new NOP();
                    }
                    case 256: {
                        if (d == 1) {
                            return new CLRF(f);
                        }
                        return new CLRW();
                    }
                    case 512: {
                        return new SUBWF(f, d);
                    }
                    case 768: {
                        return new DECF(f, d);
                    }
                    case 1024: {
                        return new IORWF(f, d);
                    }
                    case 1280: {
                        return new ANDWF(f, d);
                    }
                    case 1536: {
                        return new XORWF(f, d);
                    }
                    case 1792: {
                        return new ADDWF(f, d);
                    }
                    case 2048: {
                        return new MOVF(f, d);
                    }
                    case 2304: {
                        return new COMF(f, d);
                    }
                    case 2560: {
                        return new INCF(f, d);
                    }
                    case 2816: {
                        return this.createDECFSZ(f, d);
                    }
                    case 3072: {
                        return new RRF(f, d);
                    }
                    case 3328: {
                        return new RLF(f, d);
                    }
                    case 3584: {
                        return new SWAPF(f, d);
                    }
                    case 3840: {
                        return new INCFSZ(f, d);
                    }
                }
                break;
            }
            case 4096: {
                int bitop = opcode & 0xC00;
                int ff = opcode & 0x7F;
                int b = (opcode & 0x380) >> 7;
                switch (bitop) {
                    case 0: {
                        return new BCF(ff, b);
                    }
                    case 1024: {
                        return new BSF(ff, b);
                    }
                    case 2048: {
                        return new BTFSC(ff, b);
                    }
                    case 3072: {
                        return new BTFSS(ff, b);
                    }
                }
                System.err.println("Illegal bit opcode: " + bitop);
                return null;
            }
            case 8192: {
                int jmpop = opcode & 0x800;
                int addr = opcode & 0x7FF;
                switch (jmpop) {
                    case 0: {
                        return new CALL(addr);
                    }
                    case 2048: {
                        return new GOTO(addr);
                    }
                }
                break;
            }
            case 12288: {
                int litop = opcode & 0xF00;
                int l = opcode & 0xFF;
                switch (litop) {
                    case 0: 
                    case 256: 
                    case 512: 
                    case 768: {
                        return new MOVLW(l);
                    }
                    case 1024: 
                    case 1280: 
                    case 1536: 
                    case 1792: {
                        return new RETLW(l);
                    }
                    case 2048: {
                        return new IORLW(l);
                    }
                    case 2304: {
                        return new ANDLW(l);
                    }
                    case 2560: {
                        return new XORLW(l);
                    }
                    case 2816: {
                        System.err.println("Illegal literal opcode: " + litop);
                        return null;
                    }
                    case 3072: 
                    case 3328: {
                        return new SUBLW(l);
                    }
                    case 3584: 
                    case 3840: {
                        return new ADDLW(l);
                    }
                }
                System.err.println("Illegal literal opcode: " + litop);
                return null;
            }
            default: {
                System.err.println("Illegal Opcode: " + opcode);
                return null;
            }
        }
        return null;
    }

    public String _d(int i) {
        return "" + i;
    }

    public String _h(int i) {
        return Integer.toHexString(i);
    }

    public String __formatReg(int register) {
        if (register <= 11) {
            return bank0Names[register];
        }
        if (register <= 47) {
            return "reg_" + HexFormat.getHexString(register, 2);
        }
        if (register <= 127) {
            return "-noreg-";
        }
        if (register <= 139) {
            return bank1Names[register - 128];
        }
        if (register <= 175) {
            return "reg_" + HexFormat.getHexString(register, 2);
        }
        return "-noreg-";
    }

    public String __formatFD(int f, int d) {
        return this.__formatReg(f) + ", " + (d == 1 ? "F" : "W");
    }

    public String __hex(int value, int n_chars) {
        return HexFormat.getHexString(value, n_chars);
    }

    public String __xhex(int value, int n_chars) {
        return "0x" + HexFormat.getHexString(value, n_chars);
    }

    public String __formatBit(int register, int bit) {
        if (this.isSpecialRegister(register)) {
            String bitname = null;
            bitname = register > 128 ? bank1BitNames[register][bit] : bank0BitNames[register][bit];
            return this.__formatReg(register) + ", " + bitname;
        }
        return this.__formatReg(register) + ", " + bit;
    }

    public String __formatLabel(int address, int n_chars) {
        if (this.labelTable != null) {
            String s = (String)this.labelTable.get(new Integer(address));
            if (s == null) {
                return this.__fill(this.__hex(address, 3), n_chars);
            }
            return this.__fill(s, n_chars);
        }
        return this.__fill(this.__hex(address, 3), n_chars);
    }

    public String __fill(String s, int n_chars) {
        if (s == null) {
            s = "";
        }
        if (s.length() > n_chars) {
            return s.substring(0, n_chars);
        }
        StringBuffer tmp = new StringBuffer();
        tmp.append(s);
        int i = 0;
        while (i < n_chars - s.length()) {
            tmp.append(" ");
            ++i;
        }
        return tmp.toString();
    }

    public String __formatLiteral(int literal) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.__xhex(literal, 2));
        sb.append(" (");
        sb.append(literal);
        sb.append("d)");
        return sb.toString();
    }

    public void dump() {
        System.out.println("TurboPicCore dump after " + this._cycle + " instructions \n" + "PC = " + this._h(this._PC) + "STATUS = " + this._h(this._STATUS));
    }

    public void reset() {
        this._SP = 0;
        this._PC = 0;
    }

    public void singleStep() {
        try {
            if (this.isResetOrSleep) {
                return;
            }
            if (this.needCheckIRQs) {
                this.checkIRQs();
            }
            this.program[this._PC].execute();
            if (this.enableDebugSignals) {
                System.out.println("-debug- scheduling here");
            }
        }
        catch (Exception e) {
            ++this.n_errors;
            if (this.n_errors > 20L) {
                throw new RuntimeException("TurboPicCore: too many errors.");
            }
            e.printStackTrace();
            System.out.println("PC= " + this.__hex(this._PC, 4) + " W= " + this.__hex(this._W, 2) + " STATUS= " + this.__hex(this._STATUS, 2) + " INTCON= " + this.__hex(this._INTCON, 2) + " " + this.program[this._PC]);
        }
    }

    public void steps(int N) {
        try {
            int i = 0;
            while (i < N) {
                if (this.needCheckIRQs) {
                    this.checkIRQs();
                }
                this.program[this._PC].execute();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("PC= " + this.__hex(this._PC, 4) + " W= " + this.__hex(this._W, 2) + " STATUS= " + this.__hex(this._STATUS, 2) + " INTCON= " + this.__hex(this._INTCON, 2) + " " + this.program[this._PC]);
        }
    }

    public static void main(String[] argv) throws Exception {
        TurboPicCore TP = new TurboPicCore();
        TP.tinySelftest();
        if (argv.length < 1) {
            System.out.println("-W- No .hex program file specified, exiting now.");
            System.exit(0);
        }
        TP.loadProgram(argv[0]);
        TP.dumpProgram(System.out);
        System.out.println("loading OK.");
        TP.reset();
        long t1 = System.currentTimeMillis();
        int N = 100000000;
        TP.steps(N);
        long t2 = System.currentTimeMillis();
        System.out.println("time " + (t2 - t1) + " msecs, " + (long)(1000.0 * (double)N / (double)(t2 - t1)) + " instructions/sec." + " cycles= " + TP._cycle);
        TP.dump();
        System.exit(0);
    }

    void tinySelftest() {
        this.program[0] = new NOP();
        this.program[1] = new CLRW();
        this.program[2] = new CLRF(32);
        this.program[3] = new BSF(33, 5);
        this.program[4] = new BCF(34, 7);
        this.program[5] = new CLRF(35);
        this.program[6] = new ANDWF(36, 0);
        this.program[7] = new CLRF(37);
        this.program[8] = new ADDLW(1);
        this.program[9] = new ADDLW(3);
        this.program[10] = new GOTO(0);
        int i = 0;
        while (i < 20) {
            long t1 = System.currentTimeMillis();
            int N = 1000000;
            this.steps(N);
            long t2 = System.currentTimeMillis();
            System.out.println("time " + (t2 - t1) + " msecs, " + (long)(1000.0 * (double)N / (double)(t2 - t1)) + " instructions/sec." + " cycles= " + this._cycle);
            ++i;
        }
    }

    class XORWF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        XORWF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("xorwf  " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = TurboPicCore.this._W ^ operand;
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class XORLW
    extends PicInstruction {
        int literal;

        XORLW(int l) {
            this.literal = l & 0xFF;
            this.setMnemonic("xorlw  " + TurboPicCore.this.__formatLiteral(this.literal));
        }

        final void execute() {
            TurboPicCore.this._W ^= this.literal;
            TurboPicCore.this._STATUS = TurboPicCore.this._W == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class TRIS
    extends PicInstruction {
        int addr;

        TRIS() {
            this.setMnemonic("tris  " + TurboPicCore.this.__formatReg(this.addr));
        }

        final void execute() {
            TurboPicCore.this.error("TRIS instruction not implemented");
            ++TurboPicCore.this._cycle;
        }
    }

    class SWAPF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        SWAPF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("swapf  " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = (operand & 0xF) << 4 | operand >> 4;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp & 0xFF;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp & 0xFF);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class SUBWF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        SUBWF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("subwf  " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = operand - TurboPicCore.this._W;
            int tmp4 = (operand & 0xF) - (TurboPicCore.this._W & 0xF);
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            TurboPicCore.this._STATUS = tmp >= 0 ? (TurboPicCore.this._STATUS |= 1) : (TurboPicCore.this._STATUS &= 0xFFFFFFFE);
            if (tmp4 >= 0) {
                TurboPicCore.this._STATUS |= 2;
            }
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp & 0xFF;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp & 0xFF);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class SUBLW
    extends PicInstruction {
        int literal;

        SUBLW(int l) {
            this.literal = l & 0xFF;
            this.setMnemonic("sublw  " + TurboPicCore.this.__formatLiteral(this.literal));
        }

        final void execute() {
            int tmp = this.literal - TurboPicCore.this._W;
            int tmp4 = (this.literal & 0xF) - (TurboPicCore.this._W & 0xF);
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            TurboPicCore.this._STATUS = tmp >= 0 ? (TurboPicCore.this._STATUS |= 1) : (TurboPicCore.this._STATUS &= 0xFFFFFFFE);
            TurboPicCore.this._STATUS = tmp4 >= 0 ? (TurboPicCore.this._STATUS |= 2) : (TurboPicCore.this._STATUS &= 0xFFFFFFFD);
            TurboPicCore.this._W = tmp & 0xFF;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class SLEEP
    extends PicInstruction {
        SLEEP() {
            this.setMnemonic("sleep  ");
        }

        final void execute() {
            TurboPicCore.this._WDT = 0;
            TurboPicCore.this._WDT_PRESCALER = 0;
            TurboPicCore.this._STATUS = TurboPicCore.this._STATUS |= 0x10;
            TurboPicCore.this._STATUS = TurboPicCore.this._STATUS &= 0xFFFFFFF7;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
            TurboPicCore.this.error("Sleep mode not implemented");
        }
    }

    class RRF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        RRF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("rrf    " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = (TurboPicCore.this._STATUS & 1) << 8 | operand;
            tmp = operand >> 1;
            TurboPicCore.this._STATUS &= 0xFE;
            TurboPicCore.this._STATUS |= operand & 1;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp & 0xFF;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp & 0xFF);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class RLF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        RLF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("rlf    " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = operand << 1;
            TurboPicCore.this._STATUS &= 0xFE;
            TurboPicCore.this._STATUS |= ((tmp += TurboPicCore.this._STATUS & 1) & 0x100) >> 8;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp & 0xFF;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp & 0xFF);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class RETURN
    extends PicInstruction {
        int literal;

        RETURN() {
            this.setMnemonic("return ");
        }

        final void execute() {
            TurboPicCore.this._SP = TurboPicCore.this._SP - 1 & 7;
            TurboPicCore.this._PC = TurboPicCore.this.stack[TurboPicCore.this._SP];
            TurboPicCore.this._cycle += 2L;
        }
    }

    class RETLW
    extends PicInstruction {
        int literal;

        RETLW(int l) {
            this.literal = l & 0xFF;
            this.setMnemonic("retlw  " + TurboPicCore.this.__formatLiteral(this.literal));
        }

        final void execute() {
            TurboPicCore.this._SP = TurboPicCore.this._SP - 1 & 7;
            TurboPicCore.this._PC = TurboPicCore.this.stack[TurboPicCore.this._SP];
            TurboPicCore.this._W = this.literal;
            TurboPicCore.this._cycle += 2L;
        }
    }

    class RETFIE
    extends PicInstruction {
        RETFIE() {
            this.setMnemonic("retfie ");
        }

        final void execute() {
            TurboPicCore.this._SP = TurboPicCore.this._SP - 1 & 7;
            TurboPicCore.this._PC = TurboPicCore.this.stack[TurboPicCore.this._SP];
            TurboPicCore.this._INTCON |= 0x80;
            TurboPicCore.this._cycle += 2L;
        }
    }

    class OPTION
    extends PicInstruction {
        OPTION() {
            this.setMnemonic("option ");
        }

        final void execute() {
            TurboPicCore.this._OPTION = TurboPicCore.this._W;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class NOP
    extends PicInstruction {
        NOP() {
            this.setMnemonic("nop    ");
        }

        final void execute() {
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class MOVWF
    extends PicInstruction {
        int addr;
        boolean normal;

        MOVWF(int _f) {
            this.addr = _f;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.setMnemonic("movwf  " + TurboPicCore.this.__formatReg(this.addr));
        }

        final void execute() {
            if (this.normal) {
                TurboPicCore.this.register[this.addr] = TurboPicCore.this._W;
            } else {
                TurboPicCore.this.writeReg(this.addr, TurboPicCore.this._W);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class MOVF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        MOVF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("movf   " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = operand;
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class MOVLW
    extends PicInstruction {
        int literal;

        MOVLW(int l) {
            this.literal = l & 0xFF;
            this.setMnemonic("movlw  " + TurboPicCore.this.__formatLiteral(this.literal));
        }

        final void execute() {
            TurboPicCore.this._W = this.literal;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class IORWF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        IORWF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("iorwf   " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = TurboPicCore.this._W | operand;
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class IORLW
    extends PicInstruction {
        int literal;

        IORLW(int l) {
            this.literal = l & 0xFF;
            this.setMnemonic("iorlw  " + TurboPicCore.this.__formatLiteral(this.literal));
        }

        final void execute() {
            TurboPicCore.this._W |= this.literal;
            TurboPicCore.this._STATUS = TurboPicCore.this._W == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class INCFSZ
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        INCFSZ(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("incfsz " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int tmp = this.normal ? TurboPicCore.this.register[this.addr] + 1 & 0xFF : TurboPicCore.this.readReg(this.addr) + 1 & 0xFF;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else if (this.normal) {
                TurboPicCore.this.register[this.addr] = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            if (tmp == 0) {
                TurboPicCore.this._PC += 2;
                TurboPicCore.this._cycle += 2L;
            } else {
                ++TurboPicCore.this._PC;
                ++TurboPicCore.this._cycle;
            }
        }
    }

    class INCF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        INCF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("incf   " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int tmp = this.normal ? TurboPicCore.this.register[this.addr] + 1 & 0xFF : TurboPicCore.this.readReg(this.addr) + 1 & 0xFF;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else if (this.normal) {
                TurboPicCore.this.register[this.addr] = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class GOTO
    extends PicInstruction {
        int addr11;

        GOTO(int _addr) {
            this.addr11 = _addr & 0x7FF;
            this.setMnemonic("goto   " + TurboPicCore.this.__formatLabel(this.addr11, 20));
        }

        final void execute() {
            TurboPicCore.this._PC = (TurboPicCore.this._PCLATH & 0x18) << 8 | this.addr11;
            TurboPicCore.this._cycle += 2L;
        }
    }

    class DECFSZ_NF
    extends PicInstruction {
        int addr;
        int d;

        DECFSZ_NF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.setMnemonic("decfsz " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int tmp;
            TurboPicCore.this.register[this.addr] = tmp = TurboPicCore.this.register[this.addr] - 1 & 0xFF;
            if (tmp == 0) {
                TurboPicCore.this._PC += 2;
                TurboPicCore.this._cycle += 2L;
            } else {
                ++TurboPicCore.this._PC;
                ++TurboPicCore.this._cycle;
            }
        }
    }

    class DECFSZ
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        DECFSZ(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("decfsz " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int tmp = this.normal ? TurboPicCore.this.register[this.addr] - 1 & 0xFF : TurboPicCore.this.readReg(this.addr) - 1 & 0xFF;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else if (this.normal) {
                TurboPicCore.this.register[this.addr] = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            if (tmp == 0) {
                TurboPicCore.this._PC += 2;
                TurboPicCore.this._cycle += 2L;
            } else {
                ++TurboPicCore.this._PC;
                ++TurboPicCore.this._cycle;
            }
        }
    }

    class DECF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        DECF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("decf   " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int tmp = this.normal ? TurboPicCore.this.register[this.addr] - 1 & 0xFF : TurboPicCore.this.readReg(this.addr) - 1 & 0xFF;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else if (this.normal) {
                TurboPicCore.this.register[this.addr] = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class COMF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        COMF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("comf   " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int tmp = this.normal ? ~TurboPicCore.this.register[this.addr] & 0xFF : ~TurboPicCore.this.readReg(this.addr) & 0xFF;
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else if (this.normal) {
                TurboPicCore.this.register[this.addr] = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class CLRWDT
    extends PicInstruction {
        public static final int mask = 24;

        CLRWDT() {
            this.setMnemonic("clrw    ");
        }

        final void execute() {
            TurboPicCore.this._WDT = 0;
            TurboPicCore.this._WDT_PRESCALER = 0;
            TurboPicCore.this._STATUS |= 0x18;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class CLRW
    extends PicInstruction {
        CLRW() {
            this.setMnemonic("clrw    ");
        }

        final void execute() {
            TurboPicCore.this._STATUS |= 4;
            TurboPicCore.this._W = 0;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class CLRF
    extends PicInstruction {
        boolean normal;
        boolean special;
        int addr;

        CLRF(int _f) {
            this.addr = _f & 0x7F;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.special = this.addr <= 11;
            this.setMnemonic("clrf    " + TurboPicCore.this.__formatReg(this.addr));
        }

        final void execute() {
            if (this.normal) {
                TurboPicCore.this.register[this.addr] = 0;
            } else if (this.special) {
                TurboPicCore.this.writeReg(this.addr, 0);
            }
            TurboPicCore.this._STATUS |= 4;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class CALL
    extends PicInstruction {
        int addr11;

        CALL(int addr) {
            this.addr11 = addr & 0x7FF;
            this.setMnemonic("call   " + TurboPicCore.this.__formatLabel(this.addr11, 20));
        }

        final void execute() {
            TurboPicCore.this.stack[TurboPicCore.this._SP] = TurboPicCore.this._PC + 1 & 0x1FFF;
            TurboPicCore.this._SP = TurboPicCore.this._SP + 1 & 7;
            TurboPicCore.this._PC = (TurboPicCore.this._PCLATH & 0x18) << 8 | this.addr11;
            TurboPicCore.this._cycle += 2L;
        }
    }

    class BTFSS
    extends PicInstruction {
        int addr;
        int bit;
        int mask;
        boolean normal;

        BTFSS(int _f, int _b) {
            this.addr = _f;
            this.bit = _b;
            this.mask = 1 << this.bit;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.setMnemonic("btfss  " + TurboPicCore.this.__formatBit(this.addr, this.bit));
        }

        final void execute() {
            int tmp = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            if ((tmp & this.mask) != 0) {
                TurboPicCore.this._PC += 2;
                TurboPicCore.this._cycle += 2L;
            } else {
                ++TurboPicCore.this._PC;
                ++TurboPicCore.this._cycle;
            }
        }
    }

    class BTFSC
    extends PicInstruction {
        int addr;
        int bit;
        int mask;
        boolean normal;

        BTFSC(int _f, int _b) {
            this.addr = _f;
            this.bit = _b;
            this.mask = 1 << this.bit;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.setMnemonic("btfsc  " + TurboPicCore.this.__formatBit(this.addr, this.bit));
        }

        final void execute() {
            int tmp = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            if ((tmp & this.mask) == 0) {
                TurboPicCore.this._PC += 2;
                TurboPicCore.this._cycle += 2L;
            } else {
                ++TurboPicCore.this._PC;
                ++TurboPicCore.this._cycle;
            }
        }
    }

    class BSF
    extends PicInstruction {
        int addr;
        int bit;
        int mask;
        boolean normal;

        BSF(int _f, int _b) {
            this.addr = _f;
            this.bit = _b;
            this.mask = 1 << this.bit;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.setMnemonic("bsf    " + TurboPicCore.this.__formatBit(this.addr, this.bit));
        }

        final void execute() {
            if (this.normal) {
                int n = this.addr;
                TurboPicCore.this.register[n] = TurboPicCore.this.register[n] | this.mask;
            } else {
                int tmp = TurboPicCore.this.readReg(this.addr);
                TurboPicCore.this.writeReg(this.addr, tmp | this.mask);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class BCF
    extends PicInstruction {
        int addr;
        int bit;
        int mask;
        boolean normal;

        BCF(int _f, int _b) {
            this.addr = _f;
            this.bit = _b;
            this.mask = 1 << this.bit ^ 0xFF;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.setMnemonic("bcf    " + TurboPicCore.this.__formatBit(this.addr, this.bit));
        }

        final void execute() {
            if (this.normal) {
                int n = this.addr;
                TurboPicCore.this.register[n] = TurboPicCore.this.register[n] & this.mask;
            } else {
                int tmp = TurboPicCore.this.readReg(this.addr);
                TurboPicCore.this.writeReg(this.addr, tmp & this.mask);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class ANDWF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        ANDWF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("andwf  " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = TurboPicCore.this._W & operand;
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class ANDLW
    extends PicInstruction {
        int literal;

        ANDLW(int l) {
            this.literal = l & 0xFF;
            this.setMnemonic("andlw  " + TurboPicCore.this.__formatLiteral(this.literal));
        }

        final void execute() {
            TurboPicCore.this._W &= this.literal;
            TurboPicCore.this._STATUS = TurboPicCore.this._W == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class ADDWF
    extends PicInstruction {
        int addr;
        int d;
        boolean normal;
        boolean storeIntoW;

        ADDWF(int _f, int _d) {
            this.addr = _f;
            this.d = _d;
            this.normal = TurboPicCore.this.isNormalRegister(_f);
            this.storeIntoW = this.d == 0;
            this.setMnemonic("addwf  " + TurboPicCore.this.__formatFD(this.addr, this.d));
        }

        final void execute() {
            int operand = this.normal ? TurboPicCore.this.register[this.addr] : TurboPicCore.this.readReg(this.addr);
            int tmp = TurboPicCore.this._W + operand;
            int tmp4 = (TurboPicCore.this._W & 0xF) + (operand & 0xF);
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            TurboPicCore.this._STATUS = tmp > 255 ? (TurboPicCore.this._STATUS |= 1) : (TurboPicCore.this._STATUS &= 0xFFFFFFFE);
            TurboPicCore.this._STATUS = tmp4 > 15 ? (TurboPicCore.this._STATUS |= 2) : (TurboPicCore.this._STATUS &= 0xFFFFFFFD);
            if (this.storeIntoW) {
                TurboPicCore.this._W = tmp & 0xFF;
            } else {
                TurboPicCore.this.writeReg(this.addr, tmp & 0xFF);
            }
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class ADDLW
    extends PicInstruction {
        int literal;

        ADDLW(int l) {
            this.literal = l & 0xFF;
            this.setMnemonic("addlw  " + TurboPicCore.this.__formatLiteral(this.literal));
        }

        final void execute() {
            int tmp = TurboPicCore.this._W + this.literal;
            int tmp4 = (TurboPicCore.this._W & 0xF) + (this.literal & 0xF);
            TurboPicCore.this._STATUS = tmp == 0 ? (TurboPicCore.this._STATUS |= 4) : (TurboPicCore.this._STATUS &= 0xFFFFFFFB);
            TurboPicCore.this._STATUS = tmp > 255 ? (TurboPicCore.this._STATUS |= 1) : (TurboPicCore.this._STATUS &= 0xFFFFFFFE);
            TurboPicCore.this._STATUS = tmp4 > 15 ? (TurboPicCore.this._STATUS |= 2) : (TurboPicCore.this._STATUS &= 0xFFFFFFFD);
            TurboPicCore.this._W = tmp & 0xFF;
            ++TurboPicCore.this._PC;
            ++TurboPicCore.this._cycle;
        }
    }

    class BreakPoint
    extends PicInstruction {
        PicInstruction target;

        BreakPoint(PicInstruction pi) {
            this.target = pi;
            this.setMnemonic("breakpoint for " + this.target.toString());
        }

        final void execute() {
            this.target.execute();
        }
    }

    class PicInstruction {
        int opcode;
        String mnemonic;

        PicInstruction() {
        }

        void execute() {
        }

        void setOpcode(int _opcode) {
            this.opcode = _opcode;
        }

        int getOpcode() {
            return this.opcode;
        }

        void setMnemonic(String s) {
            this.mnemonic = s;
        }

        public String toString() {
            return this.mnemonic;
        }
    }

    class PicRegINTCONAdapter
    extends PicRegAdapter {
        PicRegINTCONAdapter() {
        }

        public int read() {
            return TurboPicCore.this._INTCON;
        }

        public int readAll() {
            return TurboPicCore.this._INTCON;
        }

        public void write(int value) {
            TurboPicCore.this._INTCON = value;
        }

        public void writeAll(int value) {
            TurboPicCore.this._INTCON = value;
        }
    }

    class PicRegSTATUSAdapter
    extends PicRegAdapter {
        PicRegSTATUSAdapter() {
        }

        public int read() {
            return TurboPicCore.this._STATUS;
        }

        public int readAll() {
            return TurboPicCore.this._STATUS;
        }

        public void write(int value) {
            TurboPicCore.this._STATUS = value;
        }

        public void writeAll(int value) {
            TurboPicCore.this._STATUS = value;
        }
    }

    class PicRegWAdapter
    extends PicRegAdapter {
        PicRegWAdapter() {
        }

        public int read() {
            return TurboPicCore.this._W;
        }

        public int readAll() {
            return TurboPicCore.this._W;
        }

        public void write(int value) {
            TurboPicCore.this._W = value;
        }

        public void writeAll(int value) {
            TurboPicCore.this._W = value;
        }
    }

    class PicRegPCAdapter
    extends PicRegAdapter {
        PicRegPCAdapter() {
        }

        public int getSize() {
            return 13;
        }

        public int getSizeAll() {
            return 13;
        }

        public int read() {
            return TurboPicCore.this._PC;
        }

        public int readAll() {
            return TurboPicCore.this._PC;
        }

        public void write(int value) {
            TurboPicCore.this._PC = value;
        }

        public void writeAll(int value) {
            TurboPicCore.this._PC = value;
        }
    }

    class PicRegAdapter
    implements PicReg {
        PicRegAdapter() {
        }

        public int getSize() {
            return 8;
        }

        public int getSizeAll() {
            return 8;
        }

        public void por() {
            TurboPicCore.this.error(this.getClass() + ".por");
        }

        public void reset() {
            TurboPicCore.this.error(this.getClass() + ".reset");
        }

        public int read() {
            TurboPicCore.this.error(this.getClass() + ".read");
            return -1;
        }

        public int readAll() {
            TurboPicCore.this.error(this.getClass() + ".readAll");
            return -1;
        }

        public void write(int value) {
            TurboPicCore.this.error(this.getClass() + ".write");
        }

        public void writeAll(int value) {
            TurboPicCore.this.error(this.getClass() + ".writeAll");
        }

        public void setBit(int bit, boolean v) {
            TurboPicCore.this.error(this.getClass() + ".setBit");
        }

        public boolean getBit(int bit) {
            TurboPicCore.this.error(this.getClass() + ".getBit");
            return false;
        }

        public void setBreakPoint(int v) {
            TurboPicCore.this.error(this.getClass() + ".setBreakPoint");
        }

        public int getBreakPoint() {
            TurboPicCore.this.error(this.getClass() + ".getBreakPoint");
            return -1;
        }
    }

    class PicMemoryRegbankAdapter
    implements PicMemory {
        PicMemoryRegbankAdapter() {
        }

        public int getWordWidth() {
            return 8;
        }

        public int getMemorySize() {
            return 256;
        }

        public int readMemory(int addr) {
            return TurboPicCore.this.readRegRaw(addr);
        }

        public void writeMemory(int addr, int value) {
            TurboPicCore.this.writeReg(addr, value);
        }
    }

    class PicMemoryStackAdapter
    implements PicMemory {
        PicMemoryStackAdapter() {
        }

        public int getWordWidth() {
            return 14;
        }

        public int getMemorySize() {
            return 8;
        }

        public int readMemory(int addr) {
            return TurboPicCore.this.stack[addr];
        }

        public void writeMemory(int addr, int value) {
            TurboPicCore.this.stack[addr] = value & 0x3FFF;
        }
    }

    class PicMemoryEepromAdapter
    implements PicMemory {
        PicMemoryEepromAdapter() {
        }

        public int getWordWidth() {
            return 8;
        }

        public int getMemorySize() {
            return 64;
        }

        public int readMemory(int addr) {
            return TurboPicCore.this.eeprom[addr];
        }

        public void writeMemory(int addr, int value) {
            TurboPicCore.this.eeprom[addr] = value & 0xFF;
        }
    }

    class PicMemoryEpromAdapter
    extends PicEprom {
        PicMemoryEpromAdapter() {
        }

        public int getWordWidth() {
            return 14;
        }

        public int getMemorySize() {
            return 1024;
        }

        public int readMemory(int addr) {
            if (TurboPicCore.this.program[addr] == null) {
                return new NOP().getOpcode();
            }
            return TurboPicCore.this.program[addr].getOpcode();
        }

        public void writeMemory(int addr, int value) {
            TurboPicCore.this.program[addr] = TurboPicCore.this.decode(value);
        }

        public String getLabel(int addr) {
            String s = (String)TurboPicCore.this.labelTable.get(new Integer(addr));
            if (s != null) {
                return s;
            }
            return "";
        }
    }
}

