/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.Advanceable;
import hades.models.pic.BitSignalElement;
import hades.models.pic.PicBitReg;
import hades.models.pic.PicReg;
import hades.models.pic.SignalElement;
import hades.models.pic.WordSignalElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JComponent;

public class ShowSignals
extends JComponent {
    private Vector signals;
    private int width;
    private int height;
    private boolean enabled;

    public ShowSignals(int newWidth, int newHeight) {
        this.width = newWidth;
        this.height = newHeight;
        this.signals = new Vector();
        this.setSize(this.width, this.height);
        this.setFont(new Font("Monospaced", 0, 12));
        this.enabled = true;
    }

    public ShowSignals() {
        this(600, 400);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void add(PicBitReg bit, String name) {
        BitSignalElement bitSignal = new BitSignalElement(128, bit, name);
        this.signals.addElement(bitSignal);
    }

    public void add(PicReg word, String name) {
        WordSignalElement wordSignal = new WordSignalElement(128, word, name);
        this.signals.addElement(wordSignal);
    }

    public void advance() {
        int i = 0;
        while (i < this.signals.size()) {
            Advanceable signal = (Advanceable)this.signals.elementAt(i);
            signal.advance();
            ++i;
        }
    }

    public void advanceBreak() {
        int i = 0;
        while (i < this.signals.size()) {
            Advanceable signal = (Advanceable)this.signals.elementAt(i);
            signal.advanceBreak();
            ++i;
        }
    }

    public void paint(Graphics g) {
        int vertBase = 1;
        int horizBase = 50;
        int horizStep = 18;
        int vertStep = 20;
        g.setColor(Color.black);
        g.drawLine(horizBase - 2, vertBase, this.width, vertBase);
        g.drawLine(horizBase - 2, vertBase, horizBase - 2, this.height);
        int i = 0;
        while (i < this.signals.size()) {
            SignalElement signal = (SignalElement)this.signals.elementAt(i);
            g.setColor(Color.black);
            g.drawString(signal.getName(), 5, vertBase + 17);
            int lastValue = 0;
            horizBase = 50;
            int j = (this.width - horizBase) / horizStep - 1;
            while (j >= 0) {
                int sigValue = signal.getHistory(j);
                if (sigValue >= 0) {
                    g.setColor(Color.black);
                } else if (sigValue == -10) {
                    g.setColor(Color.blue);
                    g.drawString("-", horizBase + 4, vertBase + 17);
                } else {
                    g.setColor(Color.red);
                    g.drawString(Integer.toString(sigValue), horizBase + 4, vertBase + 17);
                }
                if (sigValue != -10) {
                    if (signal.isSimpleSignal()) {
                        if (lastValue != sigValue) {
                            g.drawLine(horizBase, vertBase + 6, horizBase, vertBase + 18);
                        }
                        if (sigValue == 1) {
                            g.drawLine(horizBase, vertBase + 6, horizBase + horizStep, vertBase + 6);
                        } else if (sigValue == 0) {
                            g.drawLine(horizBase, vertBase + 18, horizBase + horizStep, vertBase + 18);
                        } else {
                            g.drawLine(horizBase, vertBase + 12, horizBase + horizStep, vertBase + 12);
                        }
                    } else {
                        if (lastValue != sigValue) {
                            g.drawLine(horizBase - 2, vertBase + 6, horizBase + 2, vertBase + 18);
                            g.drawLine(horizBase + 2, vertBase + 6, horizBase - 2, vertBase + 18);
                        } else {
                            g.drawLine(horizBase - 1, vertBase + 6, horizBase + 1, vertBase + 6);
                            g.drawLine(horizBase - 1, vertBase + 18, horizBase + 1, vertBase + 18);
                        }
                        if (sigValue >= 0) {
                            if (sigValue > 255) {
                                if (j % 2 == 1) {
                                    g.drawString(Integer.toHexString(sigValue), horizBase + 4, vertBase + 17);
                                }
                            } else {
                                g.drawString(Integer.toHexString(sigValue), horizBase + 4, vertBase + 17);
                            }
                        }
                        g.drawLine(horizBase + 2, vertBase + 6, horizBase + horizStep - 2, vertBase + 6);
                        g.drawLine(horizBase + 2, vertBase + 18, horizBase + horizStep - 2, vertBase + 18);
                    }
                }
                lastValue = sigValue;
                horizBase += horizStep;
                --j;
            }
            vertBase += vertStep;
            ++i;
        }
    }
}

