/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicBitReg;
import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicReg;
import hades.models.pic.PicWordReg;

public class PicTimerReg
extends PicWordReg
implements PicReg {
    private int prescaler = 0;
    private int lock = 0;
    private PicWordReg option;
    private PicBitReg tmrInt;

    public PicTimerReg(PicBreakPoint newBp, PicWordReg newOption, PicBitReg newTmrInt) {
        super(newBp, 8);
        this.tmrInt = newTmrInt;
        this.option = newOption;
        this.por();
    }

    public void por() {
        super.por();
        this.prescaler = 0;
        this.lock = 0;
    }

    public void reset() {
        super.reset();
        this.prescaler = 0;
        this.lock = 0;
    }

    public void internInc() {
        if (!this.option.getBit(5)) {
            if (this.lock > 0) {
                --this.lock;
            } else {
                this.inc();
            }
        }
    }

    public void externInc() {
        if (this.option.getBit(5)) {
            this.inc();
            this.lock = 0;
        }
    }

    private int prescalerMax() {
        int max = 1;
        if (this.option.getBit(0)) {
            ++max;
        }
        if (this.option.getBit(1)) {
            max += 2;
        }
        if (this.option.getBit(2)) {
            max += 4;
        }
        max = 1 << max;
        return max;
    }

    private void inc() {
        boolean hasChanged = false;
        if (this.option.getBit(3)) {
            super.write(super.read() + 1);
            hasChanged = true;
        } else {
            ++this.prescaler;
            if (this.prescaler == this.prescalerMax()) {
                this.prescaler = 0;
                super.write(super.read() + 1);
                hasChanged = true;
            }
        }
        if (hasChanged && super.read() == 0) {
            this.tmrInt.setBit(true);
        }
    }

    private void writeExtensions() {
        if (!this.option.getBit(3)) {
            this.prescaler = 0;
        }
        this.lock = 3;
    }

    public void write(int newValue) {
        this.writeExtensions();
        super.write(newValue);
    }

    public void writeAll(int newValue) {
        this.writeExtensions();
        super.writeAll(newValue);
    }

    public void setBit(int selectedBit, boolean newValue) {
        this.writeExtensions();
        super.setBit(selectedBit, newValue);
    }
}

