/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicBitReg;
import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicByteReg;
import hades.models.pic.PicEecon1Reg;
import hades.models.pic.PicEpromBreakPoints;
import hades.models.pic.PicIndfReg;
import hades.models.pic.PicIntConReg;
import hades.models.pic.PicMemory;
import hades.models.pic.PicNoReg;
import hades.models.pic.PicPcReg;
import hades.models.pic.PicPortReg;
import hades.models.pic.PicReg;
import hades.models.pic.PicTimerReg;
import hades.models.pic.PicWordReg;

public class PicRegBank
implements PicMemory {
    public PicReg[] reg;
    public PicNoReg notImplemented;
    public PicIndfReg indf;
    public PicTimerReg tmr0;
    public PicByteReg option;
    public PicPcReg pcl;
    public PicByteReg status;
    public PicByteReg fsr;
    public PicPortReg porta;
    public PicWordReg trisa;
    public PicPortReg portb;
    public PicWordReg trisb;
    public PicByteReg eedata;
    public PicByteReg eeadr;
    public PicEecon1Reg eecon1;
    public PicNoReg eecon2;
    public PicWordReg pclath;
    public PicIntConReg intcon;
    public static final int BANKSIZE = 128;
    public static final int BANKCOUNT = 4;
    public static final int BANK0 = 0;
    public static final int BANK1 = 128;
    public static final int BANK2 = 256;
    public static final int BANK3 = 384;
    public static final int INDF = 0;
    public static final int PCL = 2;
    public static final int STATUS = 3;
    public static final int FSR = 4;
    public static final int PCLATH = 10;
    public static final int INTCON = 11;
    public static final int PORTA = 5;
    public static final int PORTB = 6;
    public static final int TRISA = 5;
    public static final int TRISB = 6;
    public static final int TMR0 = 1;
    public static final int OPTION = 1;
    public static final int EEDATA = 8;
    public static final int EEADR = 9;
    public static final int EECON1 = 8;
    public static final int EECON2 = 9;
    public PicBitReg tmr0Int = new PicBitReg();
    public PicBitReg extInt = new PicBitReg();
    public PicBitReg rbInt = new PicBitReg();
    public PicBitReg eepromInt = new PicBitReg();

    public PicRegBank(PicBreakPoint bp, PicEpromBreakPoints epromBreakPoints) {
        this.reg = new PicReg[512];
        this.notImplemented = new PicNoReg(bp);
        int i = 0;
        while (i < 512) {
            this.reg[i] = this.notImplemented;
            ++i;
        }
        this.option = new PicByteReg(bp);
        this.tmr0 = new PicTimerReg(bp, this.option, this.tmr0Int);
        this.pclath = new PicWordReg(bp, 5);
        this.pcl = new PicPcReg(bp, this.pclath, epromBreakPoints);
        this.status = new PicByteReg(bp);
        this.fsr = new PicByteReg(bp);
        this.indf = new PicIndfReg(bp, this.fsr, this.status, this.reg);
        this.trisa = new PicWordReg(bp, 5);
        this.trisb = new PicWordReg(bp, 8);
        this.porta = new PicPortReg(bp, 5, this.trisa);
        this.portb = new PicPortReg(bp, 8, this.trisb);
        this.eedata = new PicByteReg(bp);
        this.eeadr = new PicByteReg(bp);
        this.eecon1 = new PicEecon1Reg(bp);
        this.eecon2 = new PicNoReg(bp);
        this.intcon = new PicIntConReg(bp, this.eecon1);
        int bank = 0;
        while (bank < 4) {
            this.reg[0 | bank * 128] = this.indf;
            this.reg[2 | bank * 128] = this.pcl;
            this.reg[3 | bank * 128] = this.status;
            this.reg[4 | bank * 128] = this.fsr;
            this.reg[0xA | bank * 128] = this.pclath;
            this.reg[0xB | bank * 128] = this.intcon;
            ++bank;
        }
        this.buildGeneralPurposeRegisters(bp);
        this.reg[5] = this.porta;
        this.reg[6] = this.portb;
        this.reg[133] = this.trisa;
        this.reg[134] = this.trisb;
        this.reg[1] = this.tmr0;
        this.reg[129] = this.option;
        this.reg[8] = this.eedata;
        this.reg[9] = this.eeadr;
        this.reg[136] = this.eecon1;
        this.reg[137] = this.eecon2;
        this.por();
    }

    public void buildGeneralPurposeRegisters(PicBreakPoint bp) {
        int j = 12;
        while (j < 48) {
            this.reg[j] = new PicByteReg(bp);
            this.reg[j | 0x80] = this.reg[j];
            ++j;
        }
    }

    public void por() {
        int i = 0;
        while (i < 512) {
            this.reg[i].por();
            ++i;
        }
        this.pclath.write(0);
        this.pcl.writePc(0);
        this.status.write(24);
        this.intcon.write(0);
        this.option.write(255);
        this.trisa.write(31);
        this.trisb.write(255);
        this.eecon1.write(0);
    }

    public void reset() {
        int i = 0;
        while (i < 512) {
            this.reg[i].reset();
            ++i;
        }
        this.pclath.write(0);
        this.pcl.write(0);
        this.status.write(this.status.read() & 0x1F);
        this.intcon.write(this.intcon.read() & 1);
        this.option.write(255);
        this.trisa.write(31);
        this.trisb.write(255);
        this.eecon1.write(0);
    }

    public int getWordWidth() {
        return 8;
    }

    public int getMemorySize() {
        return 512;
    }

    public int getFlatAddress(int register) {
        if ((register &= 0x7F) != 0) {
            if (this.status.getBit(5)) {
                register += 128;
            }
            if (this.status.getBit(6)) {
                register += 256;
            }
        }
        return register;
    }

    public int readMemory(int address) {
        return this.reg[address & 0x1FF].read();
    }

    public void writeMemory(int address, int word) {
        this.reg[address & 0x1FF].write(word);
    }

    public int read(int register) {
        register = this.getFlatAddress(register);
        return this.reg[register & 0x1FF].read();
    }

    public void write(int register, int newValue) {
        register = this.getFlatAddress(register);
        this.reg[register & 0x1FF].write(newValue);
    }

    public void setBit(int register, int bit, boolean newValue) {
        register = this.getFlatAddress(register);
        this.reg[register & 0x1FF].setBit(bit, newValue);
    }

    public boolean getBit(int register, int bit) {
        register = this.getFlatAddress(register);
        return this.reg[register & 0x1FF].getBit(bit);
    }
}

