/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.DownListener;
import hades.models.pic.ListListener;
import hades.models.pic.MemTextListener;
import hades.models.pic.PicMemory;
import hades.models.pic.UpListener;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MemoryView
extends JPanel {
    private Font font;
    private JLabel label;
    public JTextField textField;
    private JList list;
    public PicMemory mem;
    private JButton upButton;
    private JButton downButton;
    private int adrWidth;
    private int wordWidth;
    private int lineWidth;
    private int memorySize;
    private int lines;
    private int visible;
    private int wordsPerLine;
    private boolean isStack;
    private int offset;
    private int offsetJump;
    private int[] last;
    private int lastSize;
    private MemTextListener textListener;
    private ListListener listListener;
    private UpListener upListener;
    private DownListener downListener;

    public MemoryView(String name, PicMemory newMem, int newLines, int newVisible, int newWordsPerLine, boolean isStack) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constr = new GridBagConstraints();
        this.isStack = isStack;
        this.mem = newMem;
        this.lines = newLines;
        this.visible = newVisible;
        this.wordsPerLine = newWordsPerLine;
        this.offset = 0;
        this.offsetJump = this.visible / 2 * this.wordsPerLine;
        this.wordWidth = (this.mem.getWordWidth() - 1 >> 2) + 1;
        this.memorySize = this.mem.getMemorySize();
        this.adrWidth = this.memorySize > 4096 ? 4 : (this.memorySize > 256 ? 3 : 2);
        this.lineWidth = this.adrWidth + 1 + this.wordsPerLine * (this.wordWidth + 1);
        this.lastSize = this.wordsPerLine * this.visible;
        this.last = new int[this.lastSize];
        this.font = new Font("Monospaced", 0, 12);
        this.setFont(this.font);
        this.label = new JLabel(name);
        this.label.setFont(this.font);
        this.textField = new JTextField("", this.lineWidth);
        this.textField.setFont(this.font);
        this.list = new JList();
        this.list.setFont(this.font);
        this.buildList();
        this.upButton = new JButton("Up");
        this.downButton = new JButton("Down");
        this.setLayout(gridbag);
        constr.fill = 1;
        constr.gridy = 0;
        gridbag.setConstraints(this.label, constr);
        this.add(this.label);
        gridbag.setConstraints(this.upButton, constr);
        this.add(this.upButton);
        gridbag.setConstraints(this.downButton, constr);
        this.add(this.downButton);
        constr.gridwidth = 0;
        constr.gridy = 1;
        gridbag.setConstraints(this.list, constr);
        this.add(this.list);
        constr.gridy = 2;
        gridbag.setConstraints(this.textField, constr);
        this.add(this.textField);
        this.listListener = new ListListener(this.list, this.textField);
        this.textListener = new MemTextListener(this);
        this.upListener = new UpListener(this);
        this.downListener = new DownListener(this);
        this.textField.addActionListener(this.textListener);
        this.list.addListSelectionListener(this.listListener);
        this.upButton.addActionListener(this.upListener);
        this.downButton.addActionListener(this.downListener);
    }

    public void incOffset() {
        this.offset += this.offsetJump;
    }

    public void decOffset() {
        this.offset -= this.offsetJump;
        if (this.offset < 0) {
            this.offset = 0;
        }
    }

    public String blowString(String str, String fill, int count) {
        String result = str;
        while (result.length() < count) {
            result = fill + result;
        }
        return result;
    }

    public void smartUpdate() {
        int lastIndex = 0;
        int adr = this.offset;
        while (adr < this.lastSize + this.offset) {
            if (this.mem.readMemory(adr) != this.last[lastIndex++]) {
                this.update();
                return;
            }
            ++adr;
        }
    }

    public void update() {
        this.buildList();
    }

    public void buildList() {
        int lastIndex = 0;
        ArrayList<String> content = new ArrayList<String>();
        boolean addStackInfo = this.isStack;
        this.list.removeAll();
        int adr = this.offset;
        while (adr < this.lines * this.wordsPerLine + this.offset) {
            String line = this.blowString(Integer.toHexString(adr), "0", this.adrWidth) + ":";
            int j = 0;
            while (j < this.wordsPerLine) {
                if (this.memorySize > adr + j) {
                    this.last[lastIndex++] = this.mem.readMemory(adr + j);
                    line = line + " " + this.blowString(Integer.toHexString(this.mem.readMemory(adr + j)), "0", this.wordWidth);
                } else if (addStackInfo) {
                    line = line + "  <- StackPtr";
                    addStackInfo = false;
                }
                ++j;
            }
            content.add(line);
            adr += this.wordsPerLine;
        }
        this.list.setListData(content.toArray());
    }
}

