/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.gui.StringDialog;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.pic.PicExec;
import hades.models.pic.PicExec16F84;
import hades.models.pic.PicPortReg;
import hades.models.pic.PicWordReg;
import hades.models.pic.ShowPic2;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.utils.IntegerFormatter;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jfig.utils.ExceptionTracer;

public class FastPic16F84
extends SimObject
implements Simulatable,
Wakeable {
    public ShowPic2 show;
    public StringDialog sd;
    public PicExec pic;
    public PicPortReg regPortA;
    public PicPortReg regPortB;
    public PicWordReg regTrisA;
    public PicWordReg regTrisB;
    public PortStdLogic1164 portClkin;
    public PortStdLogic1164 portClkout;
    public PortStdLogic1164 portMclr;
    public PortStdLogic1164[] portA;
    public PortStdLogic1164[] portB;
    public StdLogic1164 value_Z = Const1164.__Z;
    public StdLogic1164 value_0 = Const1164.__0;
    public StdLogic1164 value_1 = Const1164.__1;
    public Signal signalClkin;
    public Signal signalClkout;
    public Signal signalMclr;
    public Signal[] signalA;
    public Signal[] signalB;
    public int[] currentPortInputsA;
    public int[] currentPortInputsB;
    public int[] lastPortInputsB;
    public int[] currentPortOutputsA;
    public int[] currentPortOutputsB;
    public int n_inputPortChanges;
    public int n_handledPortChanges;
    public int n_cycles = 0;
    public int n_dirty_pa;
    public int n_dirty_ta;
    public int n_dirty_pb;
    public int n_dirty_tb;
    public int lastClk = 0;
    public int lastOsc2 = 0;
    public int lastT0cki = 0;
    public boolean resetActive;
    public double t_delay = 5.0E-8;
    private double wdtPeriod = 7.0E-4;
    private double clk4Period = 1.0E-6;
    static boolean[] _StdLogic1164ToBooleanTable = new boolean[]{false, false, false, true, false, false, false, true, false};

    public void createPicExec() {
        this.pic = new PicExec16F84();
        this.regPortA = this.pic.regBank.porta;
        this.regPortB = this.pic.regBank.portb;
        this.regTrisA = this.pic.regBank.trisa;
        this.regTrisB = this.pic.regBank.trisb;
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.pic.eprom.getFilename()};
        return externals;
    }

    public String toString() {
        return "FastPic16F84: " + this.getFullName();
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "clk period= " + this.clk4Period + " [sec]\n" + "wdt period= " + this.wdtPeriod + " [sec]\n" + "n_instructions= " + IntegerFormatter.formatThousandGroups(this.n_cycles) + "\n" + "pc= " + Integer.toHexString(this.pic.regBank.pcl.read()) + " " + "w= " + Integer.toHexString(this.pic.workReg.read()) + "\n";
    }

    public FastPic16F84() {
        this.createPorts();
        this.createPicExec();
        this.show = new ShowPic2(this.pic);
        this.createClockPeriodGUI();
        this.resetActive = false;
        this.t_delay = 5.0E-8;
        this.signalA = new Signal[5];
        this.signalB = new Signal[8];
        this.currentPortOutputsA = new int[5];
        this.currentPortOutputsB = new int[8];
        this.currentPortInputsA = new int[5];
        this.currentPortInputsB = new int[8];
        this.lastPortInputsB = new int[8];
        this.n_inputPortChanges = 0;
        this.n_handledPortChanges = -1;
    }

    public void createPorts() {
        this.portClkin = new PortStdLogic1164(this, "CLKIN", 0, null);
        this.portClkout = new PortStdLogic1164(this, "CLKOUT", 1, null);
        this.portMclr = new PortStdLogic1164(this, "/MCLR", 0, null);
        this.portA = new PortStdLogic1164[5];
        this.portA[0] = new PortStdLogic1164(this, "A0", 2, null);
        this.portA[1] = new PortStdLogic1164(this, "A1", 2, null);
        this.portA[2] = new PortStdLogic1164(this, "A2", 2, null);
        this.portA[3] = new PortStdLogic1164(this, "A3", 2, null);
        this.portA[4] = new PortStdLogic1164(this, "A4", 2, null);
        this.portB = new PortStdLogic1164[8];
        this.portB[0] = new PortStdLogic1164(this, "B0", 2, null);
        this.portB[1] = new PortStdLogic1164(this, "B1", 2, null);
        this.portB[2] = new PortStdLogic1164(this, "B2", 2, null);
        this.portB[3] = new PortStdLogic1164(this, "B3", 2, null);
        this.portB[4] = new PortStdLogic1164(this, "B4", 2, null);
        this.portB[5] = new PortStdLogic1164(this, "B5", 2, null);
        this.portB[6] = new PortStdLogic1164(this, "B6", 2, null);
        this.portB[7] = new PortStdLogic1164(this, "B7", 2, null);
        this.ports = new Port[16];
        this.ports[0] = this.portClkin;
        this.ports[1] = this.portClkout;
        this.ports[2] = this.portMclr;
        int i = 0;
        while (i < 5) {
            this.ports[i + 3] = this.portA[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < 8) {
            this.ports[i2 + 8] = this.portB[i2];
            ++i2;
        }
    }

    public boolean initialize(String s) {
        block7: {
            String filename = new String();
            boolean load = true;
            try {
                StringTokenizer st = new StringTokenizer(s);
                int n_tokens = st.countTokens();
                if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.clk4Period = Double.valueOf(st.nextToken());
                    load = false;
                } else if (n_tokens == 3) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.clk4Period = Double.valueOf(st.nextToken());
                    filename = NameMangler.decodeUnicodeEscapes(st.nextToken());
                } else {
                    load = false;
                }
                if (load) {
                    this.pic.eprom.setFilename(filename);
                    this.message("-I- Pic16C84: Loading name: " + this.pic.eprom.getFilename());
                    this.message("-I- Pic16C84: Content of adr#0 before reading: " + this.pic.eprom.readMemory(0));
                    this.pic.eprom.load(this, filename);
                    this.message("-I- Pic16C84: Content of adr#0 after reading: " + this.pic.eprom.readMemory(0));
                    this.show.update();
                    break block7;
                }
                this.message("-I- Pic16C84: No default ROM-filename given");
            }
            catch (Exception e) {
                this.message("-E- Pic16C84.initialize(): " + e);
                this.message("-E- offending input is '" + s + "'");
                ExceptionTracer.trace(e);
            }
        }
        return true;
    }

    public void write(PrintWriter ps) {
        this.message("-I- Pic16C84: Writing versionId: " + this.versionId + ", filename: " + this.pic.eprom.getFilename());
        ps.print(" " + this.versionId + " " + this.clk4Period + " " + NameMangler.encodeWithUnicodeEscapes(this.pic.eprom.getFilename()));
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.doPrintPortRegDirtyStatistics();
        }
        this.n_cycles = 0;
        this.n_dirty_tb = 0;
        this.n_dirty_pb = 0;
        this.n_dirty_ta = 0;
        this.n_dirty_pa = 0;
        this.n_inputPortChanges = 0;
        this.n_handledPortChanges = -1;
        this.simulator = this.parent.getSimulator();
        this.resetPortBackupArrays();
        this.readInputPorts();
        if (this.simulator != null) {
            this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.clk4Period, "CLK");
            this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.wdtPeriod, "WDT");
        }
    }

    public void wakeup(Object event) {
        block4: {
            try {
                Object label = ((WakeupEvent)event).getArg();
                if ("CLK".equals(label)) {
                    this.instructionCycle();
                    this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.clk4Period, "CLK");
                    break block4;
                }
                if ("WDT".equals(label)) {
                    this.pic.wdt.inc();
                    this.pic.eeprom.wakeup();
                    this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.wdtPeriod, "WDT");
                    break block4;
                }
                this.message("-E- FastPic: unknown wakeup source: " + label);
            }
            catch (Exception e) {
                this.message("-E- FastPic: illegal wakeup source: " + e);
            }
        }
    }

    private void sample(PicPortReg portReg, int[] intValues) {
        int portRegValue;
        int trisRegValue = portReg.tris.read();
        if (trisRegValue == 0) {
            return;
        }
        int bitMask = 1;
        int newValue = portRegValue = portReg.read();
        int i = 0;
        while (i < portReg.getSize()) {
            if ((trisRegValue & bitMask) != 0) {
                if (this.convertToBoolean(intValues[i])) {
                    newValue |= bitMask;
                } else {
                    newValue |= bitMask;
                    newValue ^= bitMask;
                }
            }
            bitMask += bitMask;
            ++i;
        }
        if (newValue != portRegValue) {
            portReg.write(newValue);
        }
    }

    private void resetPortBackupArrays() {
        int i = 0;
        while (i < this.currentPortOutputsA.length) {
            this.currentPortOutputsA[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.currentPortOutputsB.length) {
            this.currentPortOutputsB[i2] = -1;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.currentPortInputsA.length) {
            this.currentPortInputsA[i3] = 0;
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.currentPortInputsB.length) {
            this.currentPortInputsB[i4] = 0;
            this.lastPortInputsB[i4] = 0;
            ++i4;
        }
    }

    public void printPortBackupArrays() {
        System.out.print("PA in:  ");
        int i = 0;
        while (i < this.currentPortInputsA.length) {
            System.out.print(this.currentPortInputsA[i]);
            ++i;
        }
        System.out.print(" PB in:  ");
        int i2 = 0;
        while (i2 < this.currentPortInputsB.length) {
            System.out.print(this.currentPortInputsB[i2]);
            ++i2;
        }
        System.out.println();
        System.out.print("PA out: ");
        int i3 = 0;
        while (i3 < this.currentPortOutputsA.length) {
            System.out.print(this.currentPortOutputsA[i3]);
            ++i3;
        }
        System.out.print(" PB out: ");
        int i4 = 0;
        while (i4 < this.currentPortOutputsB.length) {
            System.out.print(this.currentPortOutputsB[i4]);
            ++i4;
        }
        System.out.println();
    }

    private void setPortOpen(PicPortReg portReg, Signal[] signal, PortStdLogic1164[] port) {
        int[] backup = null;
        if (portReg == this.regPortA) {
            backup = this.currentPortOutputsA;
        } else if (portReg == this.regPortB) {
            backup = this.currentPortOutputsB;
        } else {
            System.out.println("Pic.setPortOpen unknown port:" + portReg);
        }
        int i = 0;
        while (i < portReg.getSize()) {
            backup[i] = 4;
            if (signal[i] != null && portReg.tris.getBit(i)) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal[i], this.simulator.getSimTime() + this.t_delay, this.value_Z, (Object)port[i]));
            }
            ++i;
        }
    }

    private void setPort(PicPortReg portReg, Signal[] signal, PortStdLogic1164[] port) {
        int[] backup = null;
        if (portReg == this.regPortA) {
            backup = this.currentPortOutputsA;
        } else if (portReg == this.regPortB) {
            backup = this.currentPortOutputsB;
        } else {
            System.out.println("Pic.setPort unknown port:" + portReg);
        }
        int bitMask = 1;
        int trisRegValue = portReg.tris.read();
        int portRegValue = portReg.read();
        int i = 0;
        while (i < portReg.getSize()) {
            if (signal[i] != null) {
                if ((trisRegValue & bitMask) != 0) {
                    if (backup[i] != 4) {
                        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal[i], this.simulator.getSimTime() + this.t_delay, this.value_Z, (Object)port[i]));
                        backup[i] = 4;
                    }
                } else {
                    int newValue = (portRegValue & bitMask) != 0 ? 3 : 2;
                    if (backup[i] != newValue) {
                        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal[i], this.simulator.getSimTime() + this.t_delay, newValue == 3 ? this.value_1 : this.value_0, (Object)port[i]));
                        backup[i] = newValue;
                    }
                }
            }
            bitMask <<= 1;
            ++i;
        }
    }

    public void evaluate(Object arg) {
        try {
            SimEvent event = (SimEvent)arg;
            PortStdLogic1164 target = (PortStdLogic1164)event.getTargetPort();
            StdLogic1164 value = target.getValueOrU();
            int i = 0;
            while (i < this.portA.length) {
                if (this.portA[i] == target) {
                    this.signalA[i] = this.portA[i].getSignal();
                    this.currentPortInputsA[i] = value.intValue();
                    ++this.n_inputPortChanges;
                    return;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.portB.length) {
                if (this.portB[i2] == target) {
                    this.signalB[i2] = this.portB[i2].getSignal();
                    this.currentPortInputsB[i2] = value.intValue();
                    ++this.n_inputPortChanges;
                    return;
                }
                ++i2;
            }
            if (target == this.portMclr) {
                int intValueMclr = this.portMclr.getValueOrU().intValue();
                this.resetActive = !this.convertToBoolean(intValueMclr);
                ++this.n_inputPortChanges;
                return;
            }
            System.err.println("-W- event ignored on port " + target);
        }
        catch (Exception e) {
            System.err.println("-E- internal in " + this.toString() + ".evaluate: " + e);
            e.printStackTrace();
        }
    }

    public void doReset() {
        this.pic.reset();
        this.setPortOpen(this.regPortA, this.signalA, this.portA);
        this.setPortOpen(this.regPortB, this.signalB, this.portB);
    }

    public void readInputPorts() {
        int i = 0;
        while (i < this.currentPortInputsA.length) {
            this.signalA[i] = this.portA[i].getSignal();
            this.currentPortInputsA[i] = this.portA[i].getValueOrU().intValue();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.currentPortInputsB.length) {
            this.signalB[i2] = this.portB[i2].getSignal();
            this.currentPortInputsB[i2] = this.portB[i2].getValueOrU().intValue();
            ++i2;
        }
        this.n_inputPortChanges = 13;
    }

    public void doCheckPortsForInterrupt() {
        if (this.convertToBoolean(this.currentPortInputsB[0]) != this.regPortB.getBit(0) && this.convertToBoolean(this.currentPortInputsB[0]) == this.pic.regBank.option.getBit(6)) {
            this.pic.regBank.extInt.setBit(true);
            this.pic.sleep.setBit(false);
        }
        int i = 4;
        while (i < 8) {
            if (this.currentPortInputsB[i] != this.lastPortInputsB[i]) {
                this.pic.regBank.rbInt.setBit(true);
                this.pic.sleep.setBit(false);
            }
            ++i;
        }
        int i2 = 4;
        while (i2 < 8) {
            this.lastPortInputsB[i2] = this.currentPortInputsB[i2];
            ++i2;
        }
    }

    public void doCheckIncrementTMR0() {
        if (this.pic.regBank.option.getBit(5) && this.convertToBoolean(this.lastT0cki) != this.convertToBoolean(this.currentPortInputsA[4])) {
            if (this.convertToBoolean(this.currentPortInputsA[4]) != this.pic.regBank.option.getBit(4)) {
                this.pic.regBank.tmr0.externInc();
            }
            this.lastT0cki = this.currentPortInputsA[4];
        }
    }

    public void doReadPortsRaw() {
    }

    public void doSamplePorts() {
        this.sample(this.regPortA, this.currentPortInputsA);
        this.sample(this.regPortB, this.currentPortInputsB);
    }

    public void doSetPorts() {
        if (this.regPortA.isDirty() || this.regTrisA.isDirty()) {
            this.setPort(this.regPortA, this.signalA, this.portA);
            if (this.regPortA.isDirty()) {
                ++this.n_dirty_pa;
            }
            if (this.regTrisA.isDirty()) {
                ++this.n_dirty_ta;
            }
            this.regPortA.resetDirtyFlag();
            this.regTrisA.resetDirtyFlag();
        }
        if (this.regPortB.isDirty() || this.regTrisB.isDirty()) {
            this.setPort(this.regPortB, this.signalB, this.portB);
            if (this.regPortB.isDirty()) {
                ++this.n_dirty_pb;
            }
            if (this.regTrisB.isDirty()) {
                ++this.n_dirty_tb;
            }
            this.regPortB.resetDirtyFlag();
            this.regTrisB.resetDirtyFlag();
        }
    }

    public void doPrintPortRegDirtyStatistics() {
        System.out.println("-#- " + this.toString() + " port dirty stats: ");
        System.out.println("n_cycles = " + this.n_cycles);
        System.out.println("portA/trisA dirty= " + this.n_dirty_pa + " " + this.n_dirty_ta);
        System.out.println("portB/trisB dirty= " + this.n_dirty_pb + " " + this.n_dirty_tb);
    }

    public void finalize() throws Throwable {
        if (SimObject.debug) {
            this.doPrintPortRegDirtyStatistics();
        }
        super.finalize();
    }

    public void doCheckBreakpoint() {
        if (this.pic.breakPoint.getIsBreakPoint()) {
            this.show.getFrame().setVisible(true);
            this.pic.breakPoint.por();
            this.message("-I- PIC16C84 breakpoint: " + this.simulator.getSimTime());
            this.simulator.pauseSimulation();
        }
    }

    public void doUpdateShowPic() {
        if (this.show.getSignalFrame().isShowing() && this.show.signals.isEnabled()) {
            this.show.signals.advance();
            this.show.signals.repaint();
        }
        if (this.show.getFrame().isShowing()) {
            this.show.update();
        }
    }

    public void doSetClkout(StdLogic1164 value, double t) {
        if (this.portClkout.getSignal() != null) {
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)this.portClkout.getSignal(), this.simulator.getSimTime() + this.t_delay + t, value, (Object)this.portClkout));
        }
    }

    public void instructionCycle() {
        ++this.n_cycles;
        if (this.resetActive) {
            this.doReset();
        } else {
            this.pic.advance();
            this.pic.clock();
            this.doSetClkout(this.value_0, 0.0);
            this.doCheckIncrementTMR0();
            this.pic.advance();
            this.pic.clock();
            if (this.n_inputPortChanges != this.n_handledPortChanges || this.regTrisA.isDirty() || this.regTrisB.isDirty()) {
                this.doSamplePorts();
                this.doCheckPortsForInterrupt();
                this.n_handledPortChanges = this.n_inputPortChanges;
            }
            this.pic.advance();
            this.pic.clock();
            this.doSetClkout(this.value_1, 0.5 * this.clk4Period);
            this.doCheckIncrementTMR0();
            this.pic.advance();
            this.pic.clock();
            this.doSetPorts();
            this.doCheckBreakpoint();
            this.doUpdateShowPic();
        }
    }

    public Component getPropertySheet() {
        return this.show.getFrame();
    }

    public void configure() {
        this.show.getFrame().setVisible(true);
    }

    public final boolean convertToBoolean(int value) {
        return _StdLogic1164ToBooleanTable[value];
    }

    public boolean convertToBoolean(StdLogic1164 value) {
        return _StdLogic1164ToBooleanTable[value.intValue()];
    }

    public void createClockPeriodGUI() {
        JMenu clockMenu = new JMenu("Clock");
        JMenuItem clockMI = new JMenuItem("Clock period...");
        this.sd = StringDialog.createStringDialog(this.show.getFrame(), "Specify clock period", "");
        this.sd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                block3: {
                    block2: {
                        if (!evt.getActionCommand().equals("Cancel")) break block2;
                        FastPic16F84.this.sd.getDialog().setVisible(false);
                        break block3;
                    }
                    if (!evt.getActionCommand().equals("OK") && evt.getSource() != FastPic16F84.this.sd.getTextComponent()) break block3;
                    FastPic16F84.this.sd.getDialog().setVisible(false);
                    try {
                        FastPic16F84.this.clk4Period = Double.valueOf(FastPic16F84.this.sd.getText().trim());
                        System.err.println("-I- new clock period: " + FastPic16F84.this.clk4Period);
                    }
                    catch (Exception e) {
                        System.err.println("-E- Illegal number format, ignoring!");
                    }
                }
            }
        });
        clockMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("clockMI.actionPerformed..." + FastPic16F84.this.clk4Period);
                FastPic16F84.this.sd.setText("" + FastPic16F84.this.clk4Period);
                FastPic16F84.this.sd.getDialog().setVisible(true);
            }
        });
        try {
            clockMenu.add(clockMI);
            ((JFrame)this.show.getFrame()).getJMenuBar().add(clockMenu);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

