/*
 * Decompiled with CFR 0.152.
 */
package hades.models.microjava;

import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.signals.Signal;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class RAMoe
extends hades.models.rtlib.memory.RAMoe {
    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_DIN = this.port_DIN.getVectorOrUUU();
        StdLogicVector vector_DOUT = null;
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_nOE = this.port_nOE.getValueOrU();
        StdLogic1164 value_nWE = this.port_nWE.getValueOrU();
        int addr = 0;
        long data = 0L;
        long old_data = 0L;
        if (!value_nCS.is_01()) {
            if (!value_nWE.is_1()) {
                this.message("-W- RAMoe: write enable active but chip select undefined: data would be lost. Ignored!");
            }
            vector_DOUT = this.vector_XXX.copy();
        } else if (value_nCS.is_1()) {
            vector_DOUT = this.vector_ZZZ.copy();
        } else if (!value_nWE.is_01()) {
            this.message("-W- RAMoe: chip select active but write enable active: data would be lost. Ignored!");
            vector_DOUT = value_nOE.is_1() ? this.vector_ZZZ.copy() : this.vector_XXX.copy();
        } else if (value_nWE.is_1()) {
            if (value_nOE.is_1()) {
                vector_DOUT = this.vector_ZZZ.copy();
            } else if (value_nOE.is_0()) {
                if (vector_A.has_UXZ()) {
                    this.message("-W- RAMoe: address undefined during read cycle");
                    vector_DOUT = this.vector_XXX.copy();
                } else {
                    addr = (int)vector_A.getValue();
                    data = this.getDataAt(addr);
                    vector_DOUT = new StdLogicVector(this.n_bits, data);
                    this.notifyReadListeners(addr, data);
                }
            } else {
                this.message("-W- RAMoe: nOE undefined during read cycle");
                vector_DOUT = this.vector_XXX.copy();
            }
        } else if (value_nWE.is_0()) {
            if (vector_A.has_UXZ()) {
                this.message("-W- RAMoe: write enable active but address undefined: data would be lost. Ignored!");
            } else if (vector_DIN.has_UXZ()) {
                this.message("-W- RAMoe: write enable active but data input undefined: data would be lost. Ignored!");
            } else {
                addr = (int)vector_A.getValue();
                data = vector_DIN.getValue();
                old_data = this.getDataAt(addr);
                this.setDataAt(addr, data);
                this.notifyWriteListeners(addr, old_data, data);
            }
            vector_DOUT = this.vector_ZZZ.copy();
        }
        Signal signal_DOUT = this.port_DOUT.getSignal();
        if (signal_DOUT != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DOUT, time, vector_DOUT, this.port_DOUT));
        }
    }
}

