/*
 * Decompiled with CFR 0.152.
 */
package hades.models.microjava;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.ColoredValueLabel;
import hades.symbols.FatLabel;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.symbols.TextSource;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class IFU
extends GenericRtlibObject
implements TextSource {
    Label stateLabel;
    static final int MEM_T = 1;
    protected PortStdLogicVector port_Q;
    protected PortStdLogicVector port_C;
    protected PortStdLogicVector port_Opc;
    protected PortStdLogicVector port_D;
    protected PortStdLogicVector port_A;
    protected PortStdLogic1164 port_CLK;
    protected PortStdLogic1164 port_NR;
    protected PortStdLogic1164 port_s;
    protected PortStdLogic1164 port_m16;
    protected PortStdLogic1164 port_m8;
    protected PortStdLogic1164 port_nOE;
    protected PortStdLogic1164 port_mAc;
    protected PortStdLogic1164 port_pcw;
    protected double t_setup = 5.0E-9;
    protected long mar = 0L;
    protected long shift = 0L;
    protected int state = 0;
    protected int memr = 0;
    protected boolean ud = false;

    public IFU() {
        this.n_bits = 48;
    }

    public void constructPorts() {
        this.port_Q = new PortStdLogicVector((SimObject)this, "Q", 1, null, 32);
        this.port_Opc = new PortStdLogicVector((SimObject)this, "Opc", 1, null, 8);
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 1, null, 32);
        this.port_D = new PortStdLogicVector((SimObject)this, "D", 0, null, 32);
        this.port_C = new PortStdLogicVector((SimObject)this, "C", 0, null, 32);
        this.port_CLK = new PortStdLogic1164(this, "CLK", 0, null);
        this.port_NR = new PortStdLogic1164(this, "NR", 0, null);
        this.port_s = new PortStdLogic1164(this, "s", 0, null);
        this.port_m16 = new PortStdLogic1164(this, "m16", 0, null);
        this.port_m8 = new PortStdLogic1164(this, "m8", 0, null);
        this.port_pcw = new PortStdLogic1164(this, "pcw", 0, null);
        this.port_mAc = new PortStdLogic1164(this, "mAc", 0, null);
        this.port_nOE = new PortStdLogic1164(this, "nOE", 1, null);
        this.ports = new Port[13];
        this.ports[0] = this.port_CLK;
        this.ports[1] = this.port_NR;
        this.ports[2] = this.port_s;
        this.ports[3] = this.port_m16;
        this.ports[4] = this.port_m8;
        this.ports[5] = this.port_pcw;
        this.ports[6] = this.port_Q;
        this.ports[7] = this.port_Opc;
        this.ports[8] = this.port_A;
        this.ports[9] = this.port_nOE;
        this.ports[10] = this.port_D;
        this.ports[11] = this.port_C;
        this.ports[12] = this.port_mAc;
        this.vectorOutputPort = null;
    }

    protected void constructStandardValues() {
        this.vector = new StdLogicVector(this.n_bits, Const1164.__U);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- BuffReg.evaluate...");
        }
        StdLogic1164 value_CLK = this.port_CLK.getValueOrU();
        StdLogic1164 value_NR = this.port_NR.getValueOrU();
        StdLogic1164 value_s = this.port_s.getValueOrU();
        StdLogic1164 value_m16 = this.port_m16.getValueOrU();
        StdLogic1164 value_m8 = this.port_m8.getValueOrU();
        StdLogic1164 value_pcw = this.port_pcw.getValueOrU();
        StdLogic1164 value_mAc = this.port_mAc.getValueOrU();
        StdLogicVector value_D = this.port_D.getVectorOrUUU();
        StdLogicVector value_C = this.port_C.getVectorOrUUU();
        if (this.enableAnimationFlag) {
            this.wakeupAfter(this.delay);
        }
        if (value_NR.is_0()) {
            this.mar = 0L;
            this.shift = 0L;
            this.state = 0;
            this.memr = 1;
            this.ud = false;
        } else if (!value_NR.is_1()) {
            this.ud = true;
        } else if (!value_CLK.is_01()) {
            this.ud = true;
        } else if (this.port_CLK.hasEvent() && value_CLK.is_1()) {
            if (this.memr > 0) {
                --this.memr;
                if (this.memr == 0) {
                    if (value_D.has_UXZ()) {
                        this.ud = true;
                    } else {
                        int sc = (int)(this.mar & 3L);
                        this.shift |= value_D.getValue() << 32 + sc * 8 >>> this.state * 8;
                        this.state += 4 - sc;
                        this.mar += 4L - (long)sc;
                    }
                }
            }
            if (!value_m8.is_01() || !value_m16.is_01()) {
                this.ud = true;
            } else if (value_m8.is_1()) {
                if (this.state > 0) {
                    this.shift <<= 8;
                    --this.state;
                } else {
                    this.message("-E- IFU: memory buffer underflow (8 bit fetch)");
                }
            } else if (value_m16.is_1()) {
                if (this.state > 1) {
                    this.shift <<= 16;
                    --this.state;
                    --this.state;
                } else {
                    this.message("-E- IFU: memory buffer underflow (16 bit fetch)");
                }
            }
            if (value_pcw.is_1()) {
                if (value_C.has_UXZ()) {
                    this.ud = true;
                } else {
                    this.mar = value_C.getValue();
                    this.state = 0;
                    this.shift &= 0L;
                }
            } else if (!value_pcw.is_0()) {
                this.ud = true;
            }
            if (this.state <= 4 && this.memr == 0) {
                this.memr = 1;
            }
            if (value_mAc.is_1()) {
                this.memr = 0;
            } else if (!value_mAc.is_0()) {
                this.ud = true;
            }
        }
        if (this.ud) {
            this.scheduleAfter(this.delay, (Port)this.port_Opc, new StdLogicVector(8, Const1164.__X));
        } else {
            this.scheduleAfter(this.delay, (Port)this.port_Opc, new StdLogicVector(8, this.shift >>> 56 & 0xFFL));
        }
        if (value_m16.is_0() == value_m8.is_0()) {
            this.scheduleAfter(this.delay, (Port)this.port_Q, new StdLogicVector(32, Const1164.__Z));
        } else if (this.ud || !value_s.is_01()) {
            this.scheduleAfter(this.delay, (Port)this.port_Q, new StdLogicVector(32, Const1164.__X));
        } else if (value_m16.is_1()) {
            if (value_s.is_1()) {
                this.scheduleAfter(this.delay, (Port)this.port_Q, new StdLogicVector(32, this.shift >> 48 & 0xFFFFFFFFL));
            } else {
                this.scheduleAfter(this.delay, (Port)this.port_Q, new StdLogicVector(32, this.shift >>> 48 & 0xFFFFL));
            }
        } else if (value_m8.is_1()) {
            if (value_s.is_1()) {
                this.scheduleAfter(this.delay, (Port)this.port_Q, new StdLogicVector(32, this.shift >> 56 & 0xFFFFFFFFL));
            } else {
                this.scheduleAfter(this.delay, (Port)this.port_Q, new StdLogicVector(32, this.shift >>> 56 & 0xFFL));
            }
        }
        if (this.memr > 0) {
            if (this.ud) {
                this.scheduleAfter(this.delay, (Port)this.port_A, new StdLogicVector(32, Const1164.__X));
                this.scheduleAfter(this.delay, (Port)this.port_nOE, new StdLogic1164(1));
            } else {
                this.scheduleAfter(this.delay, (Port)this.port_A, new StdLogicVector(32, this.mar));
                this.scheduleAfter(this.delay, (Port)this.port_nOE, new StdLogic1164(2));
            }
        } else {
            this.scheduleAfter(this.delay, (Port)this.port_A, new StdLogicVector(32, Const1164.__Z));
            this.scheduleAfter(this.delay, (Port)this.port_nOE, new StdLogic1164(3));
        }
    }

    public String getText() {
        String s = Long.toHexString(this.shift);
        return ("0000000000000000".substring(s.length()) + s).substring(0, this.state * 2);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        s.setInstanceLabel(this.getName());
        this.valueLabel = new ColoredValueLabel();
        s.addMember(this.valueLabel);
        this.valueLabel.initialize("900  2000   42");
        this.valueLabel.setTextSource(this);
        this.stateLabel = new FatLabel();
        s.addMember(this.stateLabel);
        this.stateLabel.initialize("4200 1200 42");
        this.updateSymbol();
    }

    public void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: " + this.vector);
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (!this.enableAnimationFlag) {
            return;
        }
        if (this.valueLabel != null) {
            this.valueLabel.setColor(Color_DIN_IEC_62.getColor(this.shift));
        }
        if (this.stateLabel != null) {
            this.stateLabel.setText("" + this.state);
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "output delay [sec]:", "delay", "enable animation: [T/F]", "enableAnimationFlag"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setVisible(true);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand the output value. Recognized formats:\nbinary: 0100ZXH0_b,\nhex:    abcd_h\ndecimal: 4711\n");
        this.propertySheet.setVisible(true);
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int n_tokens = st.countTokens();
        try {
            this.versionId = 1001L;
            if (n_tokens >= 1) {
                this.versionId = Integer.parseInt(st.nextToken());
            }
            this.constructStandardValues();
            this.constructPorts();
            if (n_tokens == 2) {
                this.setDelay(st.nextToken());
            }
            if (n_tokens > 2) {
                throw new Exception("invalid number of arguments");
            }
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
            e.printStackTrace();
        }
        return true;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "Buffer=" + this.getText() + "\n" + "State=" + this.state + ", Read=" + this.memr + "\n" + "MAR=" + Long.toHexString(this.mar);
    }
}

