/*
 * Decompiled with CFR 0.152.
 */
package hades.models.meta;

import hades.gui.JythonConsole;
import hades.gui.PropertySheet;
import hades.simulator.SimObject;
import hades.utils.NameMangler;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.utils.ExceptionTracer;

public class JythonScriptWrapper
extends SimObject
implements Serializable {
    String scriptname = "null.py";

    public String getScriptname() {
        return this.scriptname;
    }

    public void setScriptname(String s) {
        this.scriptname = s;
        this.initialize(s);
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.scriptname};
        return externals;
    }

    public boolean initialize(String s) {
        block4: {
            this.scriptname = "";
            try {
                StringTokenizer st = new StringTokenizer(s);
                int n_tokens = st.countTokens();
                if (n_tokens == 1) {
                    this.versionId = 1001L;
                    this.scriptname = NameMangler.decodeUnicodeEscapes(st.nextToken());
                    break block4;
                }
                if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.scriptname = NameMangler.decodeUnicodeEscapes(st.nextToken());
                    break block4;
                }
                throw new Exception(s);
            }
            catch (Exception e) {
                this.message("-E- JythonScriptWrapper.initialize(): " + e);
                this.message("-E- offending input is '" + s + "'");
                ExceptionTracer.message("-E- JythonScriptWrapper.inialize: " + s);
                ExceptionTracer.trace(e);
            }
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.scriptname));
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this JythonScriptWrapper...");
        }
        String[] fields = new String[]{"instance name:", "name", "script file name:", "scriptname"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("JythonScriptWrapper parameters:\nspecify the Java resource name of the script file, \ne.g. '/hades/examples/tutorial/figs/welcome.fig' \n");
        this.propertySheet.setVisible(true);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
        System.out.println("-I- " + this.toString() + ".elaborate()...");
        try {
            this.simulator = this.getSimulator();
            JythonConsole shell = (JythonConsole)this.getEditor().getJythonConsole();
            System.out.println("-#- got the jython shell: " + shell);
            System.out.println("-#- trying to execute script '" + this.scriptname);
            shell.getInterpreter().execfile(this.scriptname);
            System.out.println("-#- script executed, ok.");
        }
        catch (Exception e) {
            System.out.println("-E- " + e);
            e.printStackTrace();
        }
    }

    public String toString() {
        return "JythonScriptWrapper_" + this.getFullName();
    }
}

