/*
 * Decompiled with CFR 0.152.
 */
package hades.models.meta;

import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.NameListener;
import hades.utils.NameMangler;
import java.awt.Component;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class AudioPlayer
extends GenericGate
implements Simulatable,
Serializable {
    private hades.utils.AudioPlayer player = new hades.utils.AudioPlayer();
    private String audioResourceName = "/hades/models/meta/AudioPlayer.wav";
    private PortStdLogic1164 port_C;
    Frame frame;

    public AudioPlayer() {
        this.player.setNameListener(new NameListener(){

            public void nameChanged(String s) {
                AudioPlayer.this.setAudioResourceName(s);
            }
        });
        this.port_C = new PortStdLogic1164(this, "C", 0, null);
        this.ports = new Port[1];
        this.ports[0] = this.port_C;
    }

    public String getAudioResourceName() {
        return this.audioResourceName;
    }

    public void setAudioResourceName(String s) {
        this.audioResourceName = s;
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.getAudioResourceName()};
        return externals;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
        this.simulator = this.parent.getSimulator();
    }

    public void evaluate(Object arg) {
        StdLogic1164 value_C;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()...");
        }
        if ((value_C = this.port_C.getValueOrU()).is_1()) {
            this.player.play();
        } else {
            this.player.stop();
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int n_tokens = st.countTokens();
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            if (n_tokens == 2) {
                this.audioResourceName = NameMangler.decodeUnicodeEscapes(st.nextToken());
                this.player.load(this.audioResourceName);
            }
        }
        catch (Exception e) {
            this.message("-E- AudioPlayer.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.audioResourceName));
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        if (this.frame == null) {
            this.frame = new JFrame("Configure AudioPlayer");
            ((JFrame)this.frame).getContentPane().add("Center", this.player);
            this.frame.pack();
            this.player.setParent(this.frame);
        }
        this.frame.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.frame;
    }

    public SimObject copy() {
        AudioPlayer clone = (AudioPlayer)super.copy();
        clone.setAudioResourceName(this.getAudioResourceName());
        return clone;
    }

    public String toString() {
        return "AudioPlayer: " + this.getFullName();
    }
}

