/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.gui.MemoryHexEditorField;
import hades.models.mcs4.AddressStack;
import hades.models.mcs4.AluRegion;
import hades.models.mcs4.ExecutionUnit;
import hades.models.mcs4.Instruction;
import hades.models.mcs4.InternalState;
import hades.models.mcs4.MemoryWrapper;
import hades.models.mcs4.ScratchPad;
import hades.models.mcs4.i4004;
import hades.models.mcs4.i4004InternalReg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class i4004EditorFrame
extends JDialog {
    private i4004 chip;
    private ExecutionUnit control;
    private AddressStack addresses;
    private ScratchPad regs;
    private AluRegion alu;
    private JLabel stateLabel = new JLabel();
    private JLabel instructionLabel = new JLabel();

    i4004EditorFrame(i4004 chip) {
        super(chip.getEditor().getFrame(), chip.getName());
        this.chip = chip;
        this.control = this.chip.getExecutionUnit();
        this.control.addValueChangeListener(this);
        this.addresses = this.control.getAddressStack();
        this.alu = this.control.getAluRegion();
        this.regs = this.control.getScratchPad();
        this.constructDialog();
    }

    private void constructDialog() {
        JPanel addressPanel = new JPanel(new GridBagLayout());
        addressPanel.setBorder(BorderFactory.createEtchedBorder());
        addressPanel.add((Component)this.getComponent("Addressstack"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getProgramCounter().getName()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getProgramCounter()), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getLevel1().getName()), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getLevel1()), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getLevel2().getName()), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getLevel2()), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getLevel3().getName()), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        addressPanel.add((Component)this.getComponent(this.addresses.getLevel3()), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.setBorder(BorderFactory.createEtchedBorder());
        controlPanel.add((Component)this.getComponent("Control"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getOPR().getName()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getOPR()), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getOPA().getName()), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getOPA()), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)new JLabel("Cycle Clock"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.stateLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getOutputData().getName()), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getOutputData()), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)new JLabel("Instruction"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.instructionLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getCommandLine().getName()), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        controlPanel.add((Component)this.getComponent(this.control.getCommandLine()), new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        JPanel aluPanel = new JPanel(new GridBagLayout());
        aluPanel.setBorder(BorderFactory.createEtchedBorder());
        aluPanel.add((Component)this.getComponent("ALU Region"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getAccu().getName()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getAccu()), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getTempReg().getName()), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getTempReg()), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getCarry().getName()), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getCarry()), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getResult().getName()), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        aluPanel.add((Component)this.getComponent(this.alu.getResult()), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        JPanel regsPanel = new JPanel(new GridBagLayout());
        regsPanel.setBorder(BorderFactory.createEtchedBorder());
        regsPanel.add((Component)this.getComponent("Scratchpad"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        int i = 0;
        while (i <= 15) {
            regsPanel.add((Component)this.getComponent(this.regs.getRegister(i).getName()), new GridBagConstraints(0, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
            regsPanel.add((Component)this.getComponent(this.regs.getRegister(i)), new GridBagConstraints(1, i + 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
            ++i;
        }
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                i4004EditorFrame.this.setVisible(false);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)addressPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.getContentPane().add((Component)controlPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.getContentPane().add((Component)aluPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.getContentPane().add((Component)regsPanel, new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.getContentPane().add((Component)closeButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 0, 3), 0, 0));
    }

    private JComponent getComponent(Object content) {
        if (content instanceof String) {
            return new JLabel((String)content);
        }
        if (content instanceof i4004InternalReg) {
            i4004InternalReg memory = (i4004InternalReg)content;
            MemoryHexEditorField field = new MemoryHexEditorField(memory, 1);
            memory.addMemoryListener(new MemoryWrapper(field));
            field.setEnabled(!memory.isDisplayOnly());
            return field;
        }
        return null;
    }

    void stateChanged(InternalState state) {
        this.stateLabel.setText(state.toString());
    }

    void instructionChanged(Instruction instruction) {
        this.instructionLabel.setText(instruction.getName());
    }
}

