/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcs4.AbstractIntel4000;
import hades.models.mcs4.Instruction;
import hades.models.mcs4.InstructionSet;
import hades.models.mcs4.InternalState;
import hades.models.mcs4.i4001Decoder;
import hades.models.mcs4.i4001EditorFrame;
import hades.models.rtlib.memory.ROM;
import hades.simulator.SimObject;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class i4001
extends AbstractIntel4000 {
    private int id = 0;
    private PortStdLogic1164 port_SYNC;
    private PortStdLogic1164 port_IO0;
    private PortStdLogic1164 port_IO1;
    private PortStdLogic1164 port_IO2;
    private PortStdLogic1164 port_IO3;
    private PortStdLogic1164 port_CM;
    private PortStdLogic1164 port_CL;
    private String typeIO0 = "out";
    private String typeIO1 = "out";
    private String typeIO2 = "out";
    private String typeIO3 = "out";
    private String[] types = new String[]{this.typeIO0, this.typeIO1, this.typeIO2, this.typeIO3};
    private i4001Decoder decoder = new i4001Decoder();
    private InternalRom internalRom = new InternalRom();
    private InstructionSet instructions = InstructionSet.getInstance();
    private Instruction memoryInstruction;
    private StdLogicVector ioBuffer = new StdLogicVector(4);
    private StdLogicVector address = new StdLogicVector(8);
    private StdLogicVector chipNr = new StdLogicVector(4);
    private StdLogicVector dataBuffer = new StdLogicVector(4);
    private StdLogicVector word = new StdLogicVector(8);
    private i4001EditorFrame configFrame = null;
    private boolean chipSelected = false;
    private boolean reset = false;

    public i4001() {
        this.port_SYNC = new PortStdLogic1164(this, "SYNC", 0, null);
        this.port_IO0 = new PortStdLogic1164(this, "IO0", 2, null);
        this.port_IO1 = new PortStdLogic1164(this, "IO1", 2, null);
        this.port_IO2 = new PortStdLogic1164(this, "IO2", 2, null);
        this.port_IO3 = new PortStdLogic1164(this, "IO3", 2, null);
        this.port_CM = new PortStdLogic1164(this, "CM", 0, null);
        this.port_CL = new PortStdLogic1164(this, "CL", 0, null);
        this.ports[7] = this.port_SYNC;
        this.ports[8] = this.port_IO0;
        this.ports[9] = this.port_IO1;
        this.ports[10] = this.port_IO2;
        this.ports[11] = this.port_IO3;
        this.ports[13] = this.port_CM;
        this.ports[14] = this.port_CL;
        this.internalRom.resize(256, 8);
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this.chipSelected = false;
        this.memoryInstruction = null;
        this.ioBuffer.setValue(0L);
        this.sendIO();
        int i = 0;
        while (i < 4) {
            if (this.ports[i + 8].getSignal() != null) {
                StdLogic1164 tmp = new StdLogic1164(4);
                if ("in".equals(this.types[i])) {
                    this.createEvent((PortStdLogic1164)this.ports[i + 8], tmp);
                }
            }
            ++i;
        }
    }

    private void sendIO() {
        int i = 0;
        while (i < 4) {
            if (this.ports[i + 8].getSignal() != null) {
                StdLogic1164 tmp = new StdLogic1164(2);
                if ("out".equals(this.types[i])) {
                    tmp = this.ioBuffer.getBitAt(i);
                    this.createEvent((PortStdLogic1164)this.ports[i + 8], tmp);
                }
            }
            ++i;
        }
    }

    private void receiveIO() {
        int i = 0;
        while (i < 4) {
            if ("in".equals(this.types[i])) {
                this.dataBuffer.setBitAt(i, ((PortStdLogic1164)this.ports[i + 8]).getValueOrU());
            } else {
                this.dataBuffer.setBitAt(i, new StdLogic1164(2));
            }
            ++i;
        }
    }

    protected void stateChanged(InternalState state) {
        if (this.reset) {
            this.dataBuffer.setValue(0L);
            this.chipSelected = false;
            this.word.setValue(0L);
            this.memoryInstruction = null;
            this.setHasOutputData(false);
        } else {
            if (this.chipNr.getValue() == (long)this.id) {
                if (state == InternalState.M1) {
                    this.setHasOutputData(true);
                    if (!this.address.has_UXZ()) {
                        long data = this.internalRom.getWord((int)this.address.getValue());
                        this.word.setValue(data);
                        this.dataBuffer = this.word.subset(7, 4);
                    }
                } else if (state == InternalState.M2 && !this.address.has_UXZ()) {
                    this.dataBuffer = this.word.subset(3, 0);
                }
            }
            if (state == InternalState.X1) {
                this.setHasOutputData(false);
            } else if (state == InternalState.X2 && this.memoryInstruction == InstructionSet.RDR) {
                this.setHasOutputData(true);
                this.receiveIO();
            } else if (state == InternalState.X3) {
                this.setHasOutputData(false);
                this.memoryInstruction = null;
            }
        }
    }

    protected void receiveData(InternalState state) {
        if (this.port_SYNC.getValueOrU().is_0() && state != InternalState.X3) {
            state = InternalState.X3;
            this.setState(state);
        }
        if (this.port_CL.getValueOrU().is_0() && this.ioBuffer.getValue() != 0L) {
            this.ioBuffer.setValue(0L);
        }
        if (state == InternalState.A1) {
            this.address.setValue(this.receiveData().getValue());
        } else if (state == InternalState.A2) {
            StdLogicVector tmp = this.receiveData();
            int i = 0;
            while (i < 4) {
                this.address.setBitAt(i + 4, tmp.getBitAt(i));
                ++i;
            }
        } else if (state == InternalState.A3) {
            this.chipNr.setValue(this.receiveData().getValue());
        } else if (state == InternalState.M2 && this.port_CM.getValueOrU().is_0() && this.chipSelected) {
            Integer opaCode = new Integer((int)this.receiveData().getValue());
            this.memoryInstruction = this.instructions.getMemoryInstruction(opaCode);
        } else if (state == InternalState.X2) {
            if (this.port_CM.getValueOrU().is_0()) {
                boolean bl = this.chipSelected = this.receiveData().getValue() == (long)this.id;
            }
            if (this.memoryInstruction == InstructionSet.WRR) {
                this.ioBuffer.setValue(this.receiveData().getValue());
                this.sendIO();
            }
        } else if (state == InternalState.X3) {
            if (this.getReset().is_0()) {
                this.reset = true;
            } else if (this.reset) {
                this.reset = false;
            }
        }
    }

    protected StdLogicVector getOutputData() {
        return this.dataBuffer;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        st.nextToken();
        if (st.hasMoreTokens()) {
            this.setId(st.nextToken());
            this.setTypeIO0(st.nextToken());
            this.setTypeIO1(st.nextToken());
            this.setTypeIO2(st.nextToken());
            this.setTypeIO3(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.internalRom.setResourcename(st.nextToken());
            this.internalRom.parseRAM(this.internalRom.getResourcename());
        }
        return true;
    }

    public void write(PrintWriter ps) {
        super.write(ps);
        ps.print(" " + this.id);
        ps.print(" " + this.typeIO0);
        ps.print(" " + this.typeIO1);
        ps.print(" " + this.typeIO2);
        ps.print(" " + this.typeIO3);
        if (this.internalRom.getResourcename() != null) {
            String resName = this.internalRom.getResourcename();
            int lastSlash = resName.lastIndexOf("/");
            String name = resName.substring(lastSlash + 1, resName.length());
            ps.print(" " + name);
        }
    }

    public void configure() {
        if (this.configFrame == null) {
            this.configFrame = this.internalRom.getFrame();
        }
        if (!this.configFrame.isVisible()) {
            this.configFrame.pack();
            this.configFrame.setVisible(true);
        }
        if (this.propertySheet == null) {
            this.propertySheet = PropertySheet.getPropertySheet(this, null);
        }
    }

    public String getId() {
        return String.valueOf(this.id);
    }

    public String getTypeIO0() {
        return this.typeIO0;
    }

    public String getTypeIO1() {
        return this.typeIO1;
    }

    public String getTypeIO2() {
        return this.typeIO2;
    }

    public String getTypeIO3() {
        return this.typeIO3;
    }

    public void setId(String value) {
        int id = Integer.parseInt(value);
        if (id < 0 || id > 15) {
            return;
        }
        this.id = id;
    }

    public void setTypeIO0(String value) {
        this.types[0] = this.typeIO0 = value;
    }

    public void setTypeIO1(String value) {
        this.types[1] = this.typeIO1 = value;
    }

    public void setTypeIO2(String value) {
        this.types[2] = this.typeIO2 = value;
    }

    public void setTypeIO3(String value) {
        this.types[3] = this.typeIO3 = value;
    }

    public void setParent(SimObject parent) {
        super.setParent(parent);
        this.internalRom.setParent(parent);
    }

    private class InternalRom
    extends ROM {
        InternalRom() {
            this.setInstructionDecoder(i4001.this.decoder);
        }

        public long getWord(int address) {
            long data = this.getDataAt(address);
            this.notifyReadListeners(address, data);
            return data;
        }

        public PropertySheet getConfigDialog() {
            return i4001.this.propertySheet;
        }

        public boolean canChangeSize() {
            return false;
        }

        public i4001EditorFrame getFrame() {
            if (i4001.this.configFrame == null) {
                this.createConfigFrame();
            }
            return i4001.this.configFrame;
        }

        protected void createConfigFrame() {
            int n_lines = (int)Math.ceil((double)i4001.this.internalRom.getSize() / 8.0);
            if (n_lines > 40) {
                n_lines = 40;
            }
            i4001.this.configFrame = new i4001EditorFrame(i4001.this.internalRom, n_lines, 8, "Edit " + i4001.this.getName() + " " + i4001.this.internalRom.getClass().getName());
            i4001.this.internalRom.addMemoryListener(i4001.this.configFrame);
            i4001.this.decoder.setMemory(this);
        }
    }
}

