/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

final class Instruction {
    public static final int NO_ARGS = 0;
    public static final int ONE_REG = 1;
    public static final int REG_PAIR = 2;
    public static final int DATA = 3;
    public static final int FULL_ADDRESS = 4;
    public static final int CONDITIONAL = 5;
    public static final int REG_ADDRESS = 6;
    public static final int REG_DATA = 7;
    private Integer oprCode;
    private Integer opaCode;
    private String name;
    private boolean is2word = false;
    private int argType = 0;

    Instruction(Integer oprCode, String name, int argType) {
        this(oprCode, null, name);
        this.argType = argType;
    }

    Instruction(Integer oprCode, String name, boolean is2word, int argType) {
        this(oprCode, null, name);
        this.is2word = is2word;
        this.argType = argType;
    }

    Instruction(Integer oprCode, Integer opaCode, String name) {
        if (oprCode == null) {
            throw new IllegalArgumentException("OPR must be set!");
        }
        this.oprCode = oprCode;
        this.opaCode = opaCode;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOPR() {
        return this.oprCode;
    }

    public Integer getOPA() {
        return this.opaCode;
    }

    public boolean is2word() {
        return this.is2word;
    }

    public int getArgType() {
        return this.argType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instruction)) {
            throw new IllegalArgumentException("Object must be an Instruction!");
        }
        Instruction instruction = (Instruction)obj;
        return this.oprCode.intValue() == instruction.oprCode.intValue() && (this.opaCode == null || instruction.opaCode == null || this.opaCode.intValue() == instruction.opaCode.intValue());
    }

    public String toString() {
        return this.name;
    }
}

