/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.models.StdLogicVector;
import hades.models.mcs4.i4004InternalReg;

class AluRegion {
    static final int A_ADD_T = 1;
    static final int A_SUB_T = 2;
    static final int ROL = 3;
    static final int ROR = 4;
    static final int DECIMAL_ADJUST = 5;
    private i4004InternalReg accu = new i4004InternalReg("Accumulator", 4);
    private i4004InternalReg tempReg = new i4004InternalReg("Temp. Register", 4);
    private i4004InternalReg alu = new i4004InternalReg("ALU", 4, true);
    private i4004InternalReg carry = new i4004InternalReg("Carry", 1);
    private final StdLogicVector decimalAdjust = new StdLogicVector(4, 6L);
    private long result;

    AluRegion() {
    }

    void elaborate() {
        this.setCarry(0L);
    }

    void setAccu(long data) {
        this.accu.setValue(data);
    }

    void setTempReg(long data) {
        this.tempReg.setValue(data);
    }

    void setCarry(long data) {
        this.carry.setValue(data);
    }

    i4004InternalReg getResult() {
        return this.alu;
    }

    i4004InternalReg getAccu() {
        return this.accu;
    }

    i4004InternalReg getTempReg() {
        return this.tempReg;
    }

    i4004InternalReg getCarry() {
        return this.carry;
    }

    boolean isCarrySet() {
        return this.carry.getValue() == 1L;
    }

    void calculate(int opCode) {
        switch (opCode) {
            case 1: {
                this.result = this.add(opCode);
                this.checkOverflow();
                break;
            }
            case 2: {
                this.result = this.add(opCode);
                this.checkOverflow();
                break;
            }
            case 3: {
                this.result = (this.accu.getValue() << 1) + this.carry.getValue();
                this.checkOverflow();
                break;
            }
            case 4: {
                this.result = this.accu.getValue() + 16L * this.carry.getValue();
                if (((int)this.result & 1) == 1) {
                    this.setCarry(1L);
                } else {
                    this.setCarry(0L);
                }
                this.result >>= 1;
                break;
            }
            case 5: {
                this.result = this.accu.getValue();
                if (this.result > 9L && !this.isCarrySet()) {
                    this.result += this.decimalAdjust.getValue();
                    this.checkOverflow();
                    break;
                }
                if (this.result < 3L && this.isCarrySet()) {
                    this.result += this.decimalAdjust.getValue();
                    this.setCarry(1L);
                    break;
                }
                if (this.result <= 5L || !this.isCarrySet()) break;
                this.result -= this.decimalAdjust.getValue();
            }
        }
        this.alu.setValue(this.result);
    }

    private long add(int opCode) {
        StdLogicVector tempTemp = new StdLogicVector(4, this.tempReg.getValue());
        StdLogicVector carryTemp = new StdLogicVector(1, this.carry.getValue());
        StdLogicVector tempXor = new StdLogicVector(4, 0L);
        StdLogicVector carryXor = new StdLogicVector(1, 0L);
        if (opCode == 2) {
            tempXor.setValue(15L);
            carryXor.setValue(1L);
        }
        long result = this.accu.getValue() + tempTemp.xor_bitwise(tempXor).getValue();
        return result += carryTemp.xor_bitwise(carryXor).getValue();
    }

    private void checkOverflow() {
        if (this.result > 15L) {
            this.result -= 16L;
            this.setCarry(1L);
        } else {
            this.setCarry(0L);
        }
    }
}

