/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcore.DcoreRAM;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class DcoreROM
extends DcoreRAM {
    public DcoreROM() {
        this.constructPorts();
        this.addr_offset = 0;
    }

    @Override
    protected void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth() + 1);
        this.port_DOUT = new PortStdLogicVector((SimObject)this, "DOUT", 1, null, this.n_bits);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.port_nOE = new PortStdLogic1164(this, "nOE", 0, null);
        this.ports = new Port[4];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_DOUT;
        this.ports[2] = this.port_nCS;
        this.ports[3] = this.port_nOE;
    }

    @Override
    public void evaluate(Object object) {
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double d = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector stdLogicVector = this.port_A.getVectorOrUUU();
        StdLogicVector stdLogicVector2 = null;
        StdLogic1164 stdLogic1164 = this.port_nCS.getValueOrU();
        StdLogic1164 stdLogic11642 = this.port_nOE.getValueOrU();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        if (!stdLogic1164.is_01()) {
            stdLogicVector2 = this.vector_XXX.copy();
        } else if (stdLogic1164.is_1()) {
            stdLogicVector2 = this.vector_ZZZ.copy();
        } else if (!stdLogic11642.is_01()) {
            stdLogicVector2 = this.vector_XXX.copy();
        } else if (stdLogic11642.is_1()) {
            stdLogicVector2 = this.vector_ZZZ.copy();
        } else if (stdLogic11642.is_0()) {
            if (stdLogicVector.has_UXZ()) {
                this.message("-W- " + this.toString() + ": address undefined during read cycle");
                stdLogicVector2 = this.vector_XXX.copy();
            } else {
                n2 = (int)stdLogicVector.getValue();
                if ((n2 & 1) != 0) {
                    this.message("-W- " + this.toString() + ": misaligned read access at addr: " + n2);
                }
                n = n2 >>> 1;
                l = this.getDataAt(n);
                stdLogicVector2 = new StdLogicVector(this.n_bits, l);
                this.notifyReadListeners(n, l);
            }
        }
        Signal signal = this.port_DOUT.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(new SimEvent(signal, d, stdLogicVector2, this.port_DOUT));
        }
    }

    @Override
    public void configure() {
        super.configure();
        this.editor.setDefaultExtension(".rom");
    }
}

