/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.gui.MemoryEditorFrame;
import hades.gui.MemoryHexEditorField;
import hades.models.mcore.DcoreDecoder;
import hades.models.mcore.DcoreDisassemblerOrHexCanvas;
import hades.models.mcore.DcoreRAM;
import hades.models.memory.Memory;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jfig.utils.SetupManager;

public class DcoreDisassemblerEditorFrame
extends MemoryEditorFrame {
    public static String versionString = "MemoryEditor 0.12";
    public static String helpfilename = "/hades/doc/help/MemoryEditorKeyMapping.txt";
    private JMenu formatMenu;
    private JMenuItem formatHexMI;
    private JMenuItem formatDisassembleMI;
    private JMenuItem clearLabelsMI;
    private Memory memoryObject;
    private DcoreDisassemblerOrHexCanvas memoryCanvas;
    private DcoreDecoder decoder;
    private int n_words_per_row;

    public DcoreDisassemblerEditorFrame(Memory memory, int n, int n2, String string) {
        super(memory, n, n2, string);
        this.memoryObject = memory;
        this.n_words_per_row = n2;
    }

    @Override
    protected MemoryHexEditorField getDisplayComponent() {
        if (this.memoryCanvas == null) {
            this.memoryCanvas = new DcoreDisassemblerOrHexCanvas(this.memoryObject, this.getDecoder(), this.n_words_per_row);
        }
        return this.memoryCanvas;
    }

    @Override
    protected void buildMenus() {
        super.buildMenus();
        this.formatMenu = new JMenu("Format");
        this.formatHexMI = new JMenuItem("hex");
        this.formatDisassembleMI = new JMenuItem("disassemble");
        this.clearLabelsMI = new JMenuItem("clear labels");
        this.formatMenu.add(this.formatHexMI);
        this.formatMenu.add(this.formatDisassembleMI);
        this.formatMenu.add(this.clearLabelsMI);
        this.getEditMenu().addSeparator();
        this.getEditMenu().add(this.formatMenu);
    }

    @Override
    protected void buildCallbacks() {
        super.buildCallbacks();
        this.formatHexMI.addActionListener(this);
        this.formatDisassembleMI.addActionListener(this);
        this.clearLabelsMI.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.formatHexMI) {
            this.selectHexFormat();
        } else if (object == this.formatDisassembleMI) {
            this.selectDisassembledFormat();
        } else if (object == this.clearLabelsMI) {
            this.clearDecoderLabels();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void selectHexFormat() {
        ((DcoreDisassemblerOrHexCanvas)this.getDisplayComponent()).selectHexFormat();
    }

    public void selectDisassembledFormat() {
        ((DcoreDisassemblerOrHexCanvas)this.getDisplayComponent()).selectDisassembledFormat();
    }

    public void clearDecoderLabels() {
        System.out.println("-# clearDecoderLabels...");
        if (this.getDecoder() != null) {
            this.getDecoder().clearAllLabels();
        }
    }

    public DcoreDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = new DcoreDecoder();
        }
        return this.decoder;
    }

    public static void main(String[] stringArray) {
        System.out.println("-I- DcoreDisassemblerEditorFrame selftest...");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        DcoreRAM dcoreRAM = new DcoreRAM();
        dcoreRAM.initialize("1001 1024 16 32768");
        dcoreRAM.initializeWithRandomValues();
        DcoreDecoder dcoreDecoder = new DcoreDecoder();
        int[] nArray = new int[]{0, 7, 20, 21, 33, 38, 1023};
        for (int i = 0; i < nArray.length; ++i) {
            dcoreDecoder.addLabel(nArray[i], "L_" + nArray[i]);
        }
        String string = "DcoreDisassemblerEditorFrame selftest";
        DcoreDisassemblerEditorFrame dcoreDisassemblerEditorFrame = null;
        dcoreDisassemblerEditorFrame = new DcoreDisassemblerEditorFrame(dcoreRAM, 32, 8, string);
        dcoreDisassemblerEditorFrame.setVisible(true);
        dcoreDisassemblerEditorFrame.pack();
        dcoreDisassemblerEditorFrame.memoryRead(20, 0L);
        dcoreDisassemblerEditorFrame.memoryWrite(6, 0L, 0L);
    }
}

