/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.models.memory.InstructionDecoder;
import hades.utils.HexFormat;
import java.util.Hashtable;

public class DcoreDecoder
implements InstructionDecoder {
    int instruction;
    int address;
    int opcode;
    int x;
    int y;
    int cccc;
    int imm12;
    int aluopc;
    Hashtable labelTable = new Hashtable(10);
    private static String[] regnames = new String[]{"R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15"};

    public void decode(int n) {
        this.instruction = n;
        this.address = -1;
        this.opcode = (this.instruction & 0xF000) >> 12;
        this.x = this.instruction & 0xF;
        this.y = (this.instruction & 0xF0) >> 4;
        this.cccc = (this.instruction & 0xF00) >> 7;
        this.aluopc = (this.instruction & 0x1F00) >> 8;
        this.imm12 = this.instruction & 0xFFF;
        if (this.imm12 > 2047) {
            this.imm12 |= 0xFFFFF000;
        }
    }

    @Override
    public void decode(int n, int n2) {
        this.decode(n);
        this.address = n2;
    }

    public int getInstruction() {
        return this.instruction;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getAluOpc() {
        return this.aluopc;
    }

    public int getCCCC() {
        return this.cccc;
    }

    public int getIMM12() {
        return this.imm12;
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    public String disassemble() {
        switch (this.opcode) {
            case 0: {
                return this._illegal();
            }
            case 1: {
                return this._illegal();
            }
            case 2: {
                switch (this.aluopc & 0xF) {
                    case 0: {
                        return "mov    " + this._RX() + ", " + this._RY();
                    }
                    case 1: {
                        return "addu   " + this._RX() + ", " + this._RY();
                    }
                    case 2: {
                        return "addc   " + this._RX() + ", " + this._RY() + ", C";
                    }
                    case 3: {
                        return "subu   " + this._RX() + ", " + this._RY();
                    }
                    case 4: {
                        return "and    " + this._RX() + ", " + this._RY();
                    }
                    case 5: {
                        return "or     " + this._RX() + ", " + this._RY();
                    }
                    case 6: {
                        return "xor    " + this._RX() + ", " + this._RY();
                    }
                    case 7: {
                        return "not    " + this._RX();
                    }
                    case 8: {
                        return "lsl    " + this._RX() + ", " + this._RY();
                    }
                    case 9: {
                        return "lsr    " + this._RX() + ", " + this._RY();
                    }
                    case 10: {
                        return "asr    " + this._RX() + ", " + this._RY();
                    }
                    case 11: {
                        return this._illegal();
                    }
                    case 12: {
                        return "lslc   " + this._RX();
                    }
                    case 13: {
                        return "lsrc   " + this._RX();
                    }
                    case 14: {
                        return "rlc    " + this._RX();
                    }
                    case 15: {
                        return "rrc    " + this._RX();
                    }
                }
                return this._illegal();
            }
            case 3: {
                switch (this.aluopc & 0xF) {
                    case 0: {
                        return "cmpe   " + this._RX() + ", " + this._RY();
                    }
                    case 1: {
                        return "cmpne  " + this._RX() + ", " + this._RY();
                    }
                    case 2: {
                        return "cmpgt  " + this._RX() + ", " + this._RY();
                    }
                    case 3: {
                        return "cmplt  " + this._RX() + ", " + this._RY();
                    }
                    case 4: {
                        return "movi   " + this._RX() + ", " + this._IMM4();
                    }
                    case 5: {
                        return "addi   " + this._RX() + ", " + this._IMM4();
                    }
                    case 6: {
                        return "subi   " + this._RX() + ", " + this._IMM4();
                    }
                    case 7: {
                        return "andi   " + this._RX() + ", " + this._IMM4();
                    }
                    case 8: {
                        return "lsli   " + this._RX() + ", " + this._IMM4();
                    }
                    case 9: {
                        return "lsri   " + this._RX() + ", " + this._IMM4();
                    }
                    case 10: {
                        return "bseti  " + this._RX() + ", " + this._IMM4();
                    }
                    case 11: {
                        return "bclri  " + this._RX() + ", " + this._IMM4();
                    }
                }
                return this._illegal();
            }
            case 4: {
                return "ldw    " + this._RX() + ", " + this._CCCC() + "(" + this._RY() + ")";
            }
            case 5: {
                return "stw    " + this._RX() + ", " + this._CCCC() + "(" + this._RY() + ")";
            }
            case 6: {
                return this._illegal();
            }
            case 7: {
                return this._illegal();
            }
            case 8: {
                return "br     " + this._Label();
            }
            case 9: {
                return "jsr    " + this._Label();
            }
            case 10: {
                return "bt     " + this._Label();
            }
            case 11: {
                return "bf     " + this._Label();
            }
            case 12: {
                return "jmp    " + this._RX();
            }
            case 13: {
                return "trap   " + this.x;
            }
            case 14: {
                return "rfi    ";
            }
            case 15: {
                if (this.instruction == -1) {
                    return this._xxxx();
                }
                return "halt   ";
            }
        }
        return this._illegal();
    }

    private String _RX() {
        return regnames[this.x];
    }

    private String _RY() {
        return regnames[this.y];
    }

    private String _CCCC() {
        return Integer.toString(this.cccc);
    }

    private String _IMM4() {
        return Integer.toString(this.y);
    }

    private String _illegal() {
        if (this.instruction >= 0 && this.instruction <= 255) {
            return "---    data: " + this.toHexString(this.instruction, 4) + "  '" + (char)this.instruction + "'";
        }
        return "---    data: " + this.toSignedDecimalString(this.instruction);
    }

    private String _xxxx() {
        return "invalid or undefined data";
    }

    private String _Label() {
        if (this.address <= -1) {
            return Integer.toString(this.imm12);
        }
        Integer n = new Integer(this.address + 2 + this.imm12 & 0xFFFF);
        String string = (String)this.labelTable.get(n);
        if (string != null) {
            return string;
        }
        return this.toHexString((int)(n & 0xFFFF), 4);
    }

    @Override
    public void addLabel(int n, String string) {
        if (string != null) {
            this.labelTable.put(new Integer(n), string);
        }
    }

    @Override
    public String getLabel(int n) {
        return (String)this.labelTable.get(new Integer(n));
    }

    @Override
    public void clearAllLabels() {
        this.labelTable = new Hashtable(10);
    }

    private String toHexString(int n, int n2) {
        return "0x" + HexFormat.getHexString(n, n2);
    }

    private String toSignedDecimalString(int n) {
        if ((n & 0x8000) != 0) {
            n |= 0xFFFF0000;
        }
        return "" + n;
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void usage() {
        DcoreDecoder.msg("Usage: java hades.models.mcore.DcoreDecoder ntests");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        DcoreDecoder.msg("DcoreDecoder selftest...");
        int n = 25;
        DcoreDecoder dcoreDecoder = new DcoreDecoder();
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            DcoreDecoder.usage();
        }
        dcoreDecoder.addLabel(32, "LABEL_0020");
        dcoreDecoder.addLabel(66, "LABEL_0042");
        dcoreDecoder.addLabel(256, "LABEL_0100");
        dcoreDecoder.decode(32798, 0);
        DcoreDecoder.msg(dcoreDecoder.toHexString(dcoreDecoder.getInstruction(), 4) + "  " + dcoreDecoder.disassemble());
        dcoreDecoder.decode(32770, 28);
        DcoreDecoder.msg(dcoreDecoder.toHexString(dcoreDecoder.getInstruction(), 4) + "  " + dcoreDecoder.disassemble());
        dcoreDecoder.decode(32800, 0);
        DcoreDecoder.msg(dcoreDecoder.toHexString(dcoreDecoder.getInstruction(), 4) + "  " + dcoreDecoder.disassemble());
        dcoreDecoder.decode(41214, 0);
        DcoreDecoder.msg(dcoreDecoder.toHexString(dcoreDecoder.getInstruction(), 4) + "  " + dcoreDecoder.disassemble());
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)(Math.random() * 65535.0);
            dcoreDecoder.decode(n3, n2);
            DcoreDecoder.msg(dcoreDecoder.toHexString(n3, 4) + "  " + dcoreDecoder.disassemble());
        }
    }
}

