/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ClockArm;
import hades.symbols.Symbol;
import java.awt.Color;
import java.io.Serializable;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;

public class Swatch
extends SimObject
implements Simulatable,
Serializable {
    private int time_hrs;
    private int time_mins;
    private int time_secs;
    private int stop_mins;
    private int stop_secs;
    private int stop_tenths;
    private StdLogic1164 output_1;
    private StdLogic1164 output_0;
    private Port port_time;
    private Port port_mins;
    private Port port_secs;
    private Port port_tenths;
    private Port port_startstop;
    private Port port_resetpause;
    private Port port_zero_mins;
    private Port port_zero_secs;
    private Port port_zero_tenths;
    private FigCompound allArms;
    private ClockArm[] arms;
    private ClockArm arm_hrs;
    private ClockArm arm_mins;
    private ClockArm arm_secs;
    private ClockArm arm_stop_mins;
    private ClockArm arm_stop_secs;
    private ClockArm arm_stop_tenths;
    private static double CLOCK12 = 1.5707963267948966;
    private static double D_HOUR = 0.5235987755982988;
    private static double D_MINUTE = 0.10471975511965977;
    private static double D_SECOND = 0.10471975511965977;
    private static double D_TENTH = 0.6283185307179586;

    public Swatch() {
        this.ports = new Port[9];
        this.ports[0] = new Port(this, "m_time", 0, null);
        this.ports[1] = new Port(this, "m_min", 0, null);
        this.ports[2] = new Port(this, "m_sec", 0, null);
        this.ports[3] = new Port(this, "m_1/10", 0, null);
        this.ports[4] = new Port(this, "startstop", 1, null);
        this.ports[5] = new Port(this, "resetpause", 1, null);
        this.ports[6] = new Port(this, "z_min", 1, null);
        this.ports[7] = new Port(this, "z_sec", 1, null);
        this.ports[8] = new Port(this, "z_1/10", 1, null);
        this.port_time = this.ports[0];
        this.port_mins = this.ports[1];
        this.port_secs = this.ports[2];
        this.port_tenths = this.ports[3];
        this.port_startstop = this.ports[4];
        this.port_resetpause = this.ports[5];
        this.port_zero_mins = this.ports[6];
        this.port_zero_secs = this.ports[7];
        this.port_zero_tenths = this.ports[8];
        this.output_0 = new StdLogic1164(2);
        this.output_1 = new StdLogic1164(3);
        this.time_secs = 0;
        this.time_mins = 0;
        this.time_hrs = 0;
        this.stop_tenths = 0;
        this.stop_secs = 0;
        this.stop_mins = 0;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        Symbol symbol = this.getSymbol();
        this.arms = new ClockArm[6];
        int i = 0;
        while (i < this.arms.length) {
            this.arms[i] = new ClockArm();
            FigAttribs attr = this.arms[i].getAttributes();
            attr.lineColor = ColorCache.getColorCache().get(12);
            attr.lineWidth = 1.0;
            this.arms[i].setAttributes(attr);
            ++i;
        }
        this.arm_hrs = this.arms[0];
        this.arm_mins = this.arms[1];
        this.arm_secs = this.arms[2];
        this.arm_stop_mins = this.arms[3];
        this.arm_stop_secs = this.arms[4];
        this.arm_stop_tenths = this.arms[5];
        this.arm_hrs.setLineWidth(400);
        this.arm_mins.setLineWidth(200);
        this.arm_secs.setLineWidth(60);
        this.arm_stop_secs.setLineWidth(90);
        this.arm_stop_mins.setLineWidth(60);
        this.arm_stop_tenths.setLineWidth(60);
        this.arm_hrs.setColor(Color.blue);
        this.arm_mins.setColor(Color.blue);
        this.arm_secs.setColor(Color.blue);
        this.arms[0].initialize("6000 6000 3000 1.57079");
        this.arms[1].initialize("6000 6000 3800 1.57079");
        this.arms[2].initialize("6000 8400 1000 1.57079");
        this.arms[3].initialize("3600 4800 1000 1.57079");
        this.arms[4].initialize("6000 6000 4200 1.57079");
        this.arms[5].initialize("8400 4800 1000 1.57079");
        this.allArms = new FigCompound();
        this.allArms.setTrafo(symbol.getTrafo());
        int i2 = 0;
        while (i2 < this.arms.length) {
            this.allArms.fastAddMember(this.arms[i2]);
            ++i2;
        }
        this.allArms.setObjectPainter(symbol.painter);
        this.allArms.update_bbox();
        symbol.fastAddMember(this.allArms);
        symbol.update_bbox();
    }

    private void show() {
        this.arm_hrs.setRotationAngle(CLOCK12 - (double)this.time_hrs * D_HOUR);
        this.arm_mins.setRotationAngle(CLOCK12 - (double)this.time_mins * D_MINUTE);
        this.arm_secs.setRotationAngle(CLOCK12 - (double)this.time_secs * D_SECOND);
        this.arm_stop_mins.setRotationAngle(CLOCK12 - (double)this.stop_mins * D_MINUTE);
        this.arm_stop_secs.setRotationAngle(CLOCK12 - (double)this.stop_secs * D_SECOND);
        this.arm_stop_tenths.setRotationAngle(CLOCK12 - (double)this.stop_tenths * D_TENTH);
        if (this.getSymbol().painter != null) {
            this.getSymbol().painter.paint(this.getSymbol(), 50);
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.setOutput(this.port_zero_mins, this.output_1);
        this.setOutput(this.port_zero_secs, this.output_1);
        this.setOutput(this.port_zero_tenths, this.output_1);
        this.show();
    }

    public StdLogic1164 getInputValue(Port p) {
        Signal signal = p.getSignal();
        if (signal == null) {
            return new StdLogic1164();
        }
        StdLogic1164 value = (StdLogic1164)signal.getValue();
        if (value == null) {
            return new StdLogic1164();
        }
        return value;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        boolean hasChanged = false;
        Port activePort = ((SimEvent)arg).getTargetPort();
        if (activePort == null) {
            this.message("-E- Internal error in " + this.toString() + ": activePort is null!");
            return;
        }
        SignalStdLogic1164 activeSignal = (SignalStdLogic1164)activePort.getSignal();
        if (!activeSignal.hasRisingEdge()) {
            return;
        }
        if (activePort == this.port_time) {
            hasChanged = true;
            ++this.time_secs;
            if (this.time_secs >= 60) {
                this.time_secs = 0;
                ++this.time_mins;
            }
            if (this.time_mins >= 60) {
                this.time_mins = 0;
                ++this.time_hrs;
            }
            if (this.time_hrs >= 12) {
                this.time_hrs = 0;
            }
        } else if (activePort == this.port_tenths) {
            hasChanged = true;
            ++this.stop_tenths;
            if (this.stop_tenths >= 10) {
                this.stop_tenths = 0;
            }
            if (this.stop_tenths == 0) {
                this.setOutput(this.port_zero_tenths, this.output_1);
            } else if (this.stop_tenths == 1) {
                this.setOutput(this.port_zero_tenths, this.output_0);
            }
        } else if (activePort == this.port_secs) {
            hasChanged = true;
            ++this.stop_secs;
            if (this.stop_secs >= 60) {
                this.stop_secs = 0;
            }
            if (this.stop_secs == 0) {
                this.setOutput(this.port_zero_secs, this.output_1);
            } else if (this.stop_secs == 1) {
                this.setOutput(this.port_zero_secs, this.output_0);
            }
        } else if (activePort == this.port_mins) {
            hasChanged = true;
            ++this.stop_mins;
            if (this.stop_mins >= 60) {
                this.stop_mins = 0;
            }
            if (this.stop_mins == 0) {
                this.setOutput(this.port_zero_mins, this.output_1);
            } else if (this.stop_mins == 1) {
                this.setOutput(this.port_zero_mins, this.output_0);
            }
        } else if (activePort == this.port_startstop) {
            this.message("-#- Swatch: event on port start/stop ignored.");
        } else if (activePort == this.port_resetpause) {
            this.message("-#- Swatch: event on port reset/pause ignored.");
        }
        if (hasChanged) {
            this.show();
        }
    }

    public void setOutput(Port p, StdLogic1164 value) {
        SimKernel simulator = this.parent.getSimulator();
        if (SimObject.debug) {
            this.message(this.toString() + ".setOutput: " + p + " " + value);
        }
        if (simulator != null && p.getSignal() != null) {
            simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)p.getSignal(), simulator.getSimTime(), value, (Object)p));
        }
    }

    public String toString() {
        return "Swatch: " + this.getFullName();
    }
}

