/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.StimuliEditor;
import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.Circle;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import jfig.objects.FigAttribs;
import jfig.utils.ExceptionTracer;

public class Stimulus
extends GenericGate
implements Wakeable {
    int n_outputs;
    int n_cycles;
    int[][] data;
    double period;
    boolean running;
    boolean debug;
    String dataResourceName;
    Circle circleOnOff;
    StdLogic1164 output_0;
    StdLogic1164 output_1;
    StdLogic1164 output_U;
    StimuliEditor stimuliEditor;

    public Stimulus() {
        block3: {
            this.n_outputs = 8;
            this.n_cycles = 256;
            this.period = 1.0;
            this.running = true;
            this.debug = false;
            this.dataResourceName = "/hades/models/io/Stimulus.hst";
            this.stimuliEditor = null;
            this.initPorts();
            this.initConstants();
            this.initData();
            if (this.debug) {
                System.out.println("-I- " + this.getDataResourceName());
            }
            if (!this.debug) break block3;
            try {
                this.parseData();
            }
            catch (Exception e) {}
        }
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.getDataResourceName()};
        return externals;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    public String getDataResourceName() {
        return this.dataResourceName;
    }

    public void setDataResourceName(String s) {
        this.dataResourceName = s;
    }

    public String getSignalName(int i) {
        if (i >= 0 && i < this.ports.length) {
            return this.ports[i].getName();
        }
        return "no such port";
    }

    public int getNumberOfOutputs() {
        return this.n_outputs;
    }

    public void setNumberOfOutputs(int N) {
        block5: {
            this.n_outputs = N;
            this.initPorts();
            this.initConstants();
            this.initData();
            if (this.debug) {
                System.out.println("-I- " + this.getDataResourceName());
            }
            if (!this.debug) break block5;
            try {
                this.writeData();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.parseData();
            }
            catch (Exception e) {}
        }
    }

    public int getNumberOfCycles() {
        return this.n_cycles;
    }

    public int[][] getData() {
        return this.data;
    }

    void initPorts() {
        this.ports = new Port[this.n_outputs];
        int i = 0;
        while (i < this.n_outputs) {
            this.ports[i] = new PortStdLogic1164(this, "Y" + i, 1, null);
            ++i;
        }
    }

    void initConstants() {
        this.output_U = Const1164.__U;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
    }

    void initDisplay() {
        this.circleOnOff = new Circle();
        this.circleOnOff.initialize("600 2700 300 300");
        this.getSymbol().addMember(this.circleOnOff);
        this.showState();
    }

    private void showState() {
        if (this.getSymbol() == null) {
            return;
        }
        FigAttribs attr = this.circleOnOff.getAttributes();
        attr.fillStyle = 2;
        attr.fillColor = this.running ? this.output_1.getColor() : this.output_0.getColor();
        this.circleOnOff.setAttributes(attr);
        if (this.circleOnOff.painter != null) {
            this.circleOnOff.painter.paint(this.circleOnOff);
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.dataResourceName));
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        String name = null;
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            name = NameMangler.decodeUnicodeEscapes(st.nextToken());
            this.setDataResourceName(name);
            this.parseData();
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            this.message(this.toString() + ".elaborate() " + arg);
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            if (this.debug) {
                this.message(this.toString() + "elaborate(): SIMULATOR IS NULL!");
            }
        } else {
            double time = this.simulator.getSimTime();
            this.simulator.scheduleWakeup(this, time + this.period, this);
            this.scheduleData();
        }
    }

    public void evaluate(Object arg) {
        System.err.println(this.toString() + ".evaluate()");
        System.err.println("\n-E- Don't call evaluate() on a ClockGen");
    }

    public void wakeup(Object arg) {
        if (this.debug) {
            System.err.println(this.toString() + ".wakeup()");
        }
        double time = this.simulator.getSimTime();
        this.simulator.scheduleWakeup(this, time + this.period, this);
        this.scheduleData();
    }

    void scheduleData() {
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        int index = this.getIndexFromTime(time);
        int i = 0;
        while (i < this.n_outputs) {
            Signal signal_Y = this.ports[i].getSignal();
            StdLogic1164 value_Y = this.getStdLogic1164(i, index);
            if (signal_Y != null) {
                super.scheduleEvent(signal_Y, time, value_Y, this.ports[i]);
            }
            ++i;
        }
    }

    public void initRow(int index, int value) {
        int[] row = this.data[index];
        int N = row.length;
        int j = 0;
        while (j < N) {
            row[j] = value;
            ++j;
        }
    }

    public void initRestOfRow(int index, int startpos, int value) {
        int[] row = this.data[index];
        int N = row.length;
        if (startpos < 0 || startpos >= N) {
            return;
        }
        int j = startpos;
        while (j < N) {
            row[j] = value;
            ++j;
        }
    }

    public void initData() {
        this.data = new int[this.n_outputs][this.n_cycles];
        int i = 0;
        while (i < this.n_outputs) {
            this.initRowWithRandomData(i);
            ++i;
        }
    }

    public void invertRow(int index) {
        int[] row = this.data[index];
        int N = row.length;
        int j = 0;
        while (j < N) {
            if (row[j] == 2) {
                row[j] = 3;
            } else if (row[j] == 3) {
                row[j] = 2;
            }
            ++j;
        }
    }

    public void expandRow(int rowindex, int startindex) {
        int M;
        int[] row = this.data[rowindex];
        int N = row.length;
        int j = M = startindex;
        while (j < N) {
            row[j] = row[j - M];
            ++j;
        }
    }

    public void initRowWithClock(int r) {
        int[] row = this.data[r];
        int N = row.length;
        int j = 0;
        while (j < N) {
            row[j] = j % 2;
            ++j;
        }
    }

    public void initRowWithRandomData(int r) {
        int[] row = this.data[r];
        int N = row.length;
        int j = 0;
        while (j < N) {
            row[j] = (int)(8.0 * Math.random());
            ++j;
        }
    }

    public void setDataAt(int r, int c, int value) {
        this.data[r][c] = value;
    }

    public int getDataAt(int r, int c) {
        return this.data[r][c];
    }

    public StdLogic1164 getStdLogic1164(int r, int c) {
        return new StdLogic1164(this.data[r][c]);
    }

    public void insertValueIntoRow(int r, int c, int value) {
        int[] row = this.data[r];
        int N = row.length;
        int j = N - 1;
        while (j > c) {
            row[j] = row[j - 1];
            --j;
        }
        row[c] = value;
    }

    public void deleteValueFromRow(int r, int c) {
        int[] row = this.data[r];
        int N = row.length;
        int j = c;
        while (j < N - 1) {
            row[j] = row[j + 1];
            ++j;
        }
        row[N - 1] = 0;
    }

    public void writeData() throws Exception {
        PrintStream PS = null;
        try {
            try {
                PS = new PrintStream(new BufferedOutputStream(DesignManager.getDesignManager().getOutputStream(this, this.dataResourceName)));
                PS.println("# HADES stimuli: " + this.dataResourceName);
                PS.println("period= " + this.period);
                PS.println("n_outputs= " + this.n_outputs);
                PS.println("n_cycles= " + this.n_cycles);
                int t = 0;
                while (t < this.n_cycles) {
                    StringBuffer sb = new StringBuffer();
                    int i = this.n_outputs - 1;
                    while (i >= 0) {
                        sb.append(StdLogic1164.chars[this.data[i][t]]);
                        --i;
                    }
                    PS.println(sb.toString());
                    ++t;
                }
                PS.println();
            }
            catch (Exception e) {
                this.message("-E- " + this.toString() + " failed to write my data!");
                this.message("-E- exception is: " + e);
                ExceptionTracer.trace(e);
                throw e;
            }
            Object var6_6 = null;
            PS.close();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            PS.close();
            throw throwable;
        }
        if (this.debug) {
            this.message("-I- wrote stimuli data to " + this.dataResourceName);
        }
    }

    String getSecondToken(BufferedReader BR) throws Exception {
        String line = BR.readLine();
        java.util.StringTokenizer lexer = new java.util.StringTokenizer(line);
        lexer.nextToken();
        return lexer.nextToken();
    }

    public void parseData() throws Exception {
        this.message("-I- reading stimuli data '" + this.dataResourceName + "'");
        BufferedReader BR = null;
        String line = null;
        try {
            try {
                BR = new BufferedReader(new InputStreamReader(DesignManager.getDesignManager().getInputStream(this, this.dataResourceName)));
                line = BR.readLine();
                this.period = Double.valueOf(this.getSecondToken(BR));
                this.n_outputs = Integer.parseInt(this.getSecondToken(BR));
                this.n_cycles = Integer.parseInt(this.getSecondToken(BR));
                StdLogic1164 value1164 = new StdLogic1164();
                this.data = new int[this.n_outputs][this.n_cycles];
                int t = 0;
                while (t < this.n_cycles) {
                    line = BR.readLine();
                    int i = this.n_outputs - 1;
                    int j = 0;
                    while (i >= 0) {
                        value1164.setValue(line.charAt(j));
                        this.data[i][t] = value1164.intValue();
                        --i;
                        ++j;
                    }
                    ++t;
                }
            }
            catch (Exception e) {
                this.message("-E- " + this.toString() + " failed to parse data: ");
                this.message("-E- exception is: " + e);
                ExceptionTracer.trace(e);
                throw e;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
        this.message("-I- stimuli stats: n_outputs= " + this.n_outputs + " n_cycles= " + this.n_cycles + " period= " + this.period);
    }

    public void changeLength(int n_cycles) {
        int[][] newdata = new int[this.n_outputs][];
        int i = 0;
        while (i < this.n_outputs) {
            newdata[i] = new int[n_cycles];
            int j = 0;
            while (j < n_cycles) {
                newdata[i][j] = j < this.data[i].length ? this.data[i][j] : 0;
                ++j;
            }
            ++i;
        }
        this.data = newdata;
        this.n_cycles = n_cycles;
    }

    public void setPeriod(double period) {
        this.period = period;
    }

    public double getPeriod() {
        return this.period;
    }

    public int getIndexFromTime(double time) {
        int i = (int)(time / this.period);
        int N = this.data[0].length;
        if (i < 0) {
            return 0;
        }
        if (i >= N) {
            return N - 1;
        }
        return i;
    }

    public SimObject copy() {
        Stimulus tmp = null;
        try {
            tmp = (Stimulus)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.initialize("" + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.dataResourceName));
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in " + this.toString() + ".copy(): " + e);
            return null;
        }
    }

    public Component getPropertySheet() {
        return this.stimuliEditor;
    }

    public void configure() {
        if (this.stimuliEditor == null) {
            this.stimuliEditor = new StimuliEditor(this);
            this.stimuliEditor.pack();
        }
        this.stimuliEditor.setVisible(true);
    }

    public String toString() {
        return "Stimulus: " + this.getFullName();
    }
}

