/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.Circle;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;

public class Iso8859Display
extends SimObject {
    private Circle[][] dot = new Circle[5][7];
    private byte[][] iso8859_1 = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 0, 4, 0}, {10, 10, 5, 0, 0, 0, 0, 0}, {0, 10, 31, 10, 31, 10, 0, 0}, {4, 30, 5, 14, 20, 15, 4, 0}, {0, 18, 8, 4, 2, 9, 0, 0}, {6, 9, 6, 5, 25, 9, 22, 0}, {4, 4, 2, 0, 0, 0, 0, 0}, {16, 8, 4, 4, 4, 8, 16, 0}, {1, 2, 4, 4, 4, 2, 1, 0}, {0, 17, 10, 31, 10, 17, 0, 0}, {0, 0, 4, 14, 4, 0, 0, 0}, {0, 0, 0, 0, 4, 4, 2, 0}, {0, 0, 0, 14, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 4, 0}, {0, 16, 8, 4, 2, 1, 0, 0}, {14, 17, 25, 21, 19, 17, 14, 0}, {4, 6, 4, 4, 4, 4, 14, 0}, {14, 17, 16, 8, 4, 2, 31, 0}, {14, 17, 16, 12, 16, 17, 14, 0}, {8, 12, 10, 9, 31, 8, 8, 0}, {31, 1, 15, 16, 16, 17, 14, 0}, {14, 17, 1, 15, 17, 17, 14, 0}, {31, 17, 8, 8, 4, 4, 4, 0}, {14, 17, 17, 14, 17, 17, 14, 0}, {14, 17, 17, 30, 16, 17, 14, 0}, {0, 0, 4, 0, 0, 4, 0, 0}, {0, 0, 0, 4, 0, 4, 4, 2}, {0, 8, 4, 2, 4, 8, 0, 0}, {0, 0, 14, 0, 14, 0, 0, 0}, {0, 2, 4, 8, 4, 2, 0, 0}, {14, 17, 16, 8, 4, 0, 4, 0}, {14, 17, 29, 29, 1, 17, 14, 0}, {14, 17, 17, 31, 17, 17, 17, 0}, {15, 17, 17, 15, 17, 17, 15, 0}, {14, 17, 1, 1, 1, 17, 14, 0}, {15, 17, 17, 17, 17, 17, 15, 0}, {31, 1, 1, 7, 1, 1, 31, 0}, {31, 1, 1, 7, 1, 1, 1, 0}, {30, 1, 1, 29, 17, 17, 30, 0}, {17, 17, 17, 31, 17, 17, 17, 0}, {4, 4, 4, 4, 4, 4, 4, 0}, {8, 8, 8, 8, 9, 9, 6, 0}, {17, 9, 5, 3, 5, 9, 17, 0}, {1, 1, 1, 1, 1, 1, 31, 0}, {17, 27, 31, 21, 17, 17, 17, 0}, {17, 19, 19, 21, 25, 25, 17, 0}, {14, 17, 17, 17, 17, 17, 14, 0}, {15, 17, 17, 15, 1, 1, 1, 0}, {14, 17, 17, 17, 21, 25, 22, 0}, {15, 17, 17, 15, 5, 9, 17, 0}, {14, 17, 1, 14, 16, 17, 14, 0}, {31, 4, 4, 4, 4, 4, 4, 0}, {17, 17, 17, 17, 17, 17, 14, 0}, {17, 17, 17, 17, 17, 10, 4, 0}, {17, 17, 17, 21, 21, 21, 10, 0}, {17, 17, 10, 4, 10, 17, 17, 0}, {17, 17, 17, 10, 4, 4, 4, 0}, {31, 16, 8, 4, 2, 1, 31, 0}, {12, 4, 4, 4, 4, 4, 12, 0}, {0, 1, 2, 4, 8, 16, 0, 0}, {6, 4, 4, 4, 4, 4, 6, 0}, {4, 10, 17, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 31, 0}, {4, 4, 8, 0, 0, 0, 0, 0}, {0, 0, 14, 16, 14, 17, 30, 0}, {1, 1, 15, 17, 17, 17, 15, 0}, {0, 0, 14, 17, 1, 17, 14, 0}, {16, 16, 30, 17, 17, 17, 30, 0}, {0, 0, 14, 17, 31, 1, 14, 0}, {24, 4, 14, 4, 4, 4, 4, 0}, {0, 0, 30, 17, 30, 16, 14, 0}, {1, 1, 15, 17, 17, 17, 17, 0}, {4, 0, 4, 4, 4, 4, 4, 0}, {4, 0, 4, 4, 4, 5, 2, 0}, {1, 1, 9, 7, 5, 9, 17, 0}, {4, 4, 4, 4, 4, 4, 8, 0}, {0, 0, 11, 21, 21, 21, 21, 0}, {0, 0, 15, 17, 17, 17, 17, 0}, {0, 0, 14, 17, 17, 17, 14, 0}, {0, 0, 15, 17, 17, 15, 1, 0}, {0, 0, 30, 17, 17, 30, 16, 0}, {0, 0, 15, 17, 1, 1, 1, 0}, {0, 0, 30, 1, 14, 16, 15, 0}, {4, 4, 14, 4, 4, 4, 8, 0}, {0, 0, 17, 17, 17, 17, 30, 0}, {0, 0, 17, 17, 17, 10, 4, 0}, {0, 0, 17, 17, 21, 21, 10, 0}, {0, 0, 17, 10, 4, 10, 17, 0}, {0, 0, 17, 17, 10, 4, 3, 0}, {0, 0, 31, 8, 4, 2, 31, 0}, {8, 4, 4, 2, 4, 4, 8, 0}, {4, 4, 4, 4, 4, 4, 4, 0}, {4, 8, 8, 16, 8, 8, 4, 0}, {10, 5, 0, 0, 0, 0, 0, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {28, 2, 15, 2, 15, 2, 28, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {0, 0, 0, 0, 4, 4, 2, 0}, {24, 4, 14, 4, 4, 4, 3, 0}, {0, 0, 0, 0, 10, 10, 5, 0}, {0, 0, 0, 0, 0, 21, 21, 0}, {4, 4, 31, 4, 4, 4, 4, 0}, {4, 4, 31, 4, 31, 4, 4, 0}, {4, 10, 17, 0, 0, 0, 0, 0}, {0, 18, 8, 4, 2, 21, 0, 0}, {10, 14, 17, 14, 16, 17, 14, 0}, {0, 8, 4, 2, 4, 8, 0, 0}, {30, 9, 9, 25, 9, 9, 30, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {8, 4, 4, 0, 0, 0, 0, 0}, {4, 4, 2, 0, 0, 0, 0, 0}, {20, 10, 10, 0, 0, 0, 0, 0}, {10, 10, 5, 0, 0, 0, 0, 0}, {0, 0, 14, 14, 14, 0, 0, 0}, {0, 0, 0, 14, 0, 0, 0, 0}, {0, 0, 0, 31, 0, 0, 0, 0}, {0, 0, 0, 22, 13, 0, 0, 0}, {23, 29, 21, 21, 0, 0, 0, 0}, {0, 10, 30, 1, 14, 16, 15, 0}, {0, 6, 12, 24, 12, 6, 0, 0}, {0, 0, 14, 21, 13, 5, 30, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {31, 17, 17, 17, 17, 17, 31, 0}, {10, 0, 17, 17, 10, 4, 4, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {4, 0, 4, 4, 4, 4, 4, 0}, {0, 4, 30, 1, 1, 30, 4, 0}, {12, 18, 2, 15, 2, 2, 31, 0}, {0, 27, 14, 10, 14, 27, 0, 0}, {17, 17, 10, 4, 31, 4, 4, 0}, {4, 4, 4, 0, 4, 4, 4, 0}, {12, 2, 12, 10, 6, 8, 6, 0}, {10, 10, 5, 0, 0, 0, 0, 0}, {14, 17, 29, 19, 29, 17, 14, 0}, {6, 8, 14, 9, 22, 0, 31, 0}, {0, 20, 10, 5, 10, 20, 0, 0}, {0, 0, 0, 31, 24, 0, 0, 0}, {0, 0, 0, 31, 0, 0, 0, 0}, {14, 17, 31, 19, 27, 17, 14, 0}, {31, 0, 0, 0, 0, 0, 0, 0}, {12, 18, 18, 12, 0, 0, 0, 0}, {0, 4, 14, 4, 0, 14, 0, 0}, {4, 10, 8, 4, 14, 0, 0, 0}, {6, 8, 4, 8, 6, 0, 0, 0}, {4, 4, 2, 0, 0, 0, 0, 0}, {0, 9, 9, 9, 9, 7, 1, 0}, {30, 21, 21, 22, 20, 20, 20, 0}, {0, 0, 0, 4, 0, 0, 0, 0}, {0, 0, 0, 0, 4, 4, 2, 0}, {4, 6, 4, 4, 14, 0, 0, 0}, {14, 17, 17, 17, 14, 0, 31, 0}, {0, 5, 10, 20, 10, 5, 0, 0}, {2, 19, 10, 4, 22, 29, 16, 0}, {2, 19, 10, 28, 18, 9, 24, 0}, {3, 18, 11, 6, 23, 29, 16, 0}, {4, 0, 4, 2, 1, 17, 14, 0}, {2, 4, 14, 17, 31, 17, 17, 0}, {8, 4, 14, 17, 31, 17, 17, 0}, {4, 10, 14, 17, 31, 17, 17, 0}, {20, 10, 14, 17, 31, 17, 17, 0}, {17, 0, 14, 17, 31, 17, 17, 0}, {14, 17, 14, 17, 31, 17, 17, 0}, {30, 5, 5, 15, 5, 5, 29, 0}, {14, 17, 1, 1, 17, 14, 4, 0}, {2, 4, 31, 1, 7, 1, 31, 0}, {8, 4, 31, 1, 7, 1, 31, 0}, {4, 10, 31, 1, 7, 1, 31, 0}, {17, 0, 31, 1, 7, 1, 31, 0}, {2, 4, 4, 4, 4, 4, 4, 0}, {8, 4, 4, 4, 4, 4, 4, 0}, {4, 10, 4, 4, 4, 4, 4, 0}, {10, 0, 4, 4, 4, 4, 4, 0}, {14, 18, 18, 23, 18, 18, 14, 0}, {20, 10, 17, 19, 21, 25, 17, 0}, {2, 4, 14, 17, 17, 17, 14, 0}, {8, 4, 14, 17, 17, 17, 14, 0}, {4, 10, 14, 17, 17, 17, 14, 0}, {20, 10, 14, 17, 17, 17, 14, 0}, {17, 0, 14, 17, 17, 17, 14, 0}, {0, 0, 10, 4, 10, 0, 0, 0}, {30, 25, 21, 21, 21, 19, 15, 0}, {2, 4, 17, 17, 17, 17, 14, 0}, {8, 4, 17, 17, 17, 17, 14, 0}, {4, 10, 17, 17, 17, 17, 14, 0}, {17, 0, 17, 17, 17, 17, 14, 0}, {8, 4, 17, 17, 10, 4, 4, 0}, {1, 1, 15, 17, 17, 15, 1, 0}, {15, 17, 17, 13, 17, 17, 13, 0}, {2, 4, 14, 16, 14, 17, 30, 0}, {8, 4, 14, 16, 14, 17, 30, 0}, {4, 10, 14, 16, 14, 17, 30, 0}, {20, 10, 14, 16, 14, 17, 30, 0}, {10, 0, 14, 16, 14, 17, 30, 0}, {14, 17, 14, 16, 14, 17, 30, 0}, {0, 0, 15, 20, 14, 5, 31, 0}, {0, 14, 17, 1, 17, 14, 4, 0}, {2, 4, 14, 17, 31, 1, 14, 0}, {8, 4, 14, 17, 31, 1, 14, 0}, {4, 10, 14, 17, 31, 1, 14, 0}, {10, 0, 14, 17, 31, 1, 14, 0}, {2, 4, 0, 4, 4, 4, 4, 0}, {8, 4, 0, 4, 4, 4, 4, 0}, {4, 10, 0, 4, 4, 4, 4, 0}, {10, 0, 0, 4, 4, 4, 4, 0}, {10, 4, 10, 30, 17, 17, 30, 0}, {20, 10, 0, 15, 17, 17, 17, 0}, {2, 4, 0, 14, 17, 17, 14, 0}, {8, 4, 0, 14, 17, 17, 14, 0}, {4, 10, 0, 14, 17, 17, 14, 0}, {20, 10, 0, 14, 17, 17, 14, 0}, {0, 10, 0, 14, 17, 17, 14, 0}, {0, 4, 0, 31, 0, 4, 0, 0}, {0, 0, 30, 25, 21, 19, 15, 0}, {2, 4, 0, 17, 17, 17, 30, 0}, {8, 4, 0, 17, 17, 17, 30, 0}, {4, 10, 0, 17, 17, 17, 30, 0}, {0, 10, 0, 17, 17, 17, 30, 0}, {8, 4, 17, 17, 10, 4, 3, 0}, {0, 1, 7, 9, 9, 7, 1, 0}, {10, 0, 17, 17, 10, 4, 3, 0}};
    int index;
    public static final int DEFAULT = 32;
    protected FigCompound display;
    protected Color dark_gray;
    protected Color medium_gray;
    protected StdLogic1164 undefined;

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        this.display = new FigCompound();
        this.display.setTrafo(this.symbol.getTrafo());
        this.dark_gray = new Color(100, 100, 100);
        this.medium_gray = new Color(110, 110, 110);
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 7) {
                this.dot[i][j] = new Circle();
                this.dot[i][j].initialize("" + (1500 - 450 * (i - 2)) + " " + (2100 - 450 * (j - 3)) + " 150 150");
                FigAttribs attr = this.dot[i][j].getAttributes();
                attr.fillStyle = 2;
                attr.currentLayer = 5;
                attr.lineWidth = 150.0;
                this.display.fastAddMember(this.dot[i][j]);
                ++j;
            }
            ++i;
        }
        Rectangle r = new Rectangle();
        r.initialize("300 450 2700 3750");
        FigAttribs ra = r.getAttributes();
        ra.fillStyle = 2;
        ra.fillColor = this.dark_gray;
        ra.fig_fill_color = 0;
        ra.fig_area_fill = 20;
        ra.currentLayer = 50;
        r.setAttributes(ra);
        this.display.fastAddMember(r);
        this.display.update_bbox();
        Symbol symbol = this.getSymbol();
        this.display.setObjectPainter(symbol.painter);
        symbol.addMember(this.display);
    }

    private void show() {
        if (this.symbol == null) {
            return;
        }
        this.index = 0;
        int i = 0;
        while (i < this.ports.length) {
            this.index <<= 1;
            Signal signal = this.ports[i].getSignal();
            if (signal != null) {
                StdLogic1164 tmp = (StdLogic1164)((SignalStdLogic1164)signal).getValue();
                if (tmp.intValue() == 3 || tmp.intValue() == 7) {
                    ++this.index;
                } else if (tmp.intValue() != 2 && tmp.intValue() != 6) {
                    this.index = 0;
                    break;
                }
            } else {
                this.index = 0;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 5) {
            int j = 0;
            while (j < 7) {
                int cindex = this.iso8859_1[this.index][6 - j] >> 4 - i2 & 1;
                Color color = cindex == 0 ? this.medium_gray : Color.red;
                FigAttribs attr = this.dot[i2][j].getAttributes();
                attr.lineColor = color;
                attr.fillColor = color;
                if (cindex == 0) {
                    attr.fig_line_color = 0;
                    attr.fig_fill_color = 0;
                    attr.fig_area_fill = 10;
                } else {
                    attr.fig_line_color = 4;
                    attr.fig_fill_color = 4;
                    attr.fig_area_fill = 20;
                }
                this.dot[i2][j].setAttributes(attr);
                ++j;
            }
            ++i2;
        }
        if (this.getSymbol().painter != null) {
            this.getSymbol().painter.paint(this.display, 100);
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.show();
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.show();
    }

    public String toString() {
        return "Iso8859Display: " + this.getFullName() + " [value=" + this.index + "]";
    }

    public Iso8859Display() {
        this.name = "Iso8859-1_Display";
        this.ports = new Port[8];
        this.ports[0] = new Port(this, "D7", 0, null);
        this.ports[1] = new Port(this, "D6", 0, null);
        this.ports[2] = new Port(this, "D5", 0, null);
        this.ports[3] = new Port(this, "D4", 0, null);
        this.ports[4] = new Port(this, "D3", 0, null);
        this.ports[5] = new Port(this, "D2", 0, null);
        this.ports[6] = new Port(this, "D1", 0, null);
        this.ports[7] = new Port(this, "D0", 0, null);
        this.undefined = new StdLogic1164();
    }
}

