/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.Const1164;
import hades.models.io.Ipin;
import hades.signals.Signal;
import hades.simulator.SimEvent1164;
import hades.simulator.Simulatable;
import hades.symbols.Symbol;
import java.awt.Point;
import java.awt.event.MouseEvent;
import jfig.canvas.FigCanvasEvent;

public class IpinStdLogic1164
extends Ipin {
    private Const1164[] _values = new Const1164[]{Const1164.__U, Const1164.__X, Const1164.__0, Const1164.__1, Const1164.__Z, Const1164.__L, Const1164.__H, Const1164.__W, Const1164.__D};

    public void setStartState() {
        switch (this.startValue.intValue()) {
            case 0: {
                this.state = 3;
                break;
            }
            case 2: {
                this.state = 0;
                break;
            }
            case 3: {
                this.state = 1;
                break;
            }
            case 4: {
                this.state = 2;
                break;
            }
            default: {
                this.state = 3;
            }
        }
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
    }

    public void mousePressed(MouseEvent me) {
        this.state = me.isShiftDown() ? (this.state + 1) % 9 : this.findStateFromMouseclick(me);
        this.showState();
        this.schedule(this.state, 5.0E-9, true);
    }

    public int findStateFromMouseclick(MouseEvent me) {
        int state = this.state;
        try {
            Symbol symbol = this.getSymbol();
            Point pos = symbol.getPos();
            Point mousepos = ((FigCanvasEvent)me).getWorldCoordinatePoint();
            int FIELD_SIZE = 600;
            int OFFSET = 300;
            int index_x = (mousepos.x - pos.x - OFFSET) / FIELD_SIZE;
            int index_y = (mousepos.y - pos.y - OFFSET) / FIELD_SIZE;
            if (index_x < 0) {
                index_x = 0;
            }
            if (index_x > 3) {
                index_x = 3;
            }
            if (index_y < 0) {
                index_y = 0;
            }
            if (index_y > 2) {
                index_y = 2;
            }
            int index = 4 * index_y + index_x;
            switch (index) {
                case 0: {
                    state = 0;
                    break;
                }
                case 1: {
                    state = 1;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (state == 2) {
                        state = 3;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 4: {
                    state = 2;
                    break;
                }
                case 5: {
                    state = 3;
                    break;
                }
                case 6: {
                    state = 4;
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    state = 5;
                    break;
                }
                case 9: {
                    state = 6;
                    break;
                }
                case 10: {
                    state = 7;
                    break;
                }
                case 11: {
                    state = 8;
                    break;
                }
            }
        }
        catch (Exception e) {
            state = 0;
        }
        return state;
    }

    public void schedule(int state, double delay, boolean interactive) {
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        Const1164 output = this._values[state];
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime() + delay;
        SimEvent1164 se = SimEvent1164.createNewSimEvent((Simulatable)signal_Y, time, output, (Object)this.port_Y);
        if (interactive) {
            this.simulator.scheduleInteractiveEvent(se);
        } else {
            this.simulator.scheduleEvent(se);
        }
    }

    public String toString() {
        return "IpinStdLogic1164: " + this.getFullName();
    }
}

