/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class SelectRegionFilter
extends ParametrizedFilter {
    public Image filter(Image image) {
        if (image == null) {
            return null;
        }
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(image);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        int x = this.getP0();
        int y = this.getP1();
        int ww = this.getP2();
        int hh = this.getP3();
        BufferedImage BO = new BufferedImage(w, h, 1);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                boolean b = i >= x && j >= y && i <= x + ww && j <= y + hh;
                BO.setRGB(i, j, b ? -1 : -16777216);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- SelectRegionFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "x", "p0", "y", "p1", "w", "p2", "h", "p3"};
    }
}

