/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.TwoInputFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class S40StripeReductionFilter
extends TwoInputFilter {
    public S40StripeReductionFilter() {
        this.setP0(8);
        this.setP1(2);
        this.setP2(1);
    }

    public Image filter(Image image_A, Image image_B) {
        long t1 = System.currentTimeMillis();
        BufferedImage A = this.getBufferedImage(image_A);
        BufferedImage M = this.getBufferedImage(image_B);
        if (A == null || M == null) {
            return null;
        }
        int w = Math.min(A.getWidth(null), M.getWidth(null));
        int h = Math.min(A.getHeight(null), M.getHeight(null));
        BufferedImage R = new BufferedImage(w, h, 1);
        int dy = this._clip(0, h, this.getP0());
        int rx = this._clip(0, w, this.getP1());
        int ry = this._clip(0, h, this.getP2());
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int pixa = A.getRGB(i, j);
                int mask = M.getRGB(i, j) & 0xFFFFFF;
                if (mask != 0xFFFFFF) {
                    R.setRGB(i, j, pixa);
                } else {
                    int jj = (int)((double)ry * Math.random());
                    int ii = (int)((double)rx * Math.random());
                    int j2 = j - dy + jj;
                    int i2 = i + ii;
                    if (j2 < 0 || j2 >= h) {
                        R.setRGB(i, j, pixa);
                    } else if (i2 < 0 || i2 >= w) {
                        R.setRGB(i, j, pixa);
                    } else if ((M.getRGB(i2, j2) & 0xFFFFFF) != 0xFFFFFF) {
                        R.setRGB(i, j, pixa);
                    } else {
                        int pixb = A.getRGB(i, j2);
                        int r = (pixa & 0xFF0000) + (pixb & 0xFF0000) >> 1;
                        int g = (pixa & 0xFF00) + (pixb & 0xFF00) >> 1;
                        int b = (pixa & 0xFF) + (pixb & 0xFF) >> 1;
                        int pixr = r & 0xFF0000 | g & 0xFF00 | b & 0xFF | 0xFF000000;
                        R.setRGB(i, j, pixr);
                    }
                }
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- S40StripeReductionFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return R;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "y-offset x0    [0..32]:", "p0", "random x-offset [0..5]:", "p1", "random y-offset [0..5]:", "p2"};
    }
}

