/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class RotationFilter
extends ParametrizedFilter {
    public RotationFilter() {
        this.setD0(45.0);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        if (inputImage == null) {
            return null;
        }
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        double degrees = this.getD0();
        double theta = degrees * Math.PI / 180.0;
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double x0 = 0.0 * cos - 0.0 * sin;
        double x1 = (double)w * cos - 0.0 * sin;
        double x2 = 0.0 * cos - (double)h * sin;
        double x3 = (double)w * cos - (double)h * sin;
        double y0 = 0.0 * sin + 0.0 * cos;
        double y1 = (double)w * sin + 0.0 * cos;
        double y2 = 0.0 * sin + (double)h * cos;
        double y3 = (double)w * sin + (double)h * cos;
        double dx = Math.min(Math.min(x0, x1), Math.min(x2, x3));
        double dy = Math.min(Math.min(y0, y1), Math.min(y2, y3));
        AffineTransform trafo = AffineTransform.getRotateInstance(theta, 0.0, 0.0);
        trafo.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        AffineTransformOp atop = new AffineTransformOp(trafo, 2);
        BufferedImage BO = atop.filter(BI, null);
        long t2 = System.currentTimeMillis();
        this.msg("-#- RotationFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "angle: [degrees]", "d0"};
    }
}

