/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.TwoInputFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ReplaceRegionFilter
extends TwoInputFilter {
    public ReplaceRegionFilter() {
        this.setP0(0);
        this.setP1(0);
    }

    public Image filter(Image image_A, Image image_B) {
        long t1 = System.currentTimeMillis();
        BufferedImage R = this.getClone(image_A);
        BufferedImage B = this.getBufferedImage(image_B);
        if (R == null || B == null) {
            return null;
        }
        int w = R.getWidth(null);
        int h = R.getHeight(null);
        int x = this._clip(0, w, this.getP0());
        int y = this._clip(0, h, this.getP1());
        int wb = this._clip(0, w - x, B.getWidth(null));
        int hb = this._clip(0, h - y, B.getHeight(null));
        int i = 0;
        while (i < wb) {
            int j = 0;
            while (j < hb) {
                int pixb = B.getRGB(i, j);
                R.setRGB(x + i, y + j, pixb);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- ReplaceRegionFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return R;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "x", "p0", "y", "p1"};
    }
}

