/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class PerspectiveTransformationFilter
extends ParametrizedFilter {
    public PerspectiveTransformationFilter() {
        this.setD0(1.0);
        this.setD1(0.0);
        this.setD2(0.0);
        this.setD3(0.0);
        this.setD4(1.0);
        this.setD5(0.0);
        this.setD6(0.0);
        this.setD7(0.0);
        this.setD8(1.0);
    }

    public Image filter(Image inputImage) {
        System.err.println("-W- PerscpectiveTransformationFilter is BROKEN!");
        long t1 = System.currentTimeMillis();
        if (inputImage == null) {
            return null;
        }
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        double m00 = this.getD0();
        double m01 = this.getD1();
        double m02 = this.getD2();
        double m10 = this.getD3();
        double m11 = this.getD4();
        double m12 = this.getD5();
        double m20 = this.getD6();
        double m21 = this.getD7();
        double m22 = this.getD8();
        PT trafo = new PT(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        double[] src = new double[]{0.0, 0.0, 0.0, w, h, 0.0, h, w};
        double[] dst = new double[]{0.0, 0.0, 0.0, w, h, 0.0, h, w};
        trafo.transform(src, 0, dst, 0, 4);
        double dx = Math.min(Math.min(dst[0], dst[2]), Math.min(dst[4], dst[6]));
        double dy = Math.min(Math.min(dst[1], dst[3]), Math.min(dst[5], dst[7]));
        double xx = Math.max(Math.max(dst[0], dst[2]), Math.max(dst[4], dst[6]));
        double yy = Math.max(Math.max(dst[1], dst[3]), Math.max(dst[5], dst[7]));
        int ww = (int)Math.round(xx - dx);
        int hh = (int)Math.round(yy - dy);
        System.out.println("*** " + dx + " " + dy + " " + xx + " " + yy);
        double[] tmp = new double[2];
        BufferedImage BO = new BufferedImage(ww, hh, 1);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int rgb = BI.getRGB(i, j) & 0xFFFFFF;
                trafo.transform(i, j, tmp);
                int px = (int)((double)Math.round(tmp[0]) - dx);
                int py2 = (int)((double)Math.round(tmp[1]) - dy);
                try {
                    BO.setRGB(px, py2, rgb);
                }
                catch (Exception e) {
                    System.err.println("-E- src=" + i + "x" + j + " dst=" + px + "x" + py2 + "  rgb=" + rgb);
                }
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- PerspectiveTransformationFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "m00", "d0", "m01", "d1", "m02", "d2", "m10", "d3", "m11", "d4", "m12", "d5", "m20", "d6", "m21", "d7", "m22", "d8"};
    }

    class PT {
        double m00;
        double m01;
        double m02;
        double m10;
        double m11;
        double m12;
        double m20;
        double m21;
        double m22;

        public PT(double _m00, double _m01, double _m02, double _m10, double _m11, double _m12, double _m20, double _m21, double _m22) {
            this.m00 = _m00;
            this.m01 = _m01;
            this.m02 = _m02;
            this.m10 = _m10;
            this.m11 = _m11;
            this.m12 = _m12;
            this.m20 = _m20;
            this.m21 = _m21;
            this.m22 = _m22;
        }

        public double[] transform(double x, double y, double[] tmp) {
            double xx = this.m00 * x + this.m01 * y + this.m02;
            double yy = this.m10 * x + this.m11 * y + this.m12;
            double w = this.m20 * x + this.m21 * y + this.m22;
            tmp[0] = xx / w;
            tmp[1] = yy / w;
            return tmp;
        }

        public double[] transform(double[] src, int src_offset, double[] dst, int dst_offset, int npoints) {
            int i = 0;
            while (i < 2 * npoints) {
                double x = src[src_offset + i];
                double y = src[src_offset + i + 1];
                double xx = this.m00 * x + this.m01 * y + this.m02;
                double yy = this.m10 * x + this.m11 * y + this.m12;
                double w = this.m20 * x + this.m21 * y + this.m22;
                dst[dst_offset + i] = xx / w;
                dst[dst_offset + i + 1] = yy / w;
                i += 2;
            }
            return dst;
        }
    }
}

