/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.TwoInputFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class MultFilter
extends TwoInputFilter {
    public Image filter(Image image_A, Image image_B) {
        long t1 = System.currentTimeMillis();
        BufferedImage A = this.getBufferedImage(image_A);
        BufferedImage B = this.getBufferedImage(image_B);
        if (A == null || B == null) {
            return null;
        }
        int w = Math.min(A.getWidth(null), B.getWidth(null));
        int h = Math.min(A.getHeight(null), B.getHeight(null));
        BufferedImage R = new BufferedImage(w, h, 1);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int pixa = A.getRGB(i, j);
                int pixb = B.getRGB(i, j);
                int ra = (pixa & 0xFF0000) >>> 16;
                int rb = (pixb & 0xFF0000) >>> 16;
                int ga = (pixa & 0xFF00) >>> 8;
                int gb = (pixb & 0xFF00) >>> 8;
                int ba = pixa & 0xFF;
                int bb = pixb & 0xFF;
                int r = ra * rb >>> 8;
                int g = ga * gb >>> 8;
                int b = ba * bb >>> 8;
                int pixr = 0xFF000000 | r << 16 | g << 8 | b;
                R.setRGB(i, j, pixr);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- MultFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return R;
    }
}

