/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.SimpleFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class MirrorYFilter
extends SimpleFilter {
    public Image filter(Image inputImage) {
        BufferedImage BI = SimpleFilter.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        BufferedImage BO = new BufferedImage(w, h, 2);
        long t1 = System.currentTimeMillis();
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int rgb = BI.getRGB(x, y);
                BO.setRGB(x, h - y - 1, rgb);
                ++x;
            }
            ++y;
        }
        long t2 = System.currentTimeMillis();
        SimpleFilter.msg("-#- MirrorYFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }
}

