/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;

public class LookupFilter
extends ParametrizedFilter {
    public LookupTable getLookupTable() {
        byte[] data = new byte[256];
        int i = 0;
        while (i < 256) {
            data[i] = (byte)i;
            ++i;
        }
        return new ByteLookupTable(0, data);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        LookupTable lookup = this.getLookupTable();
        LookupOp lop = new LookupOp(lookup, null);
        BufferedImage BO = lop.filter(BI, null);
        long t2 = System.currentTimeMillis();
        this.msg("-#- LookupFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }
}

