/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class GammaFilter
extends ParametrizedFilter {
    private int[] _lookup_table;

    public GammaFilter() {
        this.setD0(2.5);
        this.setD1(10.0);
        this.setD2(0.9);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        BufferedImage BO = new BufferedImage(w, h, 2);
        this.build_lookup_table();
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int rgb = BI.getRGB(x, y);
                int alpha = rgb & 0xFF000000;
                int red = (rgb & 0xFF0000) >>> 16;
                int green = (rgb & 0xFF00) >>> 8;
                int blue = rgb & 0xFF;
                red = this.gamma(red);
                green = this.gamma(green);
                blue = this.gamma(blue);
                int result = alpha | red << 16 | green << 8 | blue;
                BO.setRGB(x, y, result);
                ++x;
            }
            ++y;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- GammaFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    /*
     * Unable to fully structure code
     */
    private void build_lookup_table() {
        block4: {
            this._lookup_table = new int[256];
            try {
                gamma = this.getD0();
                offset = this.getD1();
                contrast = this.getD2();
                i = 0;
                while (i < 256) {
                    tmp = contrast * Math.pow(((double)i - offset) / 256.0, gamma);
                    pix = (int)Math.round(tmp * 256.0);
                    this._lookup_table[i] = this._clip(0, 255, pix);
                    ++i;
                }
                break block4;
            }
            catch (Exception e) {
                e.printStackTrace();
                i = 0;
                ** while (i < 256)
            }
lbl-1000:
            // 1 sources

            {
                this._lookup_table[i] = i;
                ++i;
                continue;
            }
        }
    }

    private final int gamma(int pixel) {
        return this._lookup_table[pixel & 0xFF];
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "gamma g:", "d0", "offset b:", "d1", "contrast k:", "d2"};
    }
}

