/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.TwoInputFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class EqualsWithinFilter
extends TwoInputFilter {
    private int limit = 100;

    public Image filter(Image image_A, Image image_B) {
        long t1 = System.currentTimeMillis();
        BufferedImage A = this.getBufferedImage(image_A);
        BufferedImage B = this.getBufferedImage(image_B);
        if (A == null || B == null) {
            return null;
        }
        int w = Math.min(A.getWidth(null), B.getWidth(null));
        int h = Math.min(A.getHeight(null), B.getHeight(null));
        BufferedImage R = new BufferedImage(w, h, 1);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int db;
                int dg;
                int pixb;
                int pixa = A.getRGB(i, j);
                int dr = Math.abs((pixa & 0xFF0000) - ((pixb = B.getRGB(i, j)) & 0xFF0000)) >>> 16;
                int err = dr + (dg = Math.abs((pixa & 0xFF00) - (pixb & 0xFF00)) >> 8) + (db = Math.abs((pixa & 0xFF) - (pixb & 0xFF)));
                if (err == 0) {
                    R.setRGB(i, j, -1);
                } else if (err < this.limit) {
                    R.setRGB(i, j, -4210753);
                } else if (err < 2 * this.limit) {
                    R.setRGB(i, j, -8421505);
                } else if (err < 3 * this.limit) {
                    R.setRGB(i, j, -12632257);
                } else {
                    R.setRGB(i, j, -16777216);
                }
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- EqualsWithinFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return R;
    }
}

