/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.SimpleFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class ConvolutionFilter
extends SimpleFilter {
    public float[] getKernelCoeffs() {
        float a = 0.11111111f;
        float[] coeffs = new float[]{a, a, a, a, a, a, a, a, a};
        return coeffs;
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BI = SimpleFilter.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        float[] coeffs = this.getKernelCoeffs();
        int size = (int)Math.sqrt(coeffs.length);
        Kernel kernel = new Kernel(size, size, coeffs);
        ConvolveOp cop = new ConvolveOp(kernel, 0, null);
        BufferedImage BO = cop.filter(BI, null);
        long t2 = System.currentTimeMillis();
        SimpleFilter.msg("-#- ConvolutionFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }
}

