/*
 * Decompiled with CFR 0.152.
 */
package hades.models.i8048;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class I8048GUI {
    public int debugLevel = 1;
    public static final int UNDEFINED = -1;
    protected TextField accu_TF;
    protected TextField psw_TF;
    protected TextField pc_TF;
    protected TextField ireg_TF;
    protected TextField stackpointer_TF;
    protected TextField port1_TF;
    protected TextField port2_TF;
    protected TextField addressReg_TF;
    protected TextField tmp_alu1_TF;
    protected TextField tmp_alu2_TF;
    protected TextField tmp_mar_TF;
    protected TextField tmp_dec_TF;
    protected TextField timer_TF;
    protected TextField prescaler_TF;
    protected TextField currentCycle_TF;
    protected Frame frame;
    protected Panel registerPanel;
    protected Panel buttonPanel;
    protected Panel infoPanel;

    private void createTextFields() {
        this.accu_TF = new TextField("", 8);
        this.psw_TF = new TextField("", 8);
        this.ireg_TF = new TextField("", 8);
        this.pc_TF = new TextField("", 12);
        this.stackpointer_TF = new TextField("", 3);
        this.addressReg_TF = new TextField("", 8);
        this.port1_TF = new TextField("", 8);
        this.port2_TF = new TextField("", 8);
        this.timer_TF = new TextField("", 8);
        this.prescaler_TF = new TextField("", 8);
        this.tmp_alu1_TF = new TextField("", 8);
        this.tmp_alu2_TF = new TextField("", 8);
        this.tmp_mar_TF = new TextField("", 8);
        this.tmp_dec_TF = new TextField("", 8);
        this.currentCycle_TF = new TextField("", 10);
        this.psw_TF.setForeground(Color.red);
        this.pc_TF.setForeground(Color.blue);
        this.stackpointer_TF.setForeground(Color.blue);
    }

    private void updateTextFields() {
        int accu = 255;
        int psw = 73;
        int pc = 2045;
        int ireg = 45;
        int stackpointer = 3;
        int addressReg = 253;
        int port1 = 1;
        int port2 = 2;
        int timer = 0;
        int prescaler = 0;
        int currentCycle = 0;
        this.setTextFromInt(this.accu_TF, 8, accu);
        this.setTextFromInt(this.ireg_TF, 8, ireg);
        this.setTextFromInt(this.psw_TF, 8, psw);
        this.setTextFromInt(this.pc_TF, 12, pc);
        this.setTextFromInt(this.stackpointer_TF, 3, stackpointer);
        this.setTextFromInt(this.addressReg_TF, 8, addressReg);
        this.setTextFromInt(this.port1_TF, 8, port1);
        this.setTextFromInt(this.port2_TF, 8, port2);
        this.setTextFromInt(this.timer_TF, 8, timer);
        this.setTextFromInt(this.prescaler_TF, 8, prescaler);
        this.setTextFromCycle(this.currentCycle_TF, currentCycle);
    }

    private void setTextFromInt(TextField target, int width, int value) {
        String s = Integer.toString(value, 2);
        while (s.length() < width) {
            s = "0" + s;
        }
        target.setText(s);
    }

    private void setTextFromCycle(TextField target, int value) {
        target.setText("CYCLE_S" + value % 5);
    }

    private void buildGUI() {
        this.frame = new Frame("I8048 state");
        this.frame.setFont(new Font("Monospaced", 0, 12));
        this.frame.setBackground(Color.lightGray);
        this.registerPanel = new Panel();
        this.registerPanel.setLayout(new GridLayout(0, 2));
        this.registerPanel.add(new Label("ACCU:", 2));
        this.registerPanel.add(this.accu_TF);
        this.registerPanel.add(new Label("IREG:", 2));
        this.registerPanel.add(this.ireg_TF);
        this.registerPanel.add(new Label("PSW:", 2));
        this.registerPanel.add(this.psw_TF);
        this.registerPanel.add(new Label(""));
        this.registerPanel.add(new Label(""));
        this.registerPanel.add(new Label("PC:", 2));
        this.registerPanel.add(this.pc_TF);
        this.registerPanel.add(new Label("SP:", 2));
        this.registerPanel.add(this.stackpointer_TF);
        this.registerPanel.add(new Label(""));
        this.registerPanel.add(new Label(""));
        this.registerPanel.add(new Label("Port 1:", 2));
        this.registerPanel.add(this.port1_TF);
        this.registerPanel.add(new Label("Port 2:", 2));
        this.registerPanel.add(this.port2_TF);
        this.registerPanel.add(new Label("Timer:", 2));
        this.registerPanel.add(this.timer_TF);
        this.registerPanel.add(new Label("Prescaler:", 2));
        this.registerPanel.add(this.prescaler_TF);
        this.frame.add("Center", this.registerPanel);
        this.frame.pack();
    }

    public I8048GUI() {
        this.dbg("-1- I8048GUI constructor... ");
        this.createTextFields();
        this.updateTextFields();
        this.dbg("-2- .");
        this.buildGUI();
    }

    public void dbg(String msg) {
        if (this.debugLevel > 0) {
            System.out.println(msg);
        }
    }

    public String toString() {
        return "I8048GUI microcontroller GUI'";
    }

    public static void main(String[] argv) {
        I8048GUI goose = new I8048GUI();
        goose.frame.setVisible(true);
    }
}

