/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.models.fsm.FSM;
import hades.models.fsm.Signal;
import hades.models.fsm.Statuszeile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class Simulation
extends Panel {
    private FSM fsm;
    private Signal input;
    private Signal output;
    private Signal Selected;
    private int line_length_li;
    private int line_length_re;
    private Font font;
    private FontMetrics fm;
    public static final String status_eingeben = "Neue Inputs/Outputs hinzufuegen oder in den Simulationsmodus wechseln";

    public Simulation(FSM Fsm, Statuszeile Status) {
        this.fsm = Fsm;
        this.Selected = null;
        this.addMouseListener(new EditMouseListener());
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setLayout(null);
        this.font = new Font("SansSerif", 0, 12);
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.lightGray);
        g.draw3DRect(0, 0, d.width - 1, d.height - 1, false);
        g.setColor(Color.black);
        int rand_hor = 1 * d.width / 21;
        int rand_ver = 1 * d.height / 21;
        int abst_hor = 1 * d.width / 21;
        int abst_ver = 1 * d.height / 21;
        int r_breite_li = 6 * d.width / 21;
        int r_breite_re = 4 * d.width / 21;
        int r_hoehe_gr = 11 * d.height / 21;
        int r_hoehe_kl = 3 * d.height / 21;
        int r_offset = 4 * d.height / 21;
        this.line_length_li = 4 * d.width / 21;
        this.line_length_re = 4 * d.width / 21;
        int r1x = rand_hor + this.line_length_li;
        int r1y = rand_ver + r_offset;
        int r2x = r1x;
        int r2y = r1y + r_hoehe_gr + abst_ver;
        int r3x = rand_hor + this.line_length_li + r_breite_li + abst_hor;
        int r3y = rand_ver;
        int border = 20;
        g.setColor(Color.white);
        Polygon polyA = new Polygon();
        Polygon polyB = new Polygon();
        Polygon polyC = new Polygon();
        if (this.fsm.getMachineType() == 0) {
            polyA.addPoint(r2x, d.height - (rand_ver + r_offset / 2) + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 - 5, d.height - (rand_ver + r_offset / 2) + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 - 5, rand_ver + r_offset / 2 - 5);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 2 - 5);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 2 - 15);
            polyA.addPoint(r3x, rand_ver + r_offset / 2);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 2 + 15);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 2 + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 + 5, rand_ver + r_offset / 2 + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 + 5, d.height - (rand_ver + r_offset / 2) - 5);
            polyA.addPoint(r2x, d.height - (rand_ver + r_offset / 2) - 5);
            g.fillPolygon(polyA);
        }
        if (this.fsm.getMachineType() == 1) {
            polyA.addPoint(r2x, d.height - (rand_ver + r_offset / 2) + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 - 5, d.height - (rand_ver + r_offset / 2) + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 - 5, rand_ver + r_offset / 4 * 3 - 5);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 4 * 3 - 5);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 4 * 3 - 15);
            polyA.addPoint(r3x, rand_ver + r_offset / 4 * 3);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 4 * 3 + 15);
            polyA.addPoint(r3x - 10, rand_ver + r_offset / 4 * 3 + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 + 5, rand_ver + r_offset / 4 * 3 + 5);
            polyA.addPoint(rand_hor + 2 * this.line_length_li / 3 + 5, d.height - (rand_ver + r_offset / 2) - 5);
            polyA.addPoint(r2x, d.height - (rand_ver + r_offset / 2) - 5);
            g.fillPolygon(polyA);
        }
        polyB.addPoint(r2x + r_breite_li, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) - 5);
        polyB.addPoint(r2x + r_breite_li + abst_ver + r_breite_re / 2 + 5, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) - 5);
        polyB.addPoint(r2x + r_breite_li + abst_ver + r_breite_re / 2 + 5, d.height - (rand_ver + r_offset / 2) + 5);
        polyB.addPoint(r2x + r_breite_li + 11, d.height - (rand_ver + r_offset / 2) + 5);
        polyB.addPoint(r2x + r_breite_li + 11, d.height - (rand_ver + r_offset / 2) + 15);
        polyB.addPoint(r2x + r_breite_li + 1, d.height - (rand_ver + r_offset / 2));
        polyB.addPoint(r2x + r_breite_li + 11, d.height - (rand_ver + r_offset / 2) - 15);
        polyB.addPoint(r2x + r_breite_li + 11, d.height - (rand_ver + r_offset / 2) - 5);
        polyB.addPoint(r2x + r_breite_li + abst_ver + r_breite_re / 2 - 5, d.height - (rand_ver + r_offset / 2) - 5);
        polyB.addPoint(r2x + r_breite_li + abst_ver + r_breite_re / 2 - 5, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) + 5);
        polyB.addPoint(r2x + r_breite_li, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) + 5);
        g.fillPolygon(polyB);
        polyC.addPoint(rand_hor + 2 * this.line_length_li / 3, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) - 5);
        polyC.addPoint(r2x - 10, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) - 5);
        polyC.addPoint(r2x - 10, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) - 15);
        polyC.addPoint(r2x, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2));
        polyC.addPoint(r2x - 10, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) + 15);
        polyC.addPoint(r2x - 10, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) + 5);
        polyC.addPoint(rand_hor + 2 * this.line_length_li / 3, d.height - (rand_ver + r_hoehe_kl + abst_ver + r_offset / 2) + 5);
        g.fillPolygon(polyC);
        if (this.fsm.getMachineType() == 1) {
            g.setColor(Color.white);
            Polygon polyD = new Polygon();
            polyD.addPoint(rand_hor - 5, r1y + r_hoehe_gr);
            polyD.addPoint(rand_hor - 5, rand_ver + r_offset / 4 - 5);
            polyD.addPoint(r3x - 10, rand_ver + r_offset / 4 - 5);
            polyD.addPoint(r3x - 10, rand_ver + r_offset / 4 - 15);
            polyD.addPoint(r3x, rand_ver + r_offset / 4);
            polyD.addPoint(r3x - 10, rand_ver + r_offset / 4 + 15);
            polyD.addPoint(r3x - 10, rand_ver + r_offset / 4 + 5);
            polyD.addPoint(rand_hor + 5, rand_ver + r_offset / 4 + 5);
            polyD.addPoint(rand_hor + 5, r1y + r_hoehe_gr);
            g.fillPolygon(polyD);
        }
        int i = 0;
        while (i < this.fsm.getInputSize()) {
            this.input = (Signal)this.fsm.inputs.elementAt(i);
            if (this.Selected == this.input) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.blue);
            }
            this.input.ixpos = rand_hor;
            this.input.iypos = r1y + i * (r_hoehe_gr / this.fsm.getInputSize()) + r_hoehe_gr / this.fsm.getInputSize() / 2;
            g.drawLine(this.input.ixpos, this.input.iypos, this.input.ixpos + this.line_length_li, this.input.iypos);
            g.drawString(this.input.name, this.input.ixpos + 5, this.input.iypos - 1);
            g.fillOval(this.input.ixpos - 3, this.input.iypos - 3, 6, 6);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.fsm.getOutputSize()) {
            this.output = (Signal)this.fsm.outputs.elementAt(i2);
            if (this.Selected == this.output) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.blue);
            }
            this.output.ixpos = d.width - rand_hor;
            this.output.iypos = r3y + i2 * (r_hoehe_gr / this.fsm.getOutputSize()) + r_hoehe_gr / this.fsm.getOutputSize() / 2;
            g.drawLine(this.output.ixpos - this.line_length_re, this.output.iypos, this.output.ixpos, this.output.iypos);
            g.drawString(this.output.name, this.output.ixpos - this.fm.stringWidth(this.output.name) - 5, this.output.iypos - 1);
            g.fillOval(this.output.ixpos - 3, this.output.iypos - 3, 6, 6);
            ++i2;
        }
        g.setColor(Color.lightGray);
        g.draw3DRect(r1x, r1y, r_breite_li, r_hoehe_gr, true);
        g.draw3DRect(r2x, r2y, r_breite_li, r_hoehe_kl, true);
        g.draw3DRect(r3x, r3y, r_breite_re, r_hoehe_gr, true);
        this.fsm.drawFSM(r1x + border, r1y + border, r_breite_li - 2 * border, r_hoehe_gr - 2 * border, g, null);
    }

    public Signal getSelected() {
        return this.Selected;
    }

    public void resetSelected() {
        this.Selected = null;
    }

    class EditMouseListener
    extends MouseAdapter {
        EditMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Signal sel = null;
            int i = 0;
            while (i < Simulation.this.fsm.getInputSize()) {
                Simulation.this.input = (Signal)((Simulation)Simulation.this).fsm.inputs.elementAt(i);
                if (((Simulation)Simulation.this).input.ixpos - 4 <= x && x <= ((Simulation)Simulation.this).input.ixpos + Simulation.this.line_length_li && ((Simulation)Simulation.this).input.iypos + 3 >= y && y >= ((Simulation)Simulation.this).input.iypos - 10) {
                    sel = Simulation.this.input;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < Simulation.this.fsm.getOutputSize()) {
                Simulation.this.output = (Signal)((Simulation)Simulation.this).fsm.outputs.elementAt(i);
                if (((Simulation)Simulation.this).output.ixpos - Simulation.this.line_length_re <= x && x <= ((Simulation)Simulation.this).output.ixpos + 4 && ((Simulation)Simulation.this).output.iypos + 3 >= y && y >= ((Simulation)Simulation.this).output.iypos - 10) {
                    sel = Simulation.this.output;
                    break;
                }
                ++i;
            }
            if (Simulation.this.Selected != sel && sel != null) {
                Simulation.this.Selected = sel;
                Simulation.this.repaint();
            }
        }
    }
}

