/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.models.fsm.FSM;
import hades.models.fsm.Signal;
import hades.models.fsm.Simulation;
import hades.models.fsm.Statuszeile;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class SignalDialog
extends Dialog
implements ActionListener {
    protected Simulation simulation;
    private Label labelName;
    public TextField namensfeld;
    public Checkbox in;
    public Checkbox out;
    public CheckboxGroup inout;
    private Button Change;
    private Button Close;
    private Button Delete;
    private Button Create;
    protected Statuszeile status;
    private Signal signal;
    private String name = "";
    private FSM fsm;
    private static final String status_eingeben = "Neue Inputs/Outputs hinzufuegen oder in den Simulationsmodus wechseln";
    private static final String status_ungueltig = "Dieser Name enthaelt ungueltige Zeichen.";
    private static final String status_namevergeben = "Dieser Name ist bereits vergeben.";

    public SignalDialog(Frame frame, boolean modal, FSM Fsm) {
        super(frame, "Edit signals", modal);
        this.fsm = Fsm;
        this.addWindowListener(new EditWindowListener());
        this.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        Insets ins = new Insets(0, 0, 0, 0);
        this.simulation = new Simulation(this.fsm, this.status);
        this.simulation.addMouseListener(new EditMouseListener());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        ins.top = 2;
        ins.bottom = 0;
        ins.left = 2;
        ins.right = 2;
        gbc.insets = ins;
        gbl.setConstraints(this.simulation, gbc);
        this.add(this.simulation);
        this.simulation.setSize(300, 200);
        Panel info = new Panel();
        info.setLayout(gbl);
        this.labelName = new Label("Name:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ins.top = 0;
        ins.bottom = 0;
        ins.left = 0;
        ins.right = 0;
        gbc.insets = ins;
        gbl.setConstraints(this.labelName, gbc);
        info.add(this.labelName);
        this.namensfeld = new TextField("", 20);
        this.namensfeld.addKeyListener(new EditKeyListener());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        ins.top = 0;
        ins.bottom = 0;
        ins.left = 0;
        ins.right = 0;
        gbc.insets = ins;
        gbl.setConstraints(this.namensfeld, gbc);
        info.add(this.namensfeld);
        this.inout = new CheckboxGroup();
        this.in = new Checkbox("input", this.inout, true);
        this.out = new Checkbox("output", this.inout, false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ins.top = 0;
        ins.bottom = 0;
        ins.left = 10;
        ins.right = 0;
        gbc.insets = ins;
        gbl.setConstraints(this.in, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ins.top = 0;
        ins.bottom = 0;
        ins.left = 5;
        ins.right = 0;
        gbc.insets = ins;
        gbl.setConstraints(this.out, gbc);
        info.add(this.in);
        info.add(this.out);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        ins.top = 10;
        ins.bottom = 0;
        ins.left = 10;
        ins.right = 10;
        gbc.insets = ins;
        gbl.setConstraints(info, gbc);
        this.add(info);
        Panel buttons = new Panel();
        buttons.setLayout(new GridLayout(1, 4));
        this.Create = new Button("New");
        this.Create.addActionListener(this);
        this.Create.addKeyListener(new EditKeyListener());
        buttons.add(this.Create);
        this.Change = new Button("Change");
        this.Change.addActionListener(this);
        this.Change.addKeyListener(new EditKeyListener());
        buttons.add(this.Change);
        this.Delete = new Button("Delete");
        this.Delete.addActionListener(this);
        this.Delete.addKeyListener(new EditKeyListener());
        buttons.add(this.Delete);
        this.Close = new Button("Close");
        this.Close.addActionListener(this);
        this.Close.addKeyListener(new EditKeyListener());
        buttons.add(this.Close);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        ins.top = 10;
        ins.bottom = 0;
        ins.left = 2;
        ins.right = 2;
        gbc.insets = ins;
        gbl.setConstraints(buttons, gbc);
        this.add(buttons);
        this.status = new Statuszeile();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        ins.top = 2;
        ins.bottom = 0;
        ins.left = 2;
        ins.right = 2;
        gbc.insets = ins;
        gbl.setConstraints(this.status, gbc);
        this.add(this.status);
    }

    public void actionPerformed(ActionEvent evt) {
        Signal s;
        int i;
        Vector v;
        boolean exists;
        int i2;
        char[] cin;
        boolean valid;
        if (evt.getSource() == this.Change && this.simulation.getSelected() != null) {
            this.status.set("");
            this.name = this.namensfeld.getText();
            this.signal = this.simulation.getSelected();
            if (this.inout.getSelectedCheckbox() == this.in && this.signal.in_out == 1) {
                this.fsm.deleteOutput(this.signal);
                this.signal = this.fsm.newInput();
                this.signal.name = this.name;
                this.signal.value = 2;
            } else if (this.inout.getSelectedCheckbox() == this.out && this.signal.in_out == 0) {
                this.fsm.deleteInput(this.signal);
                this.signal = this.fsm.newOutput();
                this.signal.name = this.name;
                this.signal.value = 2;
            } else {
                valid = true;
                cin = this.name.toCharArray();
                if (!(this.name.equals("") || cin[0] >= 'A' && cin[0] <= 'Z' || cin[0] >= 'a' && cin[0] <= 'z' || cin[0] == '_' || cin[0] == '_')) {
                    valid = false;
                }
                i2 = 1;
                while (i2 < cin.length) {
                    if (!(cin[i2] >= 'A' && cin[i2] <= 'Z' || cin[i2] >= 'a' && cin[i2] <= 'z' || cin[i2] == '_' || cin[i2] == '_' || cin[i2] >= '0' && cin[i2] <= '9')) {
                        valid = false;
                    }
                    ++i2;
                }
                if (!valid) {
                    this.status.set(status_ungueltig);
                } else {
                    exists = false;
                    if (this.name.equals("")) {
                        exists = true;
                    }
                    v = this.fsm.inputs;
                    i = 0;
                    while (i < v.size()) {
                        Signal s2 = (Signal)v.elementAt(i);
                        if (this.name.equals(s2.name)) {
                            exists = true;
                        }
                        ++i;
                    }
                    v = this.fsm.outputs;
                    int i3 = 0;
                    while (i3 < v.size()) {
                        s = (Signal)v.elementAt(i3);
                        if (this.name.equals(s.name)) {
                            exists = true;
                        }
                        ++i3;
                    }
                    if (exists) {
                        this.status.set(status_namevergeben);
                    } else {
                        this.signal.name = this.name;
                        this.signal.value = 2;
                    }
                }
                this.fsm.reset();
            }
            this.simulation.repaint();
            this.signal = null;
            this.simulation.resetSelected();
        }
        if (evt.getSource() == this.Close) {
            this.dispose();
        }
        if (evt.getSource() == this.Delete) {
            this.status.set("");
            Signal signal = this.simulation.getSelected();
            if (signal != null) {
                if (signal.in_out == 0) {
                    this.fsm.deleteInput(signal);
                } else {
                    this.fsm.deleteOutput(signal);
                }
                this.simulation.repaint();
            }
        } else if (evt.getSource() == this.Create) {
            this.status.set("");
            this.name = this.namensfeld.getText();
            valid = true;
            cin = this.name.toCharArray();
            if (!(this.name.equals("") || cin[0] >= 'A' && cin[0] <= 'Z' || cin[0] >= 'a' && cin[0] <= 'z' || cin[0] == '_' || cin[0] == '_')) {
                valid = false;
            }
            i2 = 1;
            while (i2 < cin.length) {
                if (!(cin[i2] >= 'A' && cin[i2] <= 'Z' || cin[i2] >= 'a' && cin[i2] <= 'z' || cin[i2] == '_' || cin[i2] == '_' || cin[i2] >= '0' && cin[i2] <= '9')) {
                    valid = false;
                }
                ++i2;
            }
            if (!valid) {
                this.status.set(status_ungueltig);
            } else {
                exists = false;
                if (this.name.equals("")) {
                    exists = true;
                }
                v = this.fsm.inputs;
                i = 0;
                while (i < v.size()) {
                    Signal s3 = (Signal)v.elementAt(i);
                    if (this.name.equals(s3.name)) {
                        exists = true;
                    }
                    ++i;
                }
                v = this.fsm.outputs;
                int i4 = 0;
                while (i4 < v.size()) {
                    s = (Signal)v.elementAt(i4);
                    if (this.name.equals(s.name)) {
                        exists = true;
                    }
                    ++i4;
                }
                if (exists) {
                    this.status.set(status_namevergeben);
                } else {
                    this.signal = this.inout.getSelectedCheckbox() == this.in ? this.fsm.newInput() : this.fsm.newOutput();
                    this.signal.name = this.name;
                    this.signal.value = 2;
                    this.name = "";
                }
                this.fsm.reset();
            }
            this.namensfeld.setText("");
            this.namensfeld.requestFocus();
            this.simulation.repaint();
        }
    }

    class EditMouseListener
    extends MouseAdapter {
        EditMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            SignalDialog.this.status.set("");
            Signal s = SignalDialog.this.simulation.getSelected();
            if (s != null) {
                SignalDialog.this.namensfeld.setText(s.name);
                if (s.in_out == 0) {
                    SignalDialog.this.inout.setSelectedCheckbox(SignalDialog.this.in);
                } else {
                    SignalDialog.this.inout.setSelectedCheckbox(SignalDialog.this.out);
                }
            }
        }
    }

    class EditKeyListener
    extends KeyAdapter {
        EditKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.getKeyChar() == '\t') {
                if (event.getSource() == SignalDialog.this.namensfeld) {
                    SignalDialog.this.Create.requestFocus();
                }
                if (event.getSource() == SignalDialog.this.Create) {
                    SignalDialog.this.Change.requestFocus();
                }
                if (event.getSource() == SignalDialog.this.Change) {
                    SignalDialog.this.Delete.requestFocus();
                }
                if (event.getSource() == SignalDialog.this.Delete) {
                    SignalDialog.this.Close.requestFocus();
                }
                if (event.getSource() == SignalDialog.this.Close) {
                    SignalDialog.this.namensfeld.requestFocus();
                }
            }
        }
    }

    class EditWindowListener
    extends WindowAdapter {
        EditWindowListener() {
        }

        public void windowClosing(WindowEvent event) {
            SignalDialog.this.status.set(SignalDialog.status_eingeben);
            SignalDialog.this.dispose();
        }
    }
}

