/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.gui.Console;
import hades.models.fsm.BadExpressionException;
import hades.models.fsm.EditFrame;
import hades.models.fsm.FsmWrapper;
import hades.models.fsm.Kommentar;
import hades.models.fsm.Parser;
import hades.models.fsm.Signal;
import hades.models.fsm.Statuszeile;
import hades.models.fsm.Transition;
import hades.models.fsm.Zustand;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;

public class FSM {
    private String name = "No Name";
    private String resourceName;
    private EditFrame editor;
    boolean blocked = false;
    public Vector inputs;
    public Vector outputs;
    public Vector zustaende;
    public Vector transitionen;
    public Vector kommentare;
    public Zustand currentState;
    public Vector aktivierteTransitionen;
    public int mealy_moore;
    public static final int MOORE = 0;
    public static final int MEALY = 1;
    private Parser parser;
    protected Statuszeile status = new Statuszeile();
    private Console console;
    private FsmWrapper wrapper;
    private static int r = 16;
    private static int d = 6;

    public FSM() {
        this.inputs = new Vector(10, 10);
        this.outputs = new Vector(10, 10);
        this.zustaende = new Vector(10, 10);
        this.transitionen = new Vector(20, 20);
        this.kommentare = new Vector(10, 10);
        this.aktivierteTransitionen = new Vector(5, 3);
        this.parser = new Parser();
    }

    public void edit() {
        if (this.editor == null) {
            this.editor = new EditFrame("JavaFSM", this);
        }
        this.editor.setVisible(true);
        this.editor.setSize(600, 450);
    }

    public FsmWrapper getFsmWrapper() {
        return this.wrapper;
    }

    public void edit(FsmWrapper wrapper) {
        this.wrapper = wrapper;
        if (this.editor == null) {
            this.editor = new EditFrame("JavaFSM", this);
        }
        this.editor.setVisible(true);
        this.editor.setSize(600, 450);
    }

    public EditFrame getEditFrame() {
        return this.editor;
    }

    protected void rebuild() {
        if (this.wrapper != null) {
            this.wrapper.rebuildFSM(this);
        }
    }

    public void newMachine() {
        this.name = "No Name";
        this.blocked = false;
        this.inputs.removeAllElements();
        this.outputs.removeAllElements();
        this.zustaende.removeAllElements();
        this.transitionen.removeAllElements();
        this.kommentare.removeAllElements();
        this.aktivierteTransitionen.removeAllElements();
        this.currentState = null;
    }

    public static FSM getDefaultFSM() {
        FSM fsm = new FSM();
        fsm.name = "FSM";
        fsm.currentState = null;
        return fsm;
    }

    public void setStatuszeile(Statuszeile sz) {
        this.status = sz;
    }

    public Signal newInput() {
        Signal s = new Signal(0);
        this.inputs.addElement(s);
        this.validateSignals();
        return s;
    }

    public Signal newOutput() {
        Signal s = new Signal(1);
        this.outputs.addElement(s);
        this.validateSignals();
        return s;
    }

    public Zustand newZustand(String name, int x, int y) {
        Zustand zustand = new Zustand(name, x, y);
        int i = 0;
        while (i < this.outputs.size()) {
            zustand.outputHash.put(this.outputs.elementAt(i), "0");
            ++i;
        }
        this.zustaende.addElement(zustand);
        return zustand;
    }

    public Transition newTransition(Zustand z1, Zustand z2) {
        if (this.findTransition(z1, z2) < 0) {
            Transition transition = new Transition(z1, z2);
            this.transitionen.addElement(transition);
            return transition;
        }
        return null;
    }

    public Kommentar newKommentar(String txt, int x, int y) {
        Kommentar kommentar = new Kommentar(txt, x, y);
        this.kommentare.addElement(kommentar);
        return kommentar;
    }

    public int findTransition(Zustand z1, Zustand z2) {
        int found = -1;
        int k = 0;
        while (k < this.transitionen.size()) {
            Transition tr = (Transition)this.transitionen.elementAt(k);
            if (tr.von == z1 && tr.nach == z2) {
                found = k;
            }
            ++k;
        }
        return found;
    }

    public void deleteInput(Signal in) {
        this.inputs.removeElement(in);
        this.validateSignals();
    }

    public void deleteOutput(Signal out) {
        this.outputs.removeElement(out);
        this.validateSignals();
    }

    public void deleteZustand(Zustand z) {
        int i = 0;
        while (i < this.transitionen.size()) {
            Transition transition = (Transition)this.transitionen.elementAt(i);
            if (transition.von == z || transition.nach == z) {
                this.transitionen.removeElementAt(i--);
            }
            ++i;
        }
        this.zustaende.removeElement(z);
        if (this.currentState == z) {
            this.currentState = null;
        }
    }

    public void deleteTransition(Transition t) {
        this.transitionen.removeElement(t);
    }

    public void deleteKommentar(Kommentar k) {
        this.kommentare.removeElement(k);
    }

    private void validateSignals() {
        block4: {
            Signal sig;
            block5: {
                if (this.outputs.size() <= 0 || this.zustaende.size() <= 0) break block4;
                sig = null;
                if (this.outputs.size() >= ((Zustand)this.zustaende.elementAt((int)0)).outputHash.size()) break block5;
                Enumeration e = ((Zustand)this.zustaende.elementAt((int)0)).outputHash.keys();
                while (e.hasMoreElements()) {
                    sig = (Signal)e.nextElement();
                    if (this.outputs.contains(sig)) continue;
                    int i = 0;
                    while (i < this.zustaende.size()) {
                        ((Zustand)this.zustaende.elementAt((int)i)).outputHash.remove(sig);
                        ++i;
                    }
                }
                break block4;
            }
            if (this.outputs.size() <= ((Zustand)this.zustaende.elementAt((int)0)).outputHash.size()) break block4;
            int i = 0;
            while (i < this.outputs.size()) {
                sig = (Signal)this.outputs.elementAt(i);
                if (!((Zustand)this.zustaende.elementAt((int)0)).outputHash.containsKey(sig)) break;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.zustaende.size()) {
                ((Zustand)this.zustaende.elementAt((int)i2)).outputHash.put(sig, "0");
                ++i2;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }

    public int getInputSize() {
        return this.inputs.size();
    }

    public int getOutputSize() {
        return this.outputs.size();
    }

    public int getZustaendeSize() {
        return this.zustaende.size();
    }

    public Vector getAktivierteTransitionen() {
        return this.aktivierteTransitionen;
    }

    public void takt() {
        this.calculateZustand();
        int i = 0;
        while (i < this.outputs.size()) {
            Signal signal = (Signal)this.outputs.elementAt(i);
            String s = (String)this.currentState.outputHash.get(signal);
            try {
                signal.value = this.parser.parse(s, this.inputs) ? 1 : 0;
            }
            catch (BadExpressionException e) {
                this.status.set("Ausgang " + signal.name + " im Zustand " + this.currentState.name + " nicht richtig definiert!");
                signal.value = 2;
            }
            ++i;
        }
    }

    public void zwischentakt() {
        int i = 0;
        while (i < this.outputs.size()) {
            Signal signal = (Signal)this.outputs.elementAt(i);
            String s = (String)this.currentState.outputHash.get(signal);
            try {
                signal.value = this.parser.parse(s, this.inputs) ? 1 : 0;
            }
            catch (BadExpressionException e) {
                this.status.set("Ausgang " + signal.name + " im Zustand " + this.currentState.name + " nicht richtig definiert!");
                signal.value = 2;
            }
            ++i;
        }
    }

    public void reset() {
        this.blocked = false;
        this.currentState = this.getStartzustand();
        this.aktivierteTransitionen.removeAllElements();
        int i = 0;
        while (i < this.inputs.size()) {
            Signal input = (Signal)this.inputs.elementAt(i);
            input.value = 2;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.outputs.size()) {
            Signal output = (Signal)this.outputs.elementAt(i2);
            output.value = 2;
            ++i2;
        }
    }

    public void setMealy() {
        this.mealy_moore = 1;
    }

    public void setMoore() {
        this.mealy_moore = 0;
        int i = 0;
        while (i < this.zustaende.size()) {
            Zustand z = (Zustand)this.zustaende.elementAt(i);
            int j = 0;
            while (j < this.outputs.size()) {
                Signal out = (Signal)this.outputs.elementAt(j);
                if (!((String)z.outputHash.get(out)).equals("1")) {
                    z.outputHash.put(out, "0");
                }
                ++j;
            }
            ++i;
        }
    }

    public int getMachineType() {
        return this.mealy_moore;
    }

    public void setStart(Zustand z) {
        int i = 0;
        while (i < this.zustaende.size()) {
            ((Zustand)this.zustaende.elementAt((int)i)).isStart = false;
            ++i;
        }
        z.isStart = true;
    }

    public boolean existsStartzustand() {
        int i = 0;
        while (i < this.zustaende.size()) {
            Zustand z = (Zustand)this.zustaende.elementAt(i);
            if (z.isStart) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Zustand getStartzustand() {
        int i = 0;
        while (i < this.zustaende.size()) {
            Zustand z = (Zustand)this.zustaende.elementAt(i);
            if (z.isStart) {
                return z;
            }
            ++i;
        }
        return null;
    }

    public void calculateZustand() {
        block10: {
            if (this.blocked) break block10;
            int aktiviert = 0;
            int stern = 0;
            this.aktivierteTransitionen.removeAllElements();
            Zustand nextState = null;
            Zustand defaultState = null;
            Transition t = null;
            try {
                int i = 0;
                while (i < this.transitionen.size()) {
                    t = (Transition)this.transitionen.elementAt(i);
                    if (t.von == this.currentState) {
                        if (t.function.equals("*")) {
                            ++stern;
                            defaultState = t.nach;
                        } else if (this.parser.parse(t.function, this.inputs)) {
                            ++aktiviert;
                            nextState = t.nach;
                        }
                    }
                    ++i;
                }
                if (aktiviert == 1) {
                    this.currentState = nextState;
                    break block10;
                }
                if (stern == 1) {
                    this.currentState = defaultState;
                    break block10;
                }
                if (stern > 1) {
                    this.status.set("Es darf nur eine Uebergangsbedingung den Stern enthalten.");
                    this.blocked = true;
                    break block10;
                }
                this.status.set("Uebergang nicht eindeutig definiert");
                this.blocked = true;
            }
            catch (BadExpressionException e) {
                this.status.set("Uebergangsfunktion fehlerhaft!");
                this.blocked = true;
            }
        }
    }

    public void calculateTransition() {
        this.aktivierteTransitionen.removeAllElements();
        Transition t = null;
        int stern = 0;
        Transition def = null;
        try {
            int i = 0;
            while (i < this.transitionen.size()) {
                t = (Transition)this.transitionen.elementAt(i);
                if (t.von == this.currentState) {
                    if (t.function.equals("*")) {
                        ++stern;
                        def = t;
                    } else if (this.parser.parse(t.function, this.inputs)) {
                        this.aktivierteTransitionen.addElement(t);
                    }
                }
                ++i;
            }
            if (this.aktivierteTransitionen.size() == 0 && stern == 1) {
                this.aktivierteTransitionen.addElement(def);
            }
        }
        catch (BadExpressionException e) {
            this.status.set("Uebergangsfunktion fehlerhaft!");
        }
    }

    public String saveFSM() {
        Signal sig;
        String data = "";
        data = data + "[JavaFSM V1.0]\n";
        data = this.getMachineType() == 0 ? data + "[MOORE]\n" : data + "[MEALY]\n";
        data = data + "[Name]\n" + this.name + "\n";
        data = data + "[Inputs " + this.inputs.size() + "]\n";
        int i = 0;
        while (i < this.inputs.size()) {
            sig = (Signal)this.inputs.elementAt(i);
            data = data + sig.name + ",0\n";
            ++i;
        }
        data = data + "[Outputs " + this.outputs.size() + "]\n";
        int i2 = 0;
        while (i2 < this.outputs.size()) {
            sig = (Signal)this.outputs.elementAt(i2);
            data = data + sig.name + "\n";
            ++i2;
        }
        data = data + "[Zustaende " + this.zustaende.size() + "]\n";
        int i3 = 0;
        while (i3 < this.zustaende.size()) {
            Zustand zu = (Zustand)this.zustaende.elementAt(i3);
            data = data + zu.name + "," + zu.x + "," + zu.y + "," + zu.isStart;
            int j = 0;
            while (j < this.outputs.size()) {
                data = data + "," + (String)zu.outputHash.get(this.outputs.elementAt(j));
                ++j;
            }
            data = data + "\n";
            ++i3;
        }
        data = data + "[Transitionen " + this.transitionen.size() + "]\n";
        int i4 = 0;
        while (i4 < this.transitionen.size()) {
            Transition tran = (Transition)this.transitionen.elementAt(i4);
            data = data + tran.von.name + "," + tran.nach.name + "," + tran.function + "\n";
            ++i4;
        }
        data = data + "[Kommentare " + this.kommentare.size() + "]\n";
        int i5 = 0;
        while (i5 < this.kommentare.size()) {
            Kommentar kom = (Kommentar)this.kommentare.elementAt(i5);
            data = data + kom.x + "," + kom.y + "," + this.CodeString(kom.getText()) + "\n";
            ++i5;
        }
        data = data + "[ENDE]\n";
        return data;
    }

    public String loadFSM(Reader reader) {
        block29: {
            BufferedReader in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            try {
                if (in.readLine().trim().equals("[JavaFSM V1.0]") || in.readLine().trim().equals("[JavaFSM V1.0]")) {
                    int i;
                    int k;
                    this.newMachine();
                    String str = in.readLine().trim();
                    if (str.equals("[MOORE]")) {
                        this.setMoore();
                    } else if (str.equals("[MEALY]")) {
                        this.setMealy();
                    } else {
                        return "Fehler im Datei-Format";
                    }
                    str = in.readLine().trim();
                    if (!str.equals("[Name]")) {
                        return "Fehler im Datei-Format";
                    }
                    this.name = in.readLine().trim();
                    str = in.readLine().trim();
                    if (str.startsWith("[Inputs")) {
                        k = this.getNumber(str);
                        i = 0;
                        while (i < k) {
                            str = in.readLine().trim();
                            if (str.startsWith("[") || this.countChar(str, ',') != 1) {
                                return "Fehler im Datei-Format";
                            }
                            this.inputs.addElement(this.stringToInput(str));
                            ++i;
                        }
                    } else {
                        return "Fehler im Datei-Format";
                    }
                    str = in.readLine().trim();
                    if (str.startsWith("[Outputs")) {
                        k = this.getNumber(str);
                        i = 0;
                        while (i < k) {
                            str = in.readLine().trim();
                            if (str.startsWith("[") || this.countChar(str, ',') != 0) {
                                return "Fehler im Datei-Format";
                            }
                            this.outputs.addElement(this.stringToOutput(str));
                            ++i;
                        }
                    } else {
                        return "Fehler im Datei-Format";
                    }
                    str = in.readLine().trim();
                    if (str.startsWith("[Zustaende")) {
                        k = this.getNumber(str);
                        i = 0;
                        while (i < k) {
                            str = in.readLine().trim();
                            if (str.startsWith("[") || this.countChar(str, ',') != 3 + this.outputs.size()) {
                                return "Fehler im Datei-Format";
                            }
                            this.zustaende.addElement(this.stringToZustand(str));
                            ++i;
                        }
                    } else {
                        return "Fehler im Datei-Format";
                    }
                    str = in.readLine().trim();
                    if (str.startsWith("[Transitionen")) {
                        k = this.getNumber(str);
                        i = 0;
                        while (i < k) {
                            str = in.readLine().trim();
                            if (str.startsWith("[") || this.countChar(str, ',') != 2) {
                                return "Fehler im Datei-Format";
                            }
                            this.transitionen.addElement(this.stringToTransition(str));
                            ++i;
                        }
                    } else {
                        return "Fehler im Datei-Format";
                    }
                    str = in.readLine().trim();
                    if (str.startsWith("[Kommentare")) {
                        k = this.getNumber(str);
                        i = 0;
                        while (i < k) {
                            str = in.readLine().trim();
                            if (str.startsWith("[") || this.countChar(str, ',') != 2) {
                                return "Fehler im Datei-Format";
                            }
                            this.kommentare.addElement(this.stringToKommentar(str));
                            ++i;
                        }
                    } else {
                        return "Fehler im Datei-Format";
                    }
                    str = in.readLine().trim();
                    if (!str.startsWith("[Simulation") && !str.equals("[ENDE]")) {
                        return "Fehler im Datei-Format";
                    }
                    break block29;
                }
                return "Falsche Version";
            }
            catch (Exception e) {
                return "Lesefehler - IO-Exception";
            }
        }
        return null;
    }

    private int countChar(String s, char c) {
        int count = 0;
        int j = 0;
        while (j < s.length()) {
            if (s.charAt(j) == c) {
                ++count;
            }
            ++j;
        }
        return count;
    }

    private int getNumber(String str) {
        try {
            return Integer.parseInt(str.substring(str.indexOf(32) + 1, str.indexOf(93)));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Signal stringToInput(String str) {
        int p = str.indexOf(44);
        return new Signal(str.substring(0, p), 0);
    }

    private Signal stringToOutput(String str) {
        return new Signal(str, 1);
    }

    private Zustand stringToZustand(String str) {
        int p1 = str.indexOf(44);
        int p2 = str.indexOf(44, p1 + 1);
        int p3 = str.indexOf(44, p2 + 1);
        Zustand zu = new Zustand(str.substring(0, p1), Integer.parseInt(str.substring(p1 + 1, p2)), Integer.parseInt(str.substring(p2 + 1, p3)));
        if (str.substring(p3 + 1, p3 + 2).equals("t")) {
            zu.isStart = true;
        }
        p2 = str.indexOf(44, p3 + 1);
        int i = 0;
        while (i < this.outputs.size()) {
            p1 = p2;
            if ((p2 = str.indexOf(44, p2 + 1)) >= 0) {
                zu.outputHash.put(this.outputs.elementAt(i), str.substring(p1 + 1, p2));
            } else {
                zu.outputHash.put(this.outputs.elementAt(i), str.substring(p1 + 1));
            }
            ++i;
        }
        return zu;
    }

    private Transition stringToTransition(String str) {
        int p1 = str.indexOf(44);
        int p2 = str.indexOf(44, p1 + 1);
        String von = str.substring(0, p1);
        String nach = str.substring(p1 + 1, p2);
        Zustand vonZ = null;
        Zustand nachZ = null;
        Transition tr = null;
        int i = 0;
        while (i < this.zustaende.size()) {
            Zustand zu = (Zustand)this.zustaende.elementAt(i);
            if (zu.name.equals(von)) {
                vonZ = zu;
            }
            if (zu.name.equals(nach)) {
                nachZ = zu;
            }
            ++i;
        }
        if (vonZ != null && nachZ != null) {
            tr = new Transition(vonZ, nachZ, str.substring(p2 + 1));
        }
        return tr;
    }

    private Kommentar stringToKommentar(String str) {
        int p1 = str.indexOf(44);
        int p2 = str.indexOf(44, p1 + 1);
        return new Kommentar(this.DecodeString(str.substring(p2 + 1)), Integer.parseInt(str.substring(0, p1)), Integer.parseInt(str.substring(p1 + 1, p2)));
    }

    private String CodeString(String str) {
        String Result = new String("");
        int x = 0;
        while (x < str.length()) {
            char c = str.charAt(x);
            Result = c < ' ' || c == ',' || c == '%' ? Result + "%" + (char)(c / 10 + 48) + (char)(c % 10 + 48) : Result + "" + c;
            ++x;
        }
        return Result;
    }

    private String DecodeString(String str) {
        String Result = new String("");
        int x = 0;
        while (x < str.length()) {
            char c = str.charAt(x);
            if (c == '%') {
                char c1 = (char)(str.charAt(++x) - 48);
                char c2 = (char)(str.charAt(++x) - 48);
                Result = Result + "" + (char)(c1 * 10 + c2);
            } else {
                Result = Result + "" + c;
            }
            ++x;
        }
        return Result;
    }

    private void drawScaledArrow(Point p1, Point p2, double q, Graphics g) {
        double dy;
        double dx;
        double sqnorm;
        double length = 10.0 * q;
        double width = 2.5 * q;
        if (q < 0.25) {
            length = 2.5;
            width = 0.625;
        }
        if ((sqnorm = Math.sqrt((dx = (double)(p2.x - p1.x)) * dx + (dy = (double)(p2.y - p1.y)) * dy)) == 0.0) {
            sqnorm = 1.0;
        }
        double nx = dx / sqnorm;
        double ny = dy / sqnorm;
        double ox = -dy / sqnorm;
        double oy = dx / sqnorm;
        Point a1 = new Point(p2.x, p2.y);
        Point a2 = new Point((int)((double)p2.x - length * nx + width * ox + 0.5), (int)((double)p2.y - length * ny + width * oy + 0.5));
        Point a4 = new Point((int)((double)p2.x - length * nx - width * ox + 0.5), (int)((double)p2.y - length * ny - width * oy + 0.5));
        Point o = new Point((int)(dx * ((double)r * q + 1.0) / sqnorm), (int)(dy * ((double)r * q + 1.0) / sqnorm));
        g.drawLine(p1.x + o.x, p1.y + o.y, a1.x - o.x, a1.y - o.y);
        g.drawLine(a2.x - o.x, a2.y - o.y, a1.x - o.x, a1.y - o.y);
        g.drawLine(a4.x - o.x, a4.y - o.y, a1.x - o.x, a1.y - o.y);
    }

    public void drawFSM(int xPos, int yPos, int width, int height, Graphics g, Object active) {
        this.drawFSM(xPos, yPos, width, height, g, active, null);
    }

    public void drawFSM(int xPos, int yPos, int width, int height, Graphics g, Object active, Vector active_trans) {
        Zustand zustand;
        int xMin = 64000;
        int xMax = 0;
        int yMin = 64000;
        int yMax = 0;
        int i = 0;
        while (i < this.zustaende.size()) {
            zustand = (Zustand)this.zustaende.elementAt(i);
            if (zustand.x < xMin) {
                xMin = zustand.x;
            }
            if (zustand.x > xMax) {
                xMax = zustand.x;
            }
            if (zustand.y < yMin) {
                yMin = zustand.y;
            }
            if (zustand.y > yMax) {
                yMax = zustand.y;
            }
            ++i;
        }
        double qx = (double)width / (double)((xMax += r) - (xMin -= r));
        double qy = (double)height / (double)((yMax += r) - (yMin -= r));
        double q = qx < qy ? qx : qy;
        if (q > 0.7) {
            q = 0.7;
        }
        i = 0;
        while (i < this.zustaende.size()) {
            zustand = (Zustand)this.zustaende.elementAt(i);
            if (zustand == active) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            g.drawOval((int)((double)(zustand.x - r - xMin) * q) + xPos, (int)((double)(zustand.y - r - yMin) * q) + yPos, (int)((double)(r + r) * q), (int)((double)(r + r) * q));
            if (zustand.isStart) {
                g.drawOval((int)((double)(zustand.x - r - xMin) * q) + xPos + 2, (int)((double)(zustand.y - r - yMin) * q) + yPos + 2, (int)((double)(r + r) * q) - 4, (int)((double)(r + r) * q) - 4);
            }
            ++i;
        }
        i = 0;
        while (i < this.transitionen.size()) {
            Transition transition = (Transition)this.transitionen.elementAt(i);
            if (active_trans != null && active_trans.contains(transition)) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            Point p1 = new Point((int)((double)(transition.von.x - xMin) * q) + xPos, (int)((double)(transition.von.y - yMin) * q) + yPos);
            Point p2 = new Point((int)((double)(transition.nach.x - xMin) * q) + xPos, (int)((double)(transition.nach.y - yMin) * q) + yPos);
            if (transition.von == transition.nach) {
                p1.x -= new Double((double)(r / 2) * q).intValue();
                p2.x = p1.x;
                p1.y -= new Double((double)(r - 1) * q).intValue();
                p2.y -= new Double((double)(r + r) * q).intValue();
                g.drawLine((int)((double)p1.x + (double)r * q), p1.y, (int)((double)p1.x + (double)r * q), p2.y);
                g.drawArc(p1.x, (int)((double)p2.y - (double)(r / 2) * q), (int)((double)r * q), (int)((double)r * q), 0, 200);
                p2.y -= new Double((double)(r + 1) * q).intValue();
                p1.y += new Double((double)(r + 1) * q).intValue();
                this.drawScaledArrow(p2, p1, q, g);
            } else {
                int dy;
                int dx;
                int h;
                if (this.findTransition(transition.nach, transition.von) >= 0 && (h = (int)Math.sqrt((dx = p2.x - p1.x) * dx + (dy = p2.y - p1.y) * dy)) > 0) {
                    p1.x += new Double((double)(dy * d / h) * q).intValue();
                    p2.x += new Double((double)(dy * d / h) * q).intValue();
                    p1.y -= new Double((double)(dx * d / h) * q).intValue();
                    p2.y -= new Double((double)(dx * d / h) * q).intValue();
                }
                this.drawScaledArrow(p1, p2, q, g);
            }
            ++i;
        }
    }

    public void message(String msg) {
        if (this.console != null) {
            this.console.println(msg);
        } else {
            System.err.println(msg);
        }
    }
}

