/*
 * Decompiled with CFR 0.152.
 */
package hades.models.flipflops;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.ContextToolTip;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;

public class GenericFlipflop
extends SimObject
implements Simulatable,
Assignable,
ContextToolTip,
Serializable {
    private static final long serialVersionUID = -2284182227167663139L;
    protected double t_pass = 5.0E-9;
    protected double t_setup = 4.0E-9;
    protected double t_hold = 3.0E-9;
    protected PortStdLogic1164 port_Q;
    protected PortStdLogic1164 port_NQ;

    public double getDelay() {
        return this.t_pass;
    }

    public double getSetupTime() {
        return this.t_setup;
    }

    public double getHoldTime() {
        return this.t_hold;
    }

    public void setDelay(double t) {
        this.t_pass = t;
    }

    public void setSetupTime(double t) {
        this.t_setup = t;
    }

    public void setHoldTime(double t) {
        this.t_hold = t;
    }

    public void setDelay(String s) {
        this.t_pass = this.parse(s);
    }

    public void setSetupTime(String s) {
        this.t_setup = this.parse(s);
    }

    public void setHoldTime(String s) {
        this.t_hold = this.parse(s);
    }

    private double parse(String s) {
        double result;
        try {
            result = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- GenericFlipflop: illegal time value: " + e);
            result = 5.0E-9;
            this.message("-I- resetting to default value, delay = " + result);
        }
        return result;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "propagation delay [sec]:", "delay", "setup time [sec]:", "setupTime", "hold time [sec]:", "holdTime"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int n_tokens = st.countTokens();
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            if (n_tokens == 2) {
                this.t_pass = this.parse(st.nextToken());
            } else if (n_tokens == 4) {
                this.t_pass = this.parse(st.nextToken());
                this.t_setup = this.parse(st.nextToken());
                this.t_hold = this.parse(st.nextToken());
            }
            if (SimObject.debug) {
                this.message("GenericFlipflop.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- GenericFlipflop.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_pass + " " + this.t_setup + " " + this.t_hold);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
    }

    public void scheduleEvent(Signal signal, double time, StdLogic1164 value, Port port) {
        if (this.simulator == null) {
            this.message("GenericFlipflop.scheduleEvent: simulator is null...");
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void scheduleEventAfter(Signal signal, double delay, StdLogic1164 value, Port port) {
        if (this.simulator == null) {
            this.message("GenericFlipflop.scheduleEvent: simulator is null...");
            return;
        }
        double time = this.simulator.getSimTime() + delay;
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void scheduleOutputValue(Port port, StdLogic1164 value, double time) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void scheduleOutputValueAfter(Port port, StdLogic1164 value, double delay) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        double time = this.simulator.getSimTime() + delay;
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
    }

    public void assign(String value, double time) {
        try {
            if (this.simulator == null) {
                return;
            }
            StdLogic1164 tmp = new StdLogic1164(value.charAt(0));
            this.scheduleOutputValue(this.port_Q, tmp, time);
            this.scheduleOutputValue(this.port_NQ, StdLogic1164.not(tmp), time);
        }
        catch (Exception e) {
            System.err.println("-E- internal in GenericFlipflop.assign: " + e);
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay=" + this.t_pass;
    }
}

