/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.dsp.GenericDspOperator;
import hades.signals.PortDouble;
import hades.simulator.Port;
import hades.simulator.SimObject;
import java.awt.Point;

public class StdLogicVectorToDouble
extends GenericDspOperator {
    protected PortStdLogicVector port_A;
    protected PortDouble port_Y;
    protected StdLogicVector value_A;

    public void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getI0());
        this.port_Y = new PortDouble(this, "Y", 1, null);
        this.ports = new Port[]{this.port_A, this.port_Y};
        this.outputPorts = new PortDouble[]{this.port_Y};
        this.outputValues = new double[]{Double.NaN};
        this.value_A = new StdLogicVector(this.getI0());
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.value_A = this.port_A.getVectorOrUUU();
        double offset = this.getD1();
        double factor = this.getD0();
        if (this.value_A.has_UXZ()) {
            this.setOutputValue(Double.NaN);
        } else {
            this.setOutputValue(offset + factor * (double)this.value_A.getValue());
        }
        this.scheduleOutputValueAfterDelay();
    }

    public void setI0(int n_bits) {
        super.setI0(n_bits);
        this.constructPorts();
    }

    public String[] getPropertySheetFieldNames() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "output delay           [sec]:", "delay", "number or bits:    [1 .. 32]:", "i0", "scaling factor              :", "d0", "scaling offset              :", "d1"};
        return fields;
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "input value<" + (this.getI0() - 1) + ":0>= " + this.value_A.toHexString() + "\n" + "factor= " + this.getD0() + "\n" + "offset= " + this.getD1() + "\n" + "output value= " + this.outputValues[0];
    }
}

