/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.models.dsp.GenericDspOperator;
import hades.signals.SignalStdLogic1164;

public class Random
extends GenericDspOperator {
    private java.util.Random generator = new java.util.Random();

    public Random() {
        this.setControlInputPortNames("C");
        this.setOutputPortNames("Y");
        this.setD0(0.0);
        this.setD1(1.0);
        this.setComment("random value generator");
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "propagation delay [secs]:", "delay", "lower limit [min]:", "d0", "upper limit [max]:", "d1"};
    }

    public void evaluate(Object arg) {
        this.retrieveControlInputValues();
        SignalStdLogic1164 clk = (SignalStdLogic1164)this.controlPorts[0].getSignal();
        if (clk.hasRisingEdge()) {
            double min = this.getD0();
            double max = this.getD1();
            double randomValue = min + (max - min) * this.generator.nextDouble();
            this.setOutputValue(randomValue);
            this.scheduleOutputValueAfterDelay();
        }
    }
}

