/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.models.PortStdLogic1164;
import hades.models.dsp.GenericDspOperator;
import hades.models.string.PortString;
import hades.signals.PortDouble;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import java.awt.Point;
import jfig.utils.Format;

public class Printf
extends GenericDspOperator {
    private static final long serialVersionUID = 8308639752169603831L;
    protected PortString port_Y;
    protected String value_Y;
    protected Format format;

    public Printf() {
        this.constructPorts();
        this.constructFormat();
    }

    public void constructFormat() {
        try {
            this.format = new Format(this.getS0());
        }
        catch (Exception e) {
            this.format = new Format("%12.4f");
        }
        this.setComment("format: " + this.getS0());
    }

    public void constructPorts() {
        this.controlPorts = new PortStdLogic1164[0];
        this.inputPorts = new PortDouble[]{new PortDouble(this, "A", 0, null)};
        this.outputPorts = new PortDouble[0];
        this.outputValues = new double[]{Double.NaN};
        this.port_Y = new PortString(this, "Y", 1, null);
        this.ports = new Port[]{this.inputPorts[0], this.port_Y};
        this.value_Y = "";
    }

    public void setS0(String s) {
        super.setS0(s);
        this.constructFormat();
    }

    public void evaluate(Object arg) {
        try {
            double v = this.inputPorts[0].getValueOrNaN();
            this.value_Y = this.format.form(v);
            SimKernel simulator = this.parent.getSimulator();
            double time = simulator.getSimTime() + this.delay;
            if (this.port_Y.getSignal() != null) {
                simulator.scheduleEvent(SimEvent.createNewSimEvent(this.port_Y.getSignal(), time, this.value_Y, this.port_Y));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean initialize(String s) {
        boolean status = super.initialize(s);
        if (status) {
            this.constructFormat();
        }
        return status;
    }

    public String[] getPropertySheetFieldNames() {
        String[] fields = new String[]{"instance name:", "name", "output delay      [sec]:", "delay", "format string  [%12.4f]:", "s0"};
        return fields;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + this.getComment() + "\n" + "value= " + this.value_Y + "\n";
    }
}

