/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.signals.PortDouble;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;
import jfig.utils.ExceptionTracer;

public class GenericDspOperator
extends SimObject
implements Wakeable {
    private static final long serialVersionUID = -5457494240165322650L;
    protected double delay = this.defaultdelay;
    protected double defaultdelay = 1.0E-8;
    protected double d0;
    protected double d1;
    protected double d2;
    protected double d3;
    protected double d4;
    protected double d5;
    protected double d6;
    protected double d7;
    protected double d8;
    protected double d9;
    protected int i0;
    protected int i1;
    protected int i2;
    protected int i3;
    protected String s0;
    protected String s1;
    protected String s2;
    protected String s3;
    protected String[] outputNames;
    protected PortDouble[] outputPorts;
    protected double[] outputValues;
    protected String[] inputNames;
    protected PortDouble[] inputPorts;
    protected double[] inputValues;
    protected String[] controlNames;
    protected PortStdLogic1164[] controlPorts;
    protected StdLogic1164[] controlValues;
    protected String[] parameterNames;
    protected double[] parameterValues;
    protected String comment = "DSP operator";

    public GenericDspOperator() {
        this.constructPorts();
    }

    public void setInputPortNames(String s) {
        this.setInputPortNames(new String[]{s});
    }

    public void setInputPortNames(String s1, String s2) {
        this.setInputPortNames(new String[]{s1, s2});
    }

    public void setInputPortNames(String s1, String s2, String s3) {
        this.setInputPortNames(new String[]{s1, s2, s3});
    }

    public void setInputPortNames(String[] names) {
        this.inputNames = names == null ? new String[0] : names;
        this.constructPorts();
    }

    public void setControlInputPortNames(String s) {
        this.setControlInputPortNames(new String[]{s});
    }

    public void setControlInputPortNames(String s1, String s2) {
        this.setControlInputPortNames(new String[]{s1, s2});
    }

    public void setControlInputPortNames(String[] names) {
        this.controlNames = names == null ? new String[0] : names;
        this.constructPorts();
    }

    public void setOutputPortNames(String s) {
        this.setOutputPortNames(new String[]{s});
    }

    public void setOutputPortNames(String[] names) {
        this.outputNames = names == null ? new String[0] : names;
        this.constructPorts();
    }

    protected void constructPorts() {
        int n_inputs = this.inputNames != null ? this.inputNames.length : 0;
        int n_controls = this.controlNames != null ? this.controlNames.length : 0;
        int n_outputs = this.outputNames != null ? this.outputNames.length : 0;
        this.inputPorts = new PortDouble[n_inputs];
        this.inputValues = new double[n_inputs];
        int i = 0;
        while (i < n_inputs) {
            this.inputPorts[i] = new PortDouble(this, this.inputNames[i], 0, null);
            ++i;
        }
        this.controlPorts = new PortStdLogic1164[n_controls];
        this.controlValues = new StdLogic1164[n_controls];
        int i2 = 0;
        while (i2 < n_controls) {
            this.controlPorts[i2] = new PortStdLogic1164(this, this.controlNames[i2], 0, null);
            ++i2;
        }
        this.outputPorts = new PortDouble[n_outputs];
        this.outputValues = new double[n_outputs];
        int i3 = 0;
        while (i3 < n_outputs) {
            this.outputPorts[i3] = new PortDouble(this, this.outputNames[i3], 1, null);
            ++i3;
        }
        this.ports = new Port[n_inputs + n_controls + n_outputs];
        int i4 = 0;
        while (i4 < n_inputs) {
            this.ports[i4] = this.inputPorts[i4];
            ++i4;
        }
        int i5 = 0;
        while (i5 < n_controls) {
            this.ports[i5 + n_inputs] = this.controlPorts[i5];
            ++i5;
        }
        int i6 = 0;
        while (i6 < n_outputs) {
            this.ports[i6 + n_inputs + n_controls] = this.outputPorts[i6];
            ++i6;
        }
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(String s) {
        this.setDelay(this._toDouble(s));
    }

    public void setDelay(double _delay) {
        if (_delay < 0.0) {
            this.delay = this.defaultdelay;
            this.message("-W- " + this.toString() + ".setDelay: invalid negative value " + _delay + " replaced by default delay " + this.defaultdelay);
        } else {
            this.delay = _delay;
        }
    }

    public double[] getOutputValues() {
        return this.outputValues;
    }

    public double getOutputValue() {
        return this.outputValues[0];
    }

    public void setOutputValue(double _value) {
        this.outputValues[0] = _value;
        this.updateSymbol();
    }

    public void setOutputValue(String s) {
        this.setOutputValue(this._toDouble(s));
    }

    public boolean isConnected() {
        if (this.ports == null) {
            return false;
        }
        int i = 0;
        while (i < this.ports.length) {
            if (this.ports[i].getSignal() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double getD0() {
        return this.d0;
    }

    public double getD1() {
        return this.d1;
    }

    public double getD2() {
        return this.d2;
    }

    public double getD3() {
        return this.d3;
    }

    public double getD4() {
        return this.d4;
    }

    public double getD5() {
        return this.d5;
    }

    public double getD6() {
        return this.d6;
    }

    public double getD7() {
        return this.d7;
    }

    public double getD8() {
        return this.d8;
    }

    public double getD9() {
        return this.d9;
    }

    public void setD0(double v) {
        this.d0 = v;
    }

    public void setD1(double v) {
        this.d1 = v;
    }

    public void setD2(double v) {
        this.d2 = v;
    }

    public void setD3(double v) {
        this.d3 = v;
    }

    public void setD4(double v) {
        this.d4 = v;
    }

    public void setD5(double v) {
        this.d5 = v;
    }

    public void setD6(double v) {
        this.d6 = v;
    }

    public void setD7(double v) {
        this.d7 = v;
    }

    public void setD8(double v) {
        this.d8 = v;
    }

    public void setD9(double v) {
        this.d9 = v;
    }

    public void setD0(String s) {
        this.setD0(this._toDouble(s));
    }

    public void setD1(String s) {
        this.setD1(this._toDouble(s));
    }

    public void setD2(String s) {
        this.setD2(this._toDouble(s));
    }

    public void setD3(String s) {
        this.setD3(this._toDouble(s));
    }

    public void setD4(String s) {
        this.setD4(this._toDouble(s));
    }

    public void setD5(String s) {
        this.setD5(this._toDouble(s));
    }

    public void setD6(String s) {
        this.setD6(this._toDouble(s));
    }

    public void setD7(String s) {
        this.setD7(this._toDouble(s));
    }

    public void setD8(String s) {
        this.setD8(this._toDouble(s));
    }

    public void setD9(String s) {
        this.setD9(this._toDouble(s));
    }

    public int getI0() {
        return this.i0;
    }

    public int getI1() {
        return this.i1;
    }

    public int getI2() {
        return this.i2;
    }

    public int getI3() {
        return this.i3;
    }

    public void setI0(int i) {
        this.i0 = i;
    }

    public void setI1(int i) {
        this.i1 = i;
    }

    public void setI2(int i) {
        this.i2 = i;
    }

    public void setI3(int i) {
        this.i3 = i;
    }

    public void setI0(String s) {
        this.setI0(this._toInteger(s));
    }

    public void setI1(String s) {
        this.setI1(this._toInteger(s));
    }

    public void setI2(String s) {
        this.setI2(this._toInteger(s));
    }

    public void setI3(String s) {
        this.setI3(this._toInteger(s));
    }

    public String getS0() {
        return this.s0;
    }

    public String getS1() {
        return this.s1;
    }

    public String getS2() {
        return this.s2;
    }

    public String getS3() {
        return this.s3;
    }

    public void setS0(String s) {
        this.s0 = s;
    }

    public void setS1(String s) {
        this.s1 = s;
    }

    public void setS2(String s) {
        this.s2 = s;
    }

    public void setS3(String s) {
        this.s3 = s;
    }

    public double _toDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (Throwable t) {
            this.message("-W- GenericDspOperator._toDouble: invalid string '" + s + "'");
            return Double.NaN;
        }
    }

    public int _toInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable t) {
            this.message("-W- GenericDspOperator._toInteger: invalid string '" + s + "'");
            return 0;
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = this.getPropertySheetFieldNames();
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify operator parameters:");
        this.propertySheet.setVisible(true);
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "propagation delay [secs]:", "delay", "output value:", "outputValue"};
    }

    public void configureOLD() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number of bits [1 .. 62]:", "width", "output value [0..1ZX_b]:", "formattedValue", "output delay [sec]:", "delay", "enable animation: [T/F]", "enableAnimationFlag", "format[0=dec, 1=hex, 2=bin]:", "numberFormat"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setVisible(true);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand the output value. Recognized formats:\nbinary: 0100ZXH0_b,\nhex:    abcd_h\ndecimal: 4711\n");
        this.propertySheet.setVisible(true);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.updateSymbol();
    }

    public void updateSymbol() {
    }

    public void updateAnimatedSymbol() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbol.painter.paint(this.symbol, 50);
    }

    public void addParameter(String name, double initialValue) {
        Thread.dumpStack();
    }

    public double getParameterValue(String name) {
        Thread.dumpStack();
        return Math.PI;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.updateSymbol();
    }

    public void wakeup(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".wakeup()");
        }
    }

    public void scheduleOutputValueAfterDelay() {
        try {
            SimKernel simulator = this.getSimulator();
            double time = simulator.getSimTime() + this.getDelay();
            Signal signal = this.outputPorts[0].getSignal();
            if (signal != null) {
                simulator.scheduleEvent(SimEvent.createNewSimEvent(signal, time, new Double(this.outputValues[0]), this.outputPorts[0]));
            }
        }
        catch (Throwable t) {
            System.out.println("-E- internal error, component is " + this.toString());
            t.printStackTrace();
        }
    }

    public void retrieveInputValues() {
        int i = 0;
        while (i < this.inputPorts.length) {
            this.inputValues[i] = this.inputPorts[i].getValueOrNaN();
            ++i;
        }
    }

    public void retrieveControlInputValues() {
        int i = 0;
        while (i < this.controlPorts.length) {
            this.controlValues[i] = this.controlPorts[i].getValueOrU();
            ++i;
        }
    }

    public void setComment(String s) {
        this.comment = s;
    }

    public String getComment() {
        return this.comment;
    }

    public void scheduleAfter(double t_delay, Port port, Object value) {
        if (value == null) {
            return;
        }
        if (port == null) {
            return;
        }
        SimKernel simulator = this.getSimulator();
        Signal signal = port.getSignal();
        if (simulator == null) {
            return;
        }
        if (signal == null) {
            return;
        }
        simulator.scheduleEvent(new SimEvent(signal, simulator.getSimTime() + t_delay, value, port));
    }

    public void wakeupAfter(double t_delay) {
        SimKernel simulator = this.getSimulator();
        if (simulator == null) {
            return;
        }
        simulator.scheduleWakeup(this, simulator.getSimTime() + t_delay, this);
    }

    public void assign(String value, double simTime) {
        try {
            Object signal = null;
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".assign: " + value);
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.setDelay(st.nextToken());
            this.setD0(st.nextToken());
            this.setD1(st.nextToken());
            this.setD2(st.nextToken());
            this.setD3(st.nextToken());
            this.setI0(st.nextToken());
            this.setI1(st.nextToken());
            this.setI2(st.nextToken());
            this.setI3(st.nextToken());
            this.setS0(NameMangler.decodeUnicodeEscapes(st.nextToken()));
            this.setS1(NameMangler.decodeUnicodeEscapes(st.nextToken()));
            this.setS2(NameMangler.decodeUnicodeEscapes(st.nextToken()));
            this.setS3(NameMangler.decodeUnicodeEscapes(st.nextToken()));
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
            e.printStackTrace();
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
        ps.print(" " + this.delay);
        ps.print(" " + this.d0);
        ps.print(" " + this.d1);
        ps.print(" " + this.d2);
        ps.print(" " + this.d3);
        ps.print(" " + this.i0);
        ps.print(" " + this.i1);
        ps.print(" " + this.i2);
        ps.print(" " + this.i3);
        ps.print(" " + NameMangler.encodeWithUnicodeEscapes(this.s0));
        ps.print(" " + NameMangler.encodeWithUnicodeEscapes(this.s1));
        ps.print(" " + NameMangler.encodeWithUnicodeEscapes(this.s2));
        ps.print(" " + NameMangler.encodeWithUnicodeEscapes(this.s3));
    }

    public SimObject copy() {
        GenericDspOperator tmp = null;
        try {
            tmp = (GenericDspOperator)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.setOutputValue(this.getOutputValue());
            tmp.setDelay(this.getDelay());
            tmp.setVersionId(this.getVersionId());
            tmp.setD0(this.getD0());
            tmp.setD1(this.getD1());
            tmp.setD2(this.getD2());
            tmp.setD3(this.getD3());
            tmp.setD4(this.getD4());
            tmp.setD5(this.getD5());
            tmp.setD6(this.getD6());
            tmp.setD7(this.getD7());
            tmp.setD8(this.getD8());
            tmp.setD9(this.getD9());
            tmp.setI0(this.getI0());
            tmp.setI1(this.getI1());
            tmp.setI2(this.getI2());
            tmp.setI3(this.getI3());
            tmp.setS0(this.getS0());
            tmp.setS1(this.getS1());
            tmp.setS2(this.getS2());
            tmp.setS3(this.getS3());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in GenericDspOperator.copy(): " + e);
            e.printStackTrace();
            ExceptionTracer.trace(e);
            return null;
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + this.getComment() + "\n" + "value= " + this.getOutputValue() + "\n";
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getFullName();
    }
}

