/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.models.StdLogic1164;
import hades.models.dsp.GenericDspOperator;
import hades.signals.Signal;
import hades.simulator.SimObject;

public class CounterWrapAround
extends GenericDspOperator {
    protected int count = 0;

    public CounterWrapAround() {
        this.setControlInputPortNames("C", "NR");
        this.setOutputPortNames("Y");
        this.setComment("counter with reset and limit");
        this.setD0(128.0);
    }

    public void setD0(double d) {
        super.setD0(d);
        if (d <= (double)this.count) {
            this.count = 0;
        }
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "propagation delay [secs]:", "delay", "counter limit: ", "d0"};
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()...");
        }
        Signal signal_C = this.controlPorts[0].getSignal();
        StdLogic1164 value_C = this.controlPorts[0].getValueOrU();
        StdLogic1164 value_NR = this.controlPorts[1].getValueOrU();
        if (value_NR.is_0L()) {
            this.setOutputValue(0.0);
        } else if (!value_NR.is_1H()) {
            this.setOutputValue(Double.NaN);
        } else if (signal_C == null) {
            this.setOutputValue(Double.NaN);
        } else if (value_C.is_UXZ()) {
            this.setOutputValue(Double.NaN);
        } else if (signal_C.hasEvent() && value_C.is_1H()) {
            ++this.count;
            if ((double)this.count >= this.getD0()) {
                this.count = 0;
            }
            this.setOutputValue(this.count);
        } else if (value_C.is_0L() || value_C.is_1H()) {
            return;
        }
        this.scheduleOutputValueAfterDelay();
    }
}

