/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dcf77;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.Design;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.Label;
import hades.symbols.TextSource;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Dcf77Sender
extends SimObject
implements Wakeable {
    private static final long serialVersionUID = -2793689596248976566L;
    private int seconds;
    private int minutes;
    private int hours;
    private int day;
    private int weekday;
    private int month;
    private int year;
    private double noise;
    private boolean[] dcfCode;
    StdLogic1164 value_X;
    StdLogic1164 value_0;
    StdLogic1164 value_1;
    PortStdLogic1164 port_dcf = new PortStdLogic1164(this, "dcf77", 1, null);
    Signal signal_dcf;
    Label timelabel;
    Label datelabel;

    public Dcf77Sender() {
        this.ports = new Port[1];
        this.ports[0] = this.port_dcf;
        this.dcfCode = new boolean[60];
        TimeZone tz = TimeZone.getTimeZone("GMT");
        tz.setRawOffset(3600000);
        GregorianCalendar gc = new GregorianCalendar(tz);
        Date date = new Date();
        gc.setTime(date);
        this.seconds = gc.get(13);
        this.minutes = gc.get(12);
        this.hours = gc.get(11);
        this.day = gc.get(5);
        this.weekday = gc.get(7);
        this.month = gc.get(2) + 1;
        this.year = gc.get(1) % 100;
        if (SimObject.debug) {
            this.message("-I- Dcf77Sender<init>: " + this);
        }
        this.noise = 0.0;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.hours = Integer.parseInt(st.nextToken());
            this.minutes = Integer.parseInt(st.nextToken());
            this.seconds = Integer.parseInt(st.nextToken());
            this.day = Integer.parseInt(st.nextToken());
            this.month = Integer.parseInt(st.nextToken());
            this.year = Integer.parseInt(st.nextToken());
            this.weekday = Integer.parseInt(st.nextToken());
            this.noise = Double.valueOf(st.nextToken());
            if (SimObject.debug) {
                this.message("Dcf77Sender.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- Dcf77Sender.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.hours + " " + this.minutes + " " + this.seconds + " " + this.day + " " + this.month + " " + this.year + " " + this.weekday + " " + this.noise);
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getHours() {
        return this.hours;
    }

    public int getDay() {
        return this.day;
    }

    public int getWeekday() {
        return this.weekday;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public void setSeconds(int i) {
        this.seconds = i;
    }

    public void setMinutes(int i) {
        this.minutes = i;
    }

    public void setHours(int i) {
        this.hours = i;
    }

    public void setDay(int i) {
        this.day = i;
    }

    public void setWeekday(int i) {
        this.weekday = i;
    }

    public void setMonth(int i) {
        this.month = i;
    }

    public void setYear(int i) {
        this.year = i;
    }

    public void setSeconds(String s) {
        this.seconds = this.parse(s);
    }

    public void setMinutes(String s) {
        this.minutes = this.parse(s);
    }

    public void setHours(String s) {
        this.hours = this.parse(s);
    }

    public void setDay(String s) {
        this.day = this.parse(s);
    }

    public void setWeekday(String s) {
        this.weekday = this.parse(s);
    }

    public void setMonth(String s) {
        this.month = this.parse(s) & 0xF;
    }

    public void setYear(String s) {
        this.year = this.parse(s) & 0xFF;
    }

    public double getNoise() {
        return this.noise;
    }

    public void setNoise(double d) {
        this.noise = d;
    }

    public void setNoise(String s) {
        this.noise = Double.valueOf(s);
    }

    private int parse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            this.message("-W- Dcf77Sender.parse(): illegal value. " + e);
            e.printStackTrace();
            this.message("-W- using '1' instead...");
            return 1;
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("Dcf77Sender.configure()...");
        }
        String[] data = new String[]{"instance name", "name", "hours [0 .. 23]", "hours", "minutes [0 .. 59]", "minutes", "seconds [0 .. 59]", "seconds", "day [1 .. 31]", "day", "month [1 ..12]", "month", "year[0 ..99]", "year", "noise [0.0 .. 1.0]", "noise"};
        this.propertySheet = PropertySheet.getPropertySheet(this, data);
        this.propertySheet.setHelpText("Specify the instance name and the time to send,\nwhich is one minute ahead of 'real time': ");
        this.propertySheet.setVisible(true);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug && this.signal_dcf == null) {
            this.message("-W- Dcf77Sender.elaborate(): output not connected,");
            this.message("-W- but elaborating anyway...");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            if (SimObject.debug) {
                this.message("-E- Dcf77Sender.elaborate(): simulator=null, cannot start!");
            }
            return;
        }
        this.wakeup(arg);
    }

    public void wakeup(Object arg) {
        if (this.hackToCheckWhetherDeleted()) {
            return;
        }
        this.encodeTime();
        this.sendTime();
        this.incrementTime();
        this.updateDisplay();
    }

    public boolean hackToCheckWhetherDeleted() {
        SimObject tmp = this.getParent();
        if (tmp == null) {
            return true;
        }
        SimObject shadow = ((Design)tmp).getComponent(this.getName());
        return this != shadow;
    }

    public void encodeTime() {
        boolean check = false;
        int i = 0;
        while (i <= 14) {
            this.dcfCode[i] = false;
            ++i;
        }
        int i2 = 15;
        while (i2 <= 19) {
            this.dcfCode[i2] = false;
            ++i2;
        }
        this.dcfCode[20] = true;
        int i3 = 21;
        while (i3 <= 24) {
            this.dcfCode[i3] = (this.getMinutes() % 10 & 1 << i3 - 21) > 0;
            ++i3;
        }
        int i4 = 25;
        while (i4 <= 27) {
            this.dcfCode[i4] = (this.getMinutes() / 10 & 1 << i4 - 25) > 0;
            ++i4;
        }
        check = false;
        int i5 = 21;
        while (i5 <= 27) {
            check ^= this.dcfCode[i5];
            ++i5;
        }
        this.dcfCode[28] = check;
        int i6 = 29;
        while (i6 <= 32) {
            this.dcfCode[i6] = (this.getHours() % 10 & 1 << i6 - 29) > 0;
            ++i6;
        }
        int i7 = 33;
        while (i7 <= 34) {
            this.dcfCode[i7] = (this.getHours() / 10 & 1 << i7 - 33) > 0;
            ++i7;
        }
        check = false;
        int i8 = 29;
        while (i8 <= 34) {
            check ^= this.dcfCode[i8];
            ++i8;
        }
        this.dcfCode[35] = check;
        int i9 = 36;
        while (i9 <= 39) {
            this.dcfCode[i9] = (this.getDay() % 10 & 1 << i9 - 36) > 0;
            ++i9;
        }
        int i10 = 40;
        while (i10 <= 41) {
            this.dcfCode[i10] = (this.getDay() / 10 & 1 << i10 - 40) > 0;
            ++i10;
        }
        int i11 = 42;
        while (i11 <= 44) {
            this.dcfCode[i11] = (this.getWeekday() % 10 & 1 << i11 - 42) > 0;
            ++i11;
        }
        int i12 = 45;
        while (i12 <= 48) {
            this.dcfCode[i12] = (this.getMonth() % 10 & 1 << i12 - 45) > 0;
            ++i12;
        }
        this.dcfCode[49] = this.getMonth() / 10 > 0;
        int i13 = 50;
        while (i13 <= 53) {
            this.dcfCode[i13] = (this.getYear() % 10 & 1 << i13 - 50) > 0;
            ++i13;
        }
        int i14 = 54;
        while (i14 <= 57) {
            this.dcfCode[i14] = (this.getYear() / 10 & 1 << i14 - 54) > 0;
            ++i14;
        }
        check = false;
        int i15 = 36;
        while (i15 <= 57) {
            check ^= this.dcfCode[i15];
            ++i15;
        }
        this.dcfCode[58] = check;
    }

    public void sendTime() {
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime();
        simulator.scheduleWakeup(this, time + 1.0, this);
        Signal signal_dcf = this.port_dcf.getSignal();
        if (signal_dcf == null) {
            return;
        }
        if (this.seconds == 59) {
            if (SimObject.debug) {
                this.message(this.toString() + " sending a minute");
            }
        } else if (this.dcfCode[this.seconds]) {
            if (SimObject.debug) {
                this.message(this.toString() + " sending a 1");
            }
            simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_dcf, time, this.value_0, (Object)this.port_dcf));
            simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_dcf, time + 0.2, this.value_1, (Object)this.port_dcf));
        } else {
            if (SimObject.debug) {
                this.message(this.toString() + " sending a 0");
            }
            simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_dcf, time, this.value_0, (Object)this.port_dcf));
            simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_dcf, time + 0.1, this.value_1, (Object)this.port_dcf));
        }
    }

    public void incrementTime() {
        if (SimObject.debug) {
            this.message(this.toString() + ".incrementTime...");
        }
        ++this.seconds;
        if (this.seconds >= 60) {
            this.seconds = 0;
            ++this.minutes;
        }
        if (this.minutes >= 60) {
            this.minutes = 0;
            ++this.hours;
        }
        if (this.hours >= 24) {
            this.hours = 0;
            ++this.day;
            ++this.weekday;
            this.message("-W- Dcf77Sender.incrementTime(): incremented day..., ");
            this.message("-W- but the result may be incorrect/inconsistent!");
        }
    }

    private void updateDisplay() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.timelabel == null) {
            Point pos = this.symbol.getPos();
            this.timelabel = new Label();
            this.datelabel = new Label();
            this.timelabel.initialize(" " + (pos.x + 300) + " " + (pos.y + 1400) + " 0:0:0");
            this.datelabel.initialize(" " + (pos.x + 300) + " " + (pos.y + 1800) + " 0/0/0");
            this.symbol.addMember(this.datelabel);
            this.symbol.addMember(this.timelabel);
            this.timelabel.setTextSource(new TimeFormatter());
            this.datelabel.setTextSource(new DateFormatter());
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 100);
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "time= " + this.hours + ":" + this.minutes + ":" + this.seconds + "\n" + "date= " + this.day + "/" + this.month + "/" + this.year + "";
    }

    public String toString() {
        return "DCF77Sender '" + this.getFullName() + "[time=" + this.hours + ":" + this.minutes + ":" + this.seconds + " day=" + this.day + "/" + this.month + "/" + this.year + "]";
    }

    class DateFormatter
    implements TextSource {
        DateFormatter() {
        }

        public String getText() {
            return "" + Dcf77Sender.this.day + "/" + Dcf77Sender.this.month + "/" + Dcf77Sender.this.year;
        }
    }

    class TimeFormatter
    implements TextSource {
        TimeFormatter() {
        }

        public String getText() {
            return "" + Dcf77Sender.this.hours + ":" + Dcf77Sender.this.minutes + ":" + Dcf77Sender.this.seconds;
        }
    }
}

