/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dcf77;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.BboxRectangle;
import hades.symbols.ClassLabel;
import hades.symbols.InstanceLabel;
import hades.symbols.Label;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import jfig.objects.FigAttribs;

public class Dcf77Clock
extends SimObject
implements Wakeable {
    private static final long serialVersionUID = 2488844183198801360L;
    private int seconds;
    private int minutes;
    private int hours;
    private int day;
    private int weekday;
    private int month;
    private int year;
    private PortStdLogic1164 port_dcf;
    private Label timelabel;
    private Label datelabel;
    private int state;
    private int waitcycles;
    private int[] values;
    private int valueIndex;
    private boolean valueIndexIsValid;
    private int dbglevel = 0;
    public static final int S_UNKNOWN = 0;
    public static final int S_0XXX = 1;
    public static final int S_00XX = 2;
    public static final int S_000X = 3;
    public static final int S_0000 = 4;
    public static final int S_001X = 5;
    public static final int S_0011 = 6;
    public static final int S_WAIT = 7;
    public static final int S_MINUTE = 10;

    public Dcf77Clock() {
        if (this.dbglevel > 0) {
            this.message("-I- Dcf77Clock<init> started...");
        }
        this.ports = new Port[1];
        this.port_dcf = new PortStdLogic1164(this, "dcf_in", 0, null);
        this.ports[0] = this.port_dcf;
        this.simulator = null;
        this.state = 0;
        this.waitcycles = 0;
        this.valueIndex = 0;
        this.valueIndexIsValid = false;
        this.values = new int[60];
        this.day = 0;
        this.month = 0;
        this.year = 0;
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        this.symbol = new Symbol();
        this.symbol.setParent(this);
        BboxRectangle bbr = new BboxRectangle();
        bbr.initialize("0 0 4800 3600");
        ClassLabel classlabel = new ClassLabel();
        classlabel.initialize("600 450 Dcf77_Clock");
        InstanceLabel ilabel = new InstanceLabel();
        ilabel.initialize("600 3500 " + this.getName());
        PortSymbol portsymbol = new PortSymbol();
        portsymbol.initialize("0 3000 dcf_in");
        PortLabel portlabel = new PortLabel();
        portlabel.initialize("150 3100 dcf_in");
        this.timelabel = new Label();
        this.timelabel.initialize("1200 1500 " + this.getTimeString());
        this.datelabel = new Label();
        this.datelabel.initialize("1200 2100 " + this.getDateString());
        Rectangle border = new Rectangle();
        border.initialize("0 0 4800 3600");
        Rectangle back = new Rectangle();
        back.initialize(" 600 1000 4200 2400");
        FigAttribs attr = back.getAttributes();
        attr.currentLayer = 50;
        attr.fillColor = new Color(220, 220, 220);
        attr.fillStyle = 2;
        back.setAttributes(attr);
        this.symbol.addMember(bbr);
        this.symbol.addMember(classlabel);
        this.symbol.addMember(ilabel);
        this.symbol.addMember(portsymbol);
        this.symbol.addMember(portlabel);
        this.symbol.addMember(this.timelabel);
        this.symbol.addMember(this.datelabel);
        this.symbol.addMember(border);
        this.symbol.addMember(back);
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getHours() {
        return this.hours;
    }

    public int getDay() {
        return this.day;
    }

    public int getWeekday() {
        return this.weekday;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public void setSeconds(int i) {
        this.seconds = i;
    }

    public void setMinutes(int i) {
        this.minutes = i;
    }

    public void setHours(int i) {
        this.hours = i;
    }

    public void setDay(int i) {
        this.day = i;
    }

    public void setWeekday(int i) {
        this.weekday = i;
    }

    public void setMonth(int i) {
        this.month = i;
    }

    public void setYear(int i) {
        this.year = i;
    }

    public void setSeconds(String s) {
        this.seconds = this.parse(s);
    }

    public void setMinutes(String s) {
        this.minutes = this.parse(s);
    }

    public void setHours(String s) {
        this.hours = this.parse(s);
    }

    public void setDay(String s) {
        this.day = this.parse(s);
    }

    public void setWeekday(String s) {
        this.weekday = this.parse(s);
    }

    public void setMonth(String s) {
        this.month = this.parse(s);
    }

    public void setYear(String s) {
        this.year = this.parse(s) & 0xFF;
    }

    private int parse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            this.message("-W- Dcf77Clock.parse(): illegal value. " + s);
            this.message("-W- using '1' instead...");
            e.printStackTrace();
            return 1;
        }
    }

    public int getDbglevel() {
        return this.dbglevel;
    }

    public void setDbglevel(int i) {
        this.dbglevel = i;
    }

    public void setDbglevel(String s) {
        this.dbglevel = this.parse(s);
    }

    public String getTimeString() {
        return "" + this.hours + ":" + this.minutes + ":" + this.seconds;
    }

    public String getDateString() {
        return "" + this.day + "/" + this.month + "/" + this.year;
    }

    public void configure() {
        if (this.dbglevel > 0) {
            this.message("Dcf77Clock.configure()...");
        }
        String[] fields = new String[]{"instance name", "name", "debug level [0..3]", "dbglevel"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify the time to send:");
        this.propertySheet.setVisible(true);
    }

    public void wakeup(Object arg) {
        if (SimObject.debug || this.dbglevel > 1) {
            this.message("-I- DcfClock.wakeup() at time= " + this.simulator.getSimTime());
        }
        StdLogic1164 value_dcf = null;
        this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + 0.05, this);
        Signal signal_dcf = this.port_dcf.getSignal();
        if (signal_dcf == null) {
            this.state = 0;
            ++this.waitcycles;
            if (this.waitcycles >= 20) {
                this.incrementTime();
                this.updateDisplay();
                this.waitcycles = 0;
            }
            return;
        }
        value_dcf = (StdLogic1164)signal_dcf.getValue();
        if (SimObject.debug || this.dbglevel > 1) {
            this.message("-I- state= " + this.state + " input= " + value_dcf + " at time= " + this.simulator.getSimTime() + " waitccycles= " + this.waitcycles);
        }
        switch (this.state) {
            case 0: {
                this.state = value_dcf.is_0() ? 1 : 0;
                ++this.waitcycles;
                if (this.waitcycles >= 20) {
                    this.incrementTime();
                    this.updateDisplay();
                    this.waitcycles = 0;
                }
                this.valueIndexIsValid = false;
                this.valueIndex = 0;
                break;
            }
            case 1: {
                this.state = value_dcf.is_0() ? 2 : 0;
                this.incrementTime();
                this.updateDisplay();
                break;
            }
            case 2: {
                if (value_dcf.is_0()) {
                    this.state = 3;
                    break;
                }
                if (value_dcf.is_1()) {
                    this.state = 5;
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (value_dcf.is_0()) {
                    this.state = 4;
                    break;
                }
                this.state = 0;
                break;
            }
            case 5: {
                if (value_dcf.is_1()) {
                    this.state = 6;
                    break;
                }
                this.state = 0;
                break;
            }
            case 6: {
                this.pushValue(0);
                this.waitcycles = 0;
                this.state = 7;
                break;
            }
            case 4: {
                this.pushValue(1);
                this.waitcycles = 0;
                this.state = 7;
                break;
            }
            case 7: {
                if (value_dcf.is_0()) {
                    if (this.waitcycles >= 14 && this.waitcycles <= 16) {
                        this.waitcycles = 0;
                        this.state = 1;
                        break;
                    }
                    if (this.waitcycles >= 34 && this.waitcycles <= 36) {
                        this.waitcycles = 0;
                        this.state = 10;
                        break;
                    }
                    this.waitcycles = 0;
                    this.message("-W- S_WAIT: got a zero after " + this.waitcycles + " cycles, should not happen!");
                    this.state = 0;
                    break;
                }
                if (value_dcf.is_1()) {
                    ++this.waitcycles;
                    if (this.waitcycles <= 37) break;
                    this.message("-W- S_WAIT: got no signal for " + this.waitcycles + " cycles...");
                    this.state = 0;
                    break;
                }
                this.state = 0;
                break;
            }
            case 10: {
                if (this.dbglevel > 0) {
                    this.message("-I- found a minute signal!");
                }
                this.decodeValues();
                if (value_dcf.is_0()) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            default: {
                this.message("-E- Dcf77Clock.wakeup(): reached default state?!");
                this.state = 0;
            }
        }
    }

    private void pushValue(int v) {
        if (this.valueIndexIsValid) {
            if (SimObject.debug || this.dbglevel > 1) {
                this.message("-I- Dcf77Clock.pushValue(): got a '" + v + "' at index " + this.valueIndex);
            }
            this.values[this.valueIndex] = v;
            ++this.valueIndex;
        } else if (SimObject.debug || this.dbglevel > 1) {
            this.message("-W- Dcf77Clock.pushValue(): got a '" + v + "' but index not valid yet!");
        }
        if (this.valueIndex >= this.values.length) {
            this.message("-E- Dcf77Clock.pushValue(): valueIndex overflow...");
            this.valueIndex = 0;
            this.valueIndexIsValid = false;
            this.state = 0;
        }
    }

    private void decodeValues() {
        if (this.dbglevel > 0) {
            this.message("-I- decodeValues(): ");
        }
        String s = "";
        int i = 0;
        while (i < this.values.length) {
            s = this.values[i] == 1 ? s + '1' : s + '0';
            ++i;
        }
        if (this.dbglevel > 0) {
            this.message(s);
        }
        if (this.valueIndexIsValid) {
            this.seconds = 0;
            this.minutes = this.values[21] + 2 * this.values[22] + 4 * this.values[23] + 8 * this.values[24] + 10 * this.values[25] + 20 * this.values[26] + 40 * this.values[27];
            this.hours = this.values[29] + 2 * this.values[30] + 4 * this.values[31] + 8 * this.values[32] + 10 * this.values[33] + 20 * this.values[34];
            this.day = this.values[36] + 2 * this.values[37] + 4 * this.values[38] + 8 * this.values[39] + 10 * this.values[40] + 20 * this.values[41];
            this.month = this.values[45] + 2 * this.values[46] + 4 * this.values[47] + 8 * this.values[48] + 10 * this.values[49];
            this.year = this.values[50] + 2 * this.values[51] + 4 * this.values[52] + 8 * this.values[53] + 10 * this.values[54] + 20 * this.values[55] + 40 * this.values[56] + 80 * this.values[57];
            if (this.dbglevel > 0) {
                this.message("-I- decoded: " + this.toString() + '\n');
            }
            this.updateDisplay();
        }
        this.valueIndexIsValid = true;
        this.valueIndex = 0;
    }

    private void updateDisplay() {
        if (this.timelabel != null) {
            this.timelabel.setText("" + this.hours + ":" + this.minutes + ":" + this.seconds);
            if (this.valueIndexIsValid) {
                this.datelabel.setText("" + this.day + "/" + this.month + "/" + this.year);
            } else {
                this.datelabel.setText("--/--/--");
            }
            this.getSymbol().painter.paint(this.getSymbol(), 100);
        } else {
            this.message("-W- timelabel is null?!");
        }
    }

    private void incrementTime() {
        ++this.seconds;
        if (this.seconds >= 60) {
            this.seconds = 0;
            ++this.minutes;
        }
        if (this.minutes >= 60) {
            this.minutes = 0;
            ++this.hours;
        }
        if (this.hours >= 24) {
            ++this.hours;
        }
        this.updateDisplay();
    }

    public void elaborate(Object arg) {
        this.message("-I- Dcf77Clock.elaborate: " + arg);
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            this.message("-E- DcfClock.elaborate(): Simulator is null, cannot start!");
            return;
        }
        this.simulator.scheduleWakeup(this, this.simulator.getSimTime(), this);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug || this.dbglevel > 2) {
            this.message("-I- Dcf77Clock.evaluate(), ignoring: " + arg);
        }
    }

    public String toString() {
        return "" + this.getClass().getName() + "'" + this.getFullName() + "'" + "[time= " + this.hours + ":" + this.minutes + ":" + this.seconds + ", date= " + this.day + "/" + this.month + "/" + this.year + "]";
    }
}

